/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.network.transmitter;

import com.jerry.mekextras.common.tier.transmitter.CTier;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.acceptor.EnergyAcceptorCache;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.upgrade.transmitter.UniversalCableUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraUniversalCable
extends UniversalCable
implements IMekanismStrictEnergyHandler,
IExtraUpgradeableTransmitter<UniversalCableUpgradeData> {
    public ExtraUniversalCable(Holder<Block> blockProvider, TileEntityExtraTransmitter tile) {
        super(blockProvider, (TileEntityTransmitter)tile);
    }

    public void pullFromAcceptors() {
        if (!this.hasPullSide || this.getAvailablePull() <= 0L) {
            return;
        }
        EnergyAcceptorCache acceptorCache = this.getAcceptorCache();
        for (Direction side : EnumUtils.DIRECTIONS) {
            long received;
            IStrictEnergyHandler connectedAcceptor;
            if (!this.isConnectionType(side, ConnectionType.PULL) || (connectedAcceptor = (IStrictEnergyHandler)acceptorCache.getConnectedAcceptor(side)) == null || (received = connectedAcceptor.extractEnergy(this.getAvailablePull(), Action.SIMULATE)) <= 0L || this.takeEnergy(received, Action.SIMULATE) != 0L) continue;
            long remainder = this.takeEnergy(received, Action.EXECUTE);
            connectedAcceptor.extractEnergy(received - remainder, Action.EXECUTE);
        }
    }

    private long getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.getCapacity(), ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.getNeeded());
        }
        return Math.min(this.getCapacity(), this.buffer.getNeeded());
    }

    @NotNull
    public long getCapacityAsFloatingLong() {
        return CTier.getCapacityAsLong(this.tier);
    }

    public long getCapacity() {
        return CTier.getCapacityAsLong(this.tier);
    }

    private long takeEnergy(long amount, Action action) {
        if (this.hasTransmitterNetwork()) {
            return ((EnergyNetwork)this.getTransmitterNetwork()).energyContainer.insert(amount, action, AutomationType.INTERNAL);
        }
        return this.buffer.insert(amount, action, AutomationType.INTERNAL);
    }

    protected void handleContentsUpdateTag(@NotNull EnergyNetwork network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleContentsUpdateTag(network, tag, provider);
        NBTUtils.setLegacyEnergyIfPresent((CompoundTag)tag, (String)"energy", arg_0 -> ((VariableCapacityEnergyContainer)network.energyContainer).setEnergy(arg_0));
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            network.currentScale = scale;
        });
    }

    @Override
    @Nullable
    public UniversalCableUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull UniversalCableUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

