/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.content.network.transmitter;

import com.jerry.mekextras.common.capabilities.heat.ExtraVariableHeatCapacitor;
import com.jerry.mekextras.common.tier.transmitter.TCTier;
import com.jerry.mekextras.common.tile.transmitter.TileEntityExtraTransmitter;
import com.jerry.mekextras.common.util.IExtraUpgradeableTransmitter;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.content.network.HeatNetwork;
import mekanism.common.content.network.transmitter.ThermodynamicConductor;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.ThermodynamicConductorUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraThermodynamicConductor
extends ThermodynamicConductor
implements ITileHeatHandler,
IExtraUpgradeableTransmitter<ThermodynamicConductorUpgradeData> {
    private final CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(() -> ((ExtraThermodynamicConductor)this).getLevel(), () -> ((ExtraThermodynamicConductor)this).getBlockPos());
    public final ConductorTier tier;
    private double clientTemperature = -1.0;
    private final List<IHeatCapacitor> capacitors;
    public final ExtraVariableHeatCapacitor buffer;

    public ExtraThermodynamicConductor(Holder<Block> blockProvider, TileEntityExtraTransmitter tile) {
        super(blockProvider, (TileEntityTransmitter)tile);
        this.tier = (ConductorTier)Attribute.getTier(blockProvider, ConductorTier.class);
        this.buffer = ExtraVariableHeatCapacitor.create(TCTier.getHeatCapacity(this.tier), TCTier.getConduction(this.tier), TCTier.getConductionInsulation(this.tier), (DoubleSupplier)this.ambientTemperature, (IContentsListener)this);
        this.capacitors = Collections.singletonList(this.buffer);
    }

    protected AbstractAcceptorCache<IHeatHandler, ?> createAcceptorCache() {
        return super.createAcceptorCache();
    }

    public AcceptorCache<IHeatHandler> getAcceptorCache() {
        return super.getAcceptorCache();
    }

    public void takeShare() {
        super.takeShare();
    }

    protected boolean isValidAcceptor(@Nullable BlockEntity tile, Direction side) {
        return this.getAcceptorCache().getConnectedAcceptor(side) != null;
    }

    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        super.write(provider, tag);
        ContainerType.HEAT.saveTo(provider, tag, this.getHeatCapacitors(null));
        return tag;
    }

    public void read(HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        super.read(provider, tag);
        ContainerType.HEAT.readFrom(provider, tag, this.getHeatCapacitors(null));
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(provider, updateTag);
        updateTag.putDouble("temperature", this.buffer.getHeat());
        return updateTag;
    }

    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.capacitors;
    }

    public boolean handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        boolean refreshModelData = super.handleUpdateTag(tag, provider);
        NBTUtils.setDoubleIfPresent((CompoundTag)tag, (String)"temperature", arg_0 -> ((ExtraVariableHeatCapacitor)this.buffer).setHeat(arg_0));
        return refreshModelData;
    }

    public void onContentsChanged() {
        if (!this.isRemote()) {
            if (this.clientTemperature == -1.0) {
                this.clientTemperature = this.ambientTemperature.getAsDouble();
            }
            if (Math.abs(this.buffer.getTemperature() - this.clientTemperature) > this.buffer.getTemperature() / 20.0) {
                this.clientTemperature = this.buffer.getTemperature();
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
        this.getTransmitterTile().setChanged();
    }

    public double getAmbientTemperature(@NotNull Direction side) {
        return this.ambientTemperature.getTemperature(side);
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (ExtraThermodynamicConductor.connectionMapContainsSide((byte)this.getAllCurrentConnections(), (Direction)side)) {
            return (IHeatHandler)this.getAcceptorCache().getConnectedAcceptor(side);
        }
        return null;
    }

    public double incrementAdjacentTransfer(double currentAdjacentTransfer, double tempToTransfer, @NotNull Direction side) {
        HeatNetwork transmitterNetwork;
        ThermodynamicConductor adjacent;
        if (tempToTransfer > 0.0 && this.hasTransmitterNetwork() && (adjacent = (ThermodynamicConductor)(transmitterNetwork = (HeatNetwork)this.getTransmitterNetwork()).getTransmitter(this.getBlockPos().relative(side))) != null) {
            return currentAdjacentTransfer;
        }
        return super.incrementAdjacentTransfer(currentAdjacentTransfer, tempToTransfer, side);
    }

    @Override
    @Nullable
    public ThermodynamicConductorUpgradeData getUpgradeData() {
        return super.getUpgradeData();
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return super.dataTypeMatches(data);
    }

    @Override
    public void parseUpgradeData(@NotNull ThermodynamicConductorUpgradeData data) {
        super.parseUpgradeData(data);
    }
}

