/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.config;

import com.jerry.mekextras.common.config.ExtraConfigTranslations;
import com.jerry.mekextras.common.tier.BTier;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.tier.ECTier;
import com.jerry.mekextras.common.tier.ExtraQIODriveTier;
import com.jerry.mekextras.common.tier.FTTier;
import com.jerry.mekextras.common.tier.ICTier;
import com.jerry.mekextras.common.tier.IPTier;
import com.jerry.mekextras.common.tier.RWBTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.Locale;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IConfigTranslation;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ExtraTierConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;
    public final CachedLongValue absoluteUniversalCableCapacity;
    public final CachedLongValue supremeUniversalCableCapacity;
    public final CachedLongValue cosmicUniversalCableCapacity;
    public final CachedLongValue infiniteUniversalCableCapacity;
    public final CachedLongValue absoluteMechanicalPipeCapacity;
    public final CachedLongValue absoluteMechanicalPipePullAmount;
    public final CachedLongValue supremeMechanicalPipeCapacity;
    public final CachedLongValue supremeMechanicalPipePullAmount;
    public final CachedLongValue cosmicMechanicalPipeCapacity;
    public final CachedLongValue cosmicMechanicalPipePullAmount;
    public final CachedLongValue infiniteMechanicalPipeCapacity;
    public final CachedLongValue infiniteMechanicalPipePullAmount;
    public final CachedLongValue absolutePressurizedTubeCapacity;
    public final CachedLongValue absolutePressurizedTubePullAmount;
    public final CachedLongValue supremePressurizedTubeCapacity;
    public final CachedLongValue supremePressurizedTubePullAmount;
    public final CachedLongValue cosmicPressurizedTubeCapacity;
    public final CachedLongValue cosmicPressurizedTubePullAmount;
    public final CachedLongValue infinitePressurizedTubeCapacity;
    public final CachedLongValue infinitePressurizedTubePullAmount;
    public final CachedLongValue absoluteLogisticalTransporterSpeed;
    public final CachedLongValue absoluteLogisticalTransporterPullAmount;
    public final CachedLongValue supremeLogisticalTransporterSpeed;
    public final CachedLongValue supremeLogisticalTransporterPullAmount;
    public final CachedLongValue cosmicLogisticalTransporterSpeed;
    public final CachedLongValue cosmicLogisticalTransporterPullAmount;
    public final CachedLongValue infiniteLogisticalTransporterSpeed;
    public final CachedLongValue infiniteLogisticalTransporterPullAmount;
    public final CachedLongValue absoluteThermodynamicConductorConduction;
    public final CachedLongValue absoluteThermodynamicConductorCapacity;
    public final CachedLongValue absoluteThermodynamicConductorInsulation;
    public final CachedLongValue supremeThermodynamicConductorConduction;
    public final CachedLongValue supremeThermodynamicConductorCapacity;
    public final CachedLongValue supremeThermodynamicConductorInsulation;
    public final CachedLongValue cosmicThermodynamicConductorConduction;
    public final CachedLongValue cosmicThermodynamicConductorCapacity;
    public final CachedLongValue cosmicThermodynamicConductorInsulation;
    public final CachedLongValue infiniteThermodynamicConductorConduction;
    public final CachedLongValue infiniteThermodynamicConductorCapacity;
    public final CachedLongValue infiniteThermodynamicConductorInsulation;

    ExtraTierConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.addQIODriverCategory(builder);
        this.addStoragesCategory(builder);
        MekanismConfigTranslations.TIER_TRANSMITTERS.applyToBuilder(builder).push("transmitters");
        MekanismConfigTranslations.TIER_TRANSMITTERS_ENERGY.applyToBuilder(builder).push("energy");
        this.absoluteUniversalCableCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_UNIVERSAL_CABLE_CAPACITY, (String)"absoluteCapacity", (long)65536000L, (long)1L, (long)Long.MAX_VALUE);
        this.supremeUniversalCableCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_UNIVERSAL_CABLE_CAPACITY, (String)"supremeCapacity", (long)524288000L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicUniversalCableCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_UNIVERSAL_CABLE_CAPACITY, (String)"cosmicCapacity", (long)0xFA000000L, (long)1L, (long)Long.MAX_VALUE);
        this.infiniteUniversalCableCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_UNIVERSAL_CABLE_CAPACITY, (String)"infiniteCapacity", (long)0x7D0000000L, (long)1L, (long)Long.MAX_VALUE);
        builder.pop();
        MekanismConfigTranslations.TIER_TRANSMITTERS_FLUID.applyToBuilder(builder).push("fluid");
        this.absoluteMechanicalPipeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_MECHANICAL_PIPE_CAPACITY, (String)"absoluteCapacity", (long)1024000L, (long)1L, (long)Long.MAX_VALUE);
        this.absoluteMechanicalPipePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_MECHANICAL_PIPE_PULL_AMOUNT, (String)"absolutePullAmount", (long)256000L, (long)1L, (long)Integer.MAX_VALUE);
        this.supremeMechanicalPipeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_MECHANICAL_PIPE_CAPACITY, (String)"supremeCapacity", (long)0x7D0000L, (long)1L, (long)Long.MAX_VALUE);
        this.supremeMechanicalPipePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_MECHANICAL_PIPE_PULL_AMOUNT, (String)"supremePullAmount", (long)2048000L, (long)1L, (long)Integer.MAX_VALUE);
        this.cosmicMechanicalPipeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_MECHANICAL_PIPE_CAPACITY, (String)"cosmicCapacity", (long)65536000L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicMechanicalPipePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_MECHANICAL_PIPE_PULL_AMOUNT, (String)"cosmicPullAmount", (long)0xFA0000L, (long)1L, (long)Integer.MAX_VALUE);
        this.infiniteMechanicalPipeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_MECHANICAL_PIPE_CAPACITY, (String)"infiniteCapacity", (long)524288000L, (long)1L, (long)Long.MAX_VALUE);
        this.infiniteMechanicalPipePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_MECHANICAL_PIPE_PULL_AMOUNT, (String)"infinitePullAmount", (long)0x7D00000L, (long)1L, (long)Integer.MAX_VALUE);
        builder.pop();
        MekanismConfigTranslations.TIER_TRANSMITTERS_CHEMICAL.applyToBuilder(builder).push("chemical");
        this.absolutePressurizedTubeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_PRESSURIZED_TUBE_CAPACITY, (String)"absoluteCapacity", (long)0x7D0000L, (long)1L, (long)Long.MAX_VALUE);
        this.absolutePressurizedTubePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_PRESSURIZED_TUBE_PULL_AMOUNT, (String)"absolutePullAmount", (long)2048000L, (long)1L, (long)Long.MAX_VALUE);
        this.supremePressurizedTubeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_PRESSURIZED_TUBE_CAPACITY, (String)"supremeCapacity", (long)65536000L, (long)1L, (long)Long.MAX_VALUE);
        this.supremePressurizedTubePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_PRESSURIZED_TUBE_PULL_AMOUNT, (String)"supremePullAmount", (long)0xFA0000L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicPressurizedTubeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_PRESSURIZED_TUBE_CAPACITY, (String)"cosmicCapacity", (long)524288000L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicPressurizedTubePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_PRESSURIZED_TUBE_PULL_AMOUNT, (String)"cosmicPullAmount", (long)0x7D00000L, (long)1L, (long)Long.MAX_VALUE);
        this.infinitePressurizedTubeCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_PRESSURIZED_TUBE_CAPACITY, (String)"infiniteCapacity", (long)0xFA000000L, (long)1L, (long)Long.MAX_VALUE);
        this.infinitePressurizedTubePullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_PRESSURIZED_TUBE_PULL_AMOUNT, (String)"infinitePullAmount", (long)1048576000L, (long)1L, (long)Long.MAX_VALUE);
        builder.pop();
        MekanismConfigTranslations.TIER_TRANSMITTERS_ITEM.applyToBuilder(builder).push("item");
        this.absoluteLogisticalTransporterSpeed = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_LOGISTICAL_TRANSPORTER_SPEED, (String)"absoluteSpeed", (long)55L, (long)1L, (long)Integer.MAX_VALUE);
        this.absoluteLogisticalTransporterPullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_LOGISTICAL_TRANSPORTER_PULL_AMOUNT, (String)"absolutePullAmount", (long)128L, (long)1L, (long)Integer.MAX_VALUE);
        this.supremeLogisticalTransporterSpeed = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_LOGISTICAL_TRANSPORTER_SPEED, (String)"supremeSpeed", (long)60L, (long)1L, (long)Integer.MAX_VALUE);
        this.supremeLogisticalTransporterPullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_LOGISTICAL_TRANSPORTER_PULL_AMOUNT, (String)"supremePullAmount", (long)256L, (long)1L, (long)Integer.MAX_VALUE);
        this.cosmicLogisticalTransporterSpeed = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_LOGISTICAL_TRANSPORTER_SPEED, (String)"cosmicSpeed", (long)70L, (long)1L, (long)Integer.MAX_VALUE);
        this.cosmicLogisticalTransporterPullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_LOGISTICAL_TRANSPORTER_PULL_AMOUNT, (String)"cosmicPullAmount", (long)512L, (long)1L, (long)Integer.MAX_VALUE);
        this.infiniteLogisticalTransporterSpeed = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_LOGISTICAL_TRANSPORTER_SPEED, (String)"infiniteSpeed", (long)100L, (long)1L, (long)Integer.MAX_VALUE);
        this.infiniteLogisticalTransporterPullAmount = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_LOGISTICAL_TRANSPORTER_PULL_AMOUNT, (String)"infinitePullAmount", (long)1024L, (long)1L, (long)Integer.MAX_VALUE);
        builder.pop();
        MekanismConfigTranslations.TIER_TRANSMITTERS_HEAT.applyToBuilder(builder).push("heat");
        this.absoluteThermodynamicConductorConduction = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_THERMODYNAMIC_CONDUCTOR_CONDUCTION, (String)"absoluteConduction", (long)10L, (long)1L, (long)Long.MAX_VALUE);
        this.absoluteThermodynamicConductorCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_THERMODYNAMIC_CONDUCTOR_CAPACITY, (String)"absoluteCapacity", (long)1L, (long)1L, (long)Long.MAX_VALUE);
        this.absoluteThermodynamicConductorInsulation = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.ABSOLUTE_THERMODYNAMIC_CONDUCTOR_INSULATION, (String)"absoluteInsulation", (long)400000L, (long)1L, (long)Long.MAX_VALUE);
        this.supremeThermodynamicConductorConduction = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_THERMODYNAMIC_CONDUCTOR_CONDUCTION, (String)"supremeConduction", (long)15L, (long)1L, (long)Long.MAX_VALUE);
        this.supremeThermodynamicConductorCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_THERMODYNAMIC_CONDUCTOR_CAPACITY, (String)"supremeCapacity", (long)1L, (long)1L, (long)Long.MAX_VALUE);
        this.supremeThermodynamicConductorInsulation = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.SUPREME_THERMODYNAMIC_CONDUCTOR_INSULATION, (String)"supremeInsulation", (long)800000L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicThermodynamicConductorConduction = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_THERMODYNAMIC_CONDUCTOR_CONDUCTION, (String)"cosmicConduction", (long)20L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicThermodynamicConductorCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_THERMODYNAMIC_CONDUCTOR_CAPACITY, (String)"cosmicCapacity", (long)1L, (long)1L, (long)Long.MAX_VALUE);
        this.cosmicThermodynamicConductorInsulation = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.COSMIC_THERMODYNAMIC_CONDUCTOR_INSULATION, (String)"cosmicInsulation", (long)1000000L, (long)1L, (long)Long.MAX_VALUE);
        this.infiniteThermodynamicConductorConduction = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_THERMODYNAMIC_CONDUCTOR_CONDUCTION, (String)"infiniteConduction", (long)25L, (long)1L, (long)Long.MAX_VALUE);
        this.infiniteThermodynamicConductorCapacity = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_THERMODYNAMIC_CONDUCTOR_CAPACITY, (String)"infiniteCapacity", (long)1L, (long)1L, (long)Long.MAX_VALUE);
        this.infiniteThermodynamicConductorInsulation = CachedLongValue.define((IMekanismConfig)this, (ModConfigSpec.Builder)builder, (IConfigTranslation)ExtraConfigTranslations.INFINITE_THERMODYNAMIC_CONDUCTOR_INSULATION, (String)"infiniteInsulation", (long)4000000L, (long)1L, (long)Long.MAX_VALUE);
        builder.pop();
        builder.pop();
        this.configSpec = builder.build();
    }

    private void addQIODriverCategory(ModConfigSpec.Builder builder) {
        ExtraConfigTranslations.TIER_QIO_DRIVER.applyToBuilder(builder).push("qio_drivers");
        for (ExtraQIODriveTier tier : ExtraEnumUtils.QIO_DRIVE_TIERS) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue countReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Count", tier.getMaxCount(), 1L, Long.MAX_VALUE));
            CachedIntValue typesReference = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Type", tier.getMaxTypes(), 1, Integer.MAX_VALUE));
            tier.setConfigReference(countReference, typesReference);
        }
        builder.pop();
    }

    private void addStoragesCategory(ModConfigSpec.Builder builder) {
        this.addBinCategory(builder);
        this.addInductionCategory(builder);
        this.addEnergyCubeCategory(builder);
        this.addFluidTankCategory(builder);
        this.addGasTankCategory(builder);
        this.addRadioactiveBarrelCategory(builder);
    }

    private void addBinCategory(ModConfigSpec.Builder builder) {
        MekanismConfigTranslations.TIER_BIN.applyToBuilder(builder).push("bins");
        for (BTier tier : ExtraEnumUtils.BIN_TIERS) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedIntValue storageReference = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Storage", tier.getAdvanceStorage(), 1, Integer.MAX_VALUE));
            tier.setConfigReference(storageReference);
        }
        builder.pop();
    }

    private void addInductionCategory(ModConfigSpec.Builder builder) {
        String tierName;
        ExtraConfigTranslations.AdvancedTierTranslations translations;
        MekanismConfigTranslations.TIER_INDUCTION.applyToBuilder(builder).push("induction");
        for (ICTier iCTier : ExtraEnumUtils.INDUCTION_CELL_TIERS) {
            translations = ExtraConfigTranslations.AdvancedTierTranslations.create(iCTier);
            tierName = iCTier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Storage", iCTier.getAdvanceMaxEnergy(), 1L, Long.MAX_VALUE));
            iCTier.setConfigReference(storageReference);
        }
        for (Enum enum_ : ExtraEnumUtils.INDUCTION_PROVIDER_TIERS) {
            translations = ExtraConfigTranslations.AdvancedTierTranslations.create((IPTier)enum_);
            tierName = ((IPTier)enum_).getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", ((IPTier)enum_).getAdvanceOutput(), 1L, Long.MAX_VALUE));
            ((IPTier)enum_).setConfigReference(outputReference);
        }
        builder.pop();
    }

    private void addEnergyCubeCategory(ModConfigSpec.Builder builder) {
        MekanismConfigTranslations.TIER_ENERGY_CUBE.applyToBuilder(builder).push("energy_cubes");
        for (ECTier tier : ExtraEnumUtils.ENERGY_CUBE_TIERS) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Storage", tier.getAdvanceMaxEnergy(), 1L, Long.MAX_VALUE));
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", tier.getAdvanceOutput(), 1L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addFluidTankCategory(ModConfigSpec.Builder builder) {
        MekanismConfigTranslations.TIER_FLUID_TANK.applyToBuilder(builder).push("fluid_tanks");
        for (FTTier tier : ExtraEnumUtils.FLUID_TANK_TIERS) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedIntValue storageReference = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Storage", tier.getAdvanceStorage(), 1, Integer.MAX_VALUE));
            CachedIntValue outputReference = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", tier.getAdvanceOutput(), 1, Integer.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addGasTankCategory(ModConfigSpec.Builder builder) {
        MekanismConfigTranslations.TIER_CHEMICAL_TANK.applyToBuilder(builder).push("chemical_tanks");
        for (CTTier tier : ExtraEnumUtils.CHEMICAL_TANK_TIERS) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Storage", tier.getAdvanceStorage(), 1L, Long.MAX_VALUE));
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", tier.getAdvanceOutput(), 1L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addRadioactiveBarrelCategory(ModConfigSpec.Builder builder) {
        ExtraConfigTranslations.TIER_RADIOACTIVE_BARREL.applyToBuilder(builder).push("radioactive_barrels");
        for (RWBTier tier : ExtraEnumUtils.RADIOACTIVE_BARREL_TIER) {
            ExtraConfigTranslations.AdvancedTierTranslations translations = ExtraConfigTranslations.AdvancedTierTranslations.create(tier);
            String tierName = tier.getAdvanceTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName.toLowerCase(Locale.ROOT) + "Storage", tier.getAdvanceStorage(), 1L, Long.MAX_VALUE));
            CachedIntValue tickReference = CachedIntValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName.toLowerCase(Locale.ROOT) + "ProcessTicks", tier.getAdvanceProcessTicks(), 1, Integer.MAX_VALUE));
            CachedLongValue amountReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.third().applyToBuilder(builder).defineInRange(tierName.toLowerCase(Locale.ROOT) + "DecayAmount", tier.getAdvanceDecayAmount(), 0L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, tickReference, amountReference);
        }
        builder.pop();
    }

    public String getFileName() {
        return "tiers";
    }

    public String getTranslation() {
        return "Tier Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

