/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.capabilities.fluid;

import com.jerry.mekextras.common.tile.TileEntityExtraFluidTank;
import java.util.Objects;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraFluidTankFluidTank
extends BasicFluidTank {
    private final TileEntityExtraFluidTank tile;
    private final boolean isCreative;
    private final IntSupplier rate;

    public static ExtraFluidTankFluidTank create(TileEntityExtraFluidTank tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Fluid tank tile entity cannot be null");
        return new ExtraFluidTankFluidTank(tile, listener);
    }

    private ExtraFluidTankFluidTank(TileEntityExtraFluidTank tile, @Nullable IContentsListener listener) {
        super(tile.tier.getStorage(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), listener);
        this.tile = tile;
        this.rate = tile.tier::getOutput;
        this.isCreative = false;
    }

    protected int getInsertRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getInsertRate(automationType);
    }

    protected int getExtractRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsInt() : super.getExtractRate(automationType);
    }

    @NotNull
    public FluidStack insert(@NotNull FluidStack stack, @NotNull Action action, @NotNull AutomationType automationType) {
        TileEntityExtraFluidTank tileAbove;
        FluidStack remainder;
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            remainder = super.insert(stack, Action.SIMULATE, automationType);
            if (remainder.isEmpty()) {
                this.setStackUnchecked(stack.copyWithAmount(this.getCapacity()));
            }
        } else {
            remainder = super.insert(stack, action.combine(!this.isCreative), automationType);
        }
        if (!remainder.isEmpty() && (tileAbove = (TileEntityExtraFluidTank)WorldUtils.getTileEntity(TileEntityExtraFluidTank.class, (BlockGetter)this.tile.getLevel(), (BlockPos)this.tile.getBlockPos().above())) != null) {
            remainder = tileAbove.fluidTank.insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    public int growStack(int amount, @NotNull Action action) {
        TileEntityExtraFluidTank tileAbove;
        int grownAmount = super.growStack(amount, action);
        if (amount > 0 && grownAmount < amount && !this.tile.getActive() && (tileAbove = (TileEntityExtraFluidTank)WorldUtils.getTileEntity(TileEntityExtraFluidTank.class, (BlockGetter)this.tile.getLevel(), (BlockPos)this.tile.getBlockPos().above())) != null) {
            int leftOverToInsert = amount - grownAmount;
            FluidStack remainder = tileAbove.fluidTank.insert(this.stored.copyWithAmount(leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }

    @NotNull
    public FluidStack extract(int amount, Action action, @NotNull AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    public int setStackSize(int amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

