/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.capabilities.chemical.variable;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraVariableCapacityChemicalTank
extends BasicChemicalTank {
    private final long capacity;

    public ExtraVariableCapacityChemicalTank(long capacity, BiPredicate<ChemicalStack, @NotNull AutomationType> canExtract, BiPredicate<ChemicalStack, @NotNull AutomationType> canInsert, Predicate<ChemicalStack> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        super(capacity, canExtract, canInsert, validator, attributeValidator, listener, null);
        this.capacity = capacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long setStackSize(long amount, @NotNull Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (maxStackSize > 0L && amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        this.stored.setAmount(amount);
        this.onContentsChanged();
        return amount;
    }
}

