/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.capabilities.chemical;

import com.jerry.mekextras.common.tier.CTTier;
import java.util.Objects;
import java.util.function.LongSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraChemicalTankChemicalTank
extends BasicChemicalTank {
    private final boolean isCreative;
    private final LongSupplier rate = tier::getOutput;

    public static ExtraChemicalTankChemicalTank create(CTTier tier, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tier, "Chemical tank tier cannot be null");
        return new ExtraChemicalTankChemicalTank(tier, listener);
    }

    private ExtraChemicalTankChemicalTank(CTTier tier, @Nullable IContentsListener listener) {
        super(tier.getStorage(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), null, listener, null);
        this.isCreative = false;
    }

    protected long getInsertRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getInsertRate(automationType);
    }

    protected long getExtractRate(@Nullable AutomationType automationType) {
        return automationType == AutomationType.INTERNAL ? this.rate.getAsLong() : super.getExtractRate(automationType);
    }

    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        if (this.isCreative && this.isEmpty() && action.execute() && automationType != AutomationType.EXTERNAL) {
            ChemicalStack simulatedRemainder = super.insert(stack, Action.SIMULATE, automationType);
            if (simulatedRemainder.isEmpty()) {
                this.setStackUnchecked(stack.copyWithAmount(this.getCapacity()));
            }
            return simulatedRemainder;
        }
        return super.insert(stack, action.combine(!this.isCreative), automationType);
    }

    public ChemicalStack extract(long amount, Action action, AutomationType automationType) {
        return super.extract(amount, action.combine(!this.isCreative), automationType);
    }

    public long setStackSize(long amount, Action action) {
        return super.setStackSize(amount, action.combine(!this.isCreative));
    }
}

