/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.tileentity;

import com.jerry.mekextras.common.tile.TileEntityExtraFluidTank;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RenderExtraFluidTank
extends MekanismTileEntityRenderer<TileEntityExtraFluidTank> {
    private static final Map<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new HashMap<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>>();
    private static final Map<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new HashMap<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>>();
    private static final int stages = 1400;

    public RenderExtraFluidTank(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    protected void render(TileEntityExtraFluidTank tile, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        FluidStack fluid = tile.fluidTank.getFluid();
        float fluidScale = tile.prevScale;
        VertexConsumer buffer = null;
        if (!fluid.isEmpty() && fluidScale > 0.0f) {
            buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)RenderExtraFluidTank.getFluidModel(fluid, fluidScale), (PoseStack)matrix, (VertexConsumer)buffer, (int)MekanismRenderer.getColorARGB((FluidStack)fluid, (float)fluidScale), (int)MekanismRenderer.calculateGlowLight((int)light, (FluidStack)fluid), (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.getBlockPos());
        }
        if (!tile.valveFluid.isEmpty() && !MekanismUtils.lighterThanAirGas((FluidStack)tile.valveFluid)) {
            if (buffer == null) {
                buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
            }
            MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getValveModel(tile.valveFluid, fluidScale), (PoseStack)matrix, (VertexConsumer)buffer, (int)MekanismRenderer.getColorARGB((FluidStack)tile.valveFluid), (int)MekanismRenderer.calculateGlowLight((int)light, (FluidStack)tile.valveFluid), (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)this.getCamera(), (BlockPos)tile.getBlockPos());
        }
    }

    @NotNull
    protected String getProfilerSection() {
        return "fluidTank";
    }

    private MekanismRenderer.Model3D getValveModel(@NotNull FluidStack fluid, float fluidScale) {
        int stage;
        Int2ObjectMap modelMap = cachedValveFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap());
        MekanismRenderer.Model3D model = (MekanismRenderer.Model3D)modelMap.get(stage = Math.min(1399, (int)(fluidScale * 1399.0f)));
        if (model == null) {
            model = new MekanismRenderer.Model3D().setSideRender(side -> side.getAxis().isHorizontal()).prepFlowing(fluid).xBounds(0.3225f, 0.6775f).yBounds(0.12375f + 0.7525f * ((float)stage / 1400.0f), 0.87625f).zBounds(0.3225f, 0.6775f);
            modelMap.put(stage, (Object)model);
        }
        return model;
    }

    public static MekanismRenderer.Model3D getFluidModel(@NotNull FluidStack fluid, float fluidScale) {
        int stage;
        Int2ObjectMap modelMap = cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap());
        MekanismRenderer.Model3D model = (MekanismRenderer.Model3D)modelMap.get(stage = ModelRenderer.getStage((FluidStack)fluid, (int)1400, (double)fluidScale));
        if (model == null) {
            model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture((FluidStack)fluid, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL)).setSideRender(Direction.DOWN, false).setSideRender(Direction.UP, stage < 1400).xBounds(0.135f, 0.865f).yBounds(0.12375f, 0.124f + 0.75225f * ((float)stage / 1400.0f)).zBounds(0.135f, 0.865f);
            modelMap.put(stage, (Object)model);
        }
        return model;
    }
}

