/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.tileentity;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.client.model.ColorModelEnergyCore;
import com.jerry.mekextras.common.tile.TileEntityExtraEnergyCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.api.SupportsColorMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@NothingNullByDefault
public class RenderExtraEnergyCube
extends ModelTileEntityRenderer<TileEntityExtraEnergyCube, ColorModelEnergyCore> {
    public static final Axis coreVec = Axis.of((Vector3f)new Vector3f(0.0f, MekanismUtils.ONE_OVER_ROOT_TWO, MekanismUtils.ONE_OVER_ROOT_TWO));

    public RenderExtraEnergyCube(BlockEntityRendererProvider.Context context) {
        super(context, ColorModelEnergyCore::new);
    }

    protected void render(@NotNull TileEntityExtraEnergyCube tile, float partialTick, @NotNull PoseStack matrix, MultiBufferSource renderer, int light, final int overlayLight, ProfilerFiller profiler) {
        final float energyScale = tile.getEnergyScale();
        final Vec3 renderPos = tile.getBlockPos().getCenter();
        final AdvancedTier advancedTier = tile.getAdvanceTier().getAdvanceTier();
        RenderTickHandler.addTransparentRenderer((RenderTickHandler.LazyRender)new RenderTickHandler.LazyRender(){

            public void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                float ticks = (float)renderTick + partialTick;
                float scaledTicks = 4.0f * ticks;
                poseStack.pushPose();
                Vec3 offset = renderPos.subtract(camera.getPosition());
                poseStack.translate(offset.x, offset.y, offset.z);
                poseStack.scale(0.4f, 0.4f, 0.4f);
                poseStack.translate(0.0, Math.sin(Math.toRadians(3.0f * ticks)) / 7.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(scaledTicks));
                poseStack.mulPose(coreVec.rotationDegrees(36.0f + scaledTicks));
                ((ColorModelEnergyCore)RenderExtraEnergyCube.this.model).render(poseStack, buffer, 0xF000F0, overlayLight, (SupportsColorMap)advancedTier, energyScale);
                poseStack.popPose();
            }

            @NotNull
            public Vec3 getCenterPos(float partialTick) {
                return renderPos;
            }

            @NotNull
            public String getProfilerSection() {
                return "energyCube.core";
            }

            @NotNull
            public RenderType getRenderType() {
                return ColorModelEnergyCore.BATCHED_RENDER_TYPE;
            }
        });
    }

    protected String getProfilerSection() {
        return "energyCube";
    }

    public boolean shouldRender(TileEntityExtraEnergyCube tile, Vec3 camera) {
        return tile.getEnergyScale() > 0.0f && super.shouldRender((BlockEntity)tile, camera);
    }
}

