/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.recipe_viewer.jei;

import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekextras.common.integration.mekaf.registries.ExtraAdvancedFactoryBlocks;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.List;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ExtraAFCatalystRegistryHelper {
    private ExtraAFCatalystRegistryHelper() {
    }

    public static void register(IRecipeCatalystRegistration registry, boolean needOrdinary, IRecipeViewerRecipeType<?> ... categories) {
        for (IRecipeViewerRecipeType<?> category : categories) {
            ExtraAFCatalystRegistryHelper.register(registry, MekanismJEI.genericRecipeType(category), category.workstations(), needOrdinary);
        }
    }

    public static void register(IRecipeCatalystRegistration registry, RecipeType<?> recipeType, List<ItemLike> workstations, boolean needOrdinary) {
        for (ItemLike workstation : workstations) {
            Item item = workstation.asItem();
            if (needOrdinary) {
                registry.addRecipeCatalyst((ItemLike)item, new RecipeType[]{recipeType});
            }
            for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
                if (workstation == MekanismBlocks.CHEMICAL_OXIDIZER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.OXIDIZING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_INFUSER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CHEMICAL_INFUSING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.DISSOLVING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_WASHER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.WASHING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.CHEMICAL_CRYSTALLIZER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CRYSTALLIZING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.PRESSURIZED_REACTION_CHAMBER) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.PRESSURISED_REACTING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation == MekanismBlocks.ISOTOPIC_CENTRIFUGE) {
                    registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.CENTRIFUGING), new RecipeType[]{recipeType});
                    continue;
                }
                if (workstation != MekanismBlocks.NUTRITIONAL_LIQUIFIER) continue;
                registry.addRecipeCatalyst(ExtraAdvancedFactoryBlocks.getAdvancedFactory(tier, AdvancedFactoryType.LIQUIFYING), new RecipeType[]{recipeType});
            }
        }
    }
}

