/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.model.energycube;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.jerry.mekextras.client.model.energycube.ExtraEnergyCubeGeometry;
import com.jerry.mekextras.common.tile.TileEntityExtraEnergyCube;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import mekanism.api.RelativeSide;
import mekanism.client.model.baked.ExtensionBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.common.util.EnumUtils;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraEnergyCubeBakedModel
implements IDynamicBakedModel {
    private static final TileEntityExtraEnergyCube.CubeSideState[] INACTIVE = (TileEntityExtraEnergyCube.CubeSideState[])Util.make((Object)new TileEntityExtraEnergyCube.CubeSideState[EnumUtils.DIRECTIONS.length], sideStates -> Arrays.fill((Object[])sideStates, (Object)TileEntityExtraEnergyCube.CubeSideState.INACTIVE));
    private static final QuadTransformation LED_TRANSFORMS = QuadTransformation.list((QuadTransformation[])new QuadTransformation[]{QuadTransformation.fullbright, QuadTransformation.uvShift((float)-0.125f, (float)0.0f)});
    private static final BiPredicate<TileEntityExtraEnergyCube.CubeSideState[], TileEntityExtraEnergyCube.CubeSideState[]> DATA_EQUALITY_CHECK = Arrays::equals;
    private final LoadingCache<ExtensionBakedModel.QuadsKey<TileEntityExtraEnergyCube.CubeSideState[]>, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<ExtensionBakedModel.QuadsKey<TileEntityExtraEnergyCube.CubeSideState[]>, List<BakedQuad>>(){

        @NotNull
        public List<BakedQuad> load(@NotNull ExtensionBakedModel.QuadsKey<TileEntityExtraEnergyCube.CubeSideState[]> key) {
            return ExtraEnergyCubeBakedModel.this.createQuads(key);
        }
    });
    private final ExtraEnergyCubeGeometry.FaceData frame;
    private final Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> leds;
    private final Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> activeLEDs;
    private final Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> ports;
    private final Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> activePorts;
    private final ChunkRenderTypeSet blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> fabulousItemRenderTypes;
    private final boolean isAmbientOcclusion;
    private final boolean usesBlockLight;
    private final boolean isGui3d;
    private final TextureAtlasSprite particle;
    private final ItemOverrides overrides;
    private final ItemTransforms transforms;

    ExtraEnergyCubeBakedModel(boolean useAmbientOcclusion, boolean usesBlockLight, boolean isGui3d, ItemTransforms transforms, ItemOverrides overrides, TextureAtlasSprite particle, ExtraEnergyCubeGeometry.FaceData frame, Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> leds, Map<RelativeSide, ExtraEnergyCubeGeometry.FaceData> ports, RenderTypeGroup renderTypes) {
        this.isAmbientOcclusion = useAmbientOcclusion;
        this.usesBlockLight = usesBlockLight;
        this.isGui3d = isGui3d;
        this.overrides = overrides;
        this.transforms = transforms;
        this.particle = particle;
        this.frame = frame;
        this.leds = leds;
        this.ports = ports;
        this.activeLEDs = new EnumMap<RelativeSide, ExtraEnergyCubeGeometry.FaceData>(RelativeSide.class);
        this.activePorts = new EnumMap<RelativeSide, ExtraEnergyCubeGeometry.FaceData>(RelativeSide.class);
        for (Map.Entry<RelativeSide, ExtraEnergyCubeGeometry.FaceData> entry : this.leds.entrySet()) {
            this.activeLEDs.put(entry.getKey(), entry.getValue().transform(LED_TRANSFORMS));
        }
        for (Map.Entry<RelativeSide, ExtraEnergyCubeGeometry.FaceData> entry : this.ports.entrySet()) {
            this.activePorts.put(entry.getKey(), entry.getValue().transform(QuadTransformation.filtered_fullbright));
        }
        if (renderTypes.isEmpty()) {
            this.blockRenderTypes = null;
            this.itemRenderTypes = null;
            this.fabulousItemRenderTypes = null;
        } else {
            this.blockRenderTypes = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderTypes.block()});
            this.itemRenderTypes = Collections.singletonList(renderTypes.entity());
            this.fabulousItemRenderTypes = Collections.singletonList(renderTypes.entityFabulous());
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        TileEntityExtraEnergyCube.CubeSideState[] sideStates = (TileEntityExtraEnergyCube.CubeSideState[])data.get(TileEntityExtraEnergyCube.SIDE_STATE_PROPERTY);
        if (sideStates == null || sideStates.length != EnumUtils.SIDES.length) {
            sideStates = INACTIVE;
        }
        ExtensionBakedModel.QuadsKey key = new ExtensionBakedModel.QuadsKey(null, side, rand, renderType, this.frame.getFaces(side));
        key.data((Object)sideStates, Arrays.hashCode((Object[])sideStates), DATA_EQUALITY_CHECK);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private List<BakedQuad> createQuads(ExtensionBakedModel.QuadsKey<TileEntityExtraEnergyCube.CubeSideState[]> key) {
        Direction side = key.getSide();
        TileEntityExtraEnergyCube.CubeSideState[] data = Objects.requireNonNull((TileEntityExtraEnergyCube.CubeSideState[])key.getData());
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(key.getQuads());
        for (int i = 0; i < EnumUtils.SIDES.length; ++i) {
            RelativeSide dir = EnumUtils.SIDES[i];
            TileEntityExtraEnergyCube.CubeSideState sideState = data[i];
            if (sideState == TileEntityExtraEnergyCube.CubeSideState.ACTIVE_LIT) {
                quads.addAll(this.activeLEDs.get(dir).getFaces(side));
                quads.addAll(this.activePorts.get(dir).getFaces(side));
                continue;
            }
            quads.addAll(this.leds.get(dir).getFaces(side));
            if (sideState != TileEntityExtraEnergyCube.CubeSideState.ACTIVE_UNLIT) continue;
            quads.addAll(this.ports.get(dir).getFaces(side));
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.isAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @Deprecated
    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.particle;
    }

    @Deprecated
    @NotNull
    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    @Deprecated
    @NotNull
    public ItemTransforms getTransforms() {
        return this.transforms;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.blockRenderTypes == null ? super.getRenderTypes(state, rand, data) : this.blockRenderTypes;
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack stack, boolean fabulous) {
        if (fabulous) {
            if (this.fabulousItemRenderTypes != null) {
                return this.fabulousItemRenderTypes;
            }
        } else if (this.itemRenderTypes != null) {
            return this.itemRenderTypes;
        }
        return super.getRenderTypes(stack, fabulous);
    }
}

