/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ItemStackChemicalToObjectRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StackableItemStackConstantChemicalToObjectCachedRecipe<OUTPUT, RECIPE extends ItemStackChemicalToObjectRecipe<OUTPUT>>
extends CachedRecipe<RECIPE> {
    private final Predicate<OUTPUT> outputEmptyCheck;
    private final IOutputHandler<@NotNull OUTPUT> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    private final StackableChemicalUsageMultiplier chemicalUsage;
    private final LongConsumer chemicalUsedSoFarChanged;
    private long chemicalUsageMultiplier;
    private long chemicalUsedSoFar;
    private int operationsSoFar = 1;
    private ItemStack recipeItem = ItemStack.EMPTY;
    @Nullable
    private ChemicalStack recipeChemical;
    @Nullable
    private OUTPUT output;

    public StackableItemStackConstantChemicalToObjectCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<ChemicalStack> chemicalInputHandler, StackableChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<@NotNull OUTPUT> outputHandler, Predicate<OUTPUT> outputEmptyCheck) {
        super(recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.chemicalUsage = Objects.requireNonNull(chemicalUsage, "Chemical usage cannot be null.");
        this.chemicalUsedSoFarChanged = Objects.requireNonNull(chemicalUsedSoFarChanged, "Chemical used so far changed handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.outputEmptyCheck = Objects.requireNonNull(outputEmptyCheck, "Output empty check cannot be null.");
    }

    public void loadSavedUsageSoFar(long chemicalUsedSoFar) {
        if (chemicalUsedSoFar > 0L) {
            this.chemicalUsedSoFar = chemicalUsedSoFar;
        }
    }

    protected void setupVariableValues() {
        this.chemicalUsageMultiplier = Math.max(this.chemicalUsage.getToUse(this.chemicalUsedSoFar, this.getOperatingTicks(), this.operationsSoFar), 0L);
    }

    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = (ItemStack)this.itemInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getItemInput());
            if (this.recipeItem.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getChemicalInput());
                if (this.recipeChemical.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeItem);
                if (!this.recipeChemical.isEmpty() && tracker.shouldContinueChecking()) {
                    this.chemicalInputHandler.calculateOperationsCanSupport(tracker, (Object)this.recipeChemical, this.chemicalUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((ItemStackChemicalToObjectRecipe)this.recipe).getOutput(this.recipeItem, this.recipeChemical);
                        this.outputHandler.calculateOperationsCanSupport(tracker, this.output);
                    }
                }
            }
        }
    }

    public boolean isInputValid() {
        ChemicalStack chemicalStack;
        ItemStack itemInput = (ItemStack)this.itemInputHandler.getInput();
        if (!itemInput.isEmpty() && !(chemicalStack = (ChemicalStack)this.chemicalInputHandler.getInput()).isEmpty() && ((ItemStackChemicalToObjectRecipe)this.recipe).test(itemInput, chemicalStack)) {
            ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient)((ItemStackChemicalToObjectRecipe)this.recipe).getChemicalInput());
            return !recipeChemical.isEmpty() && chemicalStack.getAmount() >= recipeChemical.getAmount();
        }
        return false;
    }

    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.chemicalUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeChemical == null || this.recipeChemical.isEmpty()) {
            return;
        }
        long toUse = (long)operations * this.chemicalUsageMultiplier;
        this.chemicalInputHandler.use((Object)this.recipeChemical, toUse);
        this.chemicalUsedSoFar += toUse;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
        this.operationsSoFar = operations;
    }

    protected void resetCache() {
        super.resetCache();
        this.chemicalUsedSoFar = 0L;
        this.chemicalUsedSoFarChanged.accept(this.chemicalUsedSoFar);
    }

    protected void finishProcessing(int operations) {
        if (!(this.recipeChemical == null || this.output == null || this.recipeItem.isEmpty() || this.recipeChemical.isEmpty() || this.outputEmptyCheck.test(this.output))) {
            this.itemInputHandler.use((Object)this.recipeItem, operations);
            if (this.chemicalUsageMultiplier > 0L) {
                this.chemicalInputHandler.use((Object)this.recipeChemical, (long)operations * this.chemicalUsageMultiplier);
            }
            this.outputHandler.handleOutput(this.output, operations);
        }
    }

    public static <RECIPE extends ItemStackChemicalToItemStackRecipe> StackableItemStackConstantChemicalToObjectCachedRecipe<ItemStack, RECIPE> toItem(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<ChemicalStack> chemicalInputHandler, StackableChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<@NotNull ItemStack> outputHandler) {
        return new StackableItemStackConstantChemicalToObjectCachedRecipe<ItemStack, RECIPE>(recipe, recheckAllErrors, itemInputHandler, chemicalInputHandler, chemicalUsage, chemicalUsedSoFarChanged, outputHandler, ConstantPredicates.ITEM_EMPTY);
    }

    public static StackableItemStackConstantChemicalToObjectCachedRecipe<ChemicalStack, ChemicalDissolutionRecipe> dissolution(ChemicalDissolutionRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<ChemicalStack> chemicalInputHandler, StackableChemicalUsageMultiplier chemicalUsage, LongConsumer chemicalUsedSoFarChanged, IOutputHandler<@NotNull ChemicalStack> outputHandler) {
        return new StackableItemStackConstantChemicalToObjectCachedRecipe<ChemicalStack, ChemicalDissolutionRecipe>(recipe, recheckAllErrors, itemInputHandler, chemicalInputHandler, chemicalUsage, chemicalUsedSoFarChanged, outputHandler, ConstantPredicates.CHEMICAL_EMPTY);
    }

    @FunctionalInterface
    public static interface StackableChemicalUsageMultiplier {
        public long getToUse(long var1, int var3, int var4);

        public static StackableChemicalUsageMultiplier constantUse(LongSupplier baseTotalUsage, IntSupplier ticksRequired) {
            return (usedSoFar, operatingTicks, operationsSoFar) -> {
                int remainingTicks;
                long baseRemaining = baseTotalUsage.getAsLong() - usedSoFar / (long)operationsSoFar;
                if (baseRemaining < (long)(remainingTicks = ticksRequired.getAsInt() - operatingTicks)) {
                    return 0L;
                }
                if (baseRemaining == (long)remainingTicks) {
                    return 1L;
                }
                return Math.max(MathUtils.clampToLong((double)((double)baseRemaining / (double)remainingTicks)), 0L);
            };
        }
    }
}

