/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.common.content.naquadah;

import com.jerry.genextras.common.content.naquadah.NaquadahReactorMultiblockData;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class NaquadahReactorCache
extends MultiblockCache<NaquadahReactorMultiblockData> {
    private double plasmaTemperature = -1.0;
    private int injectionRate = -1;
    private boolean burning;

    private int getInjectionRate() {
        if (this.injectionRate == -1) {
            return 2;
        }
        return this.injectionRate;
    }

    public void merge(MultiblockCache<NaquadahReactorMultiblockData> mergeCache, MultiblockCache.RejectContents rejectContents) {
        super.merge(mergeCache, rejectContents);
        this.plasmaTemperature = Math.max(this.plasmaTemperature, ((NaquadahReactorCache)mergeCache).plasmaTemperature);
        this.injectionRate = Math.max(this.injectionRate, ((NaquadahReactorCache)mergeCache).injectionRate);
        this.burning |= ((NaquadahReactorCache)mergeCache).burning;
    }

    public void apply(HolderLookup.Provider provider, NaquadahReactorMultiblockData data) {
        super.apply(provider, (MultiblockData)data);
        if (this.plasmaTemperature >= 0.0) {
            data.plasmaTemperature = this.plasmaTemperature;
        }
        data.setInjectionRate(this.getInjectionRate());
        data.setBurning(this.burning);
        data.updateTemperatures();
    }

    public void sync(NaquadahReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.plasmaTemperature = data.plasmaTemperature;
        this.injectionRate = data.getInjectionRate();
        this.burning = data.isBurning();
    }

    public void load(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.load(provider, nbtTags);
        this.plasmaTemperature = nbtTags.getDouble("plasma_temp");
        this.injectionRate = nbtTags.getInt("injection_rate");
        this.burning = nbtTags.getBoolean("burning");
    }

    public void save(HolderLookup.Provider provider, CompoundTag nbtTags) {
        super.save(provider, nbtTags);
        nbtTags.putDouble("plasma_temp", this.plasmaTemperature);
        nbtTags.putInt("injection_rate", this.getInjectionRate());
        nbtTags.putBoolean("burning", this.burning);
    }
}

