/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile.transmitter;

import com.jerry.mekextras.api.tier.AdvancedTier;
import com.jerry.mekextras.common.content.network.transmitter.ExtraUniversalCable;
import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityTransmitter;
import java.util.Collections;
import java.util.List;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.math.MathUtils;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.energy.DynamicStrictEnergyHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.lib.transmitter.ConnectionType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityUniversalCable
extends ExtraTileEntityTransmitter
implements IComputerTile {
    private final EnergyHandlerManager energyHandlerManager = new EnergyHandlerManager(direction -> {
        ExtraUniversalCable cable = this.getTransmitter();
        if (direction != null && cable.getConnectionTypeRaw(direction) == ConnectionType.NONE || cable.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return cable.getEnergyContainers(direction);
    }, (ISidedStrictEnergyHandler)new DynamicStrictEnergyHandler(this::getEnergyContainers, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public ExtraTileEntityUniversalCable(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver((ICapabilityResolver)this.energyHandlerManager);
    }

    protected ExtraUniversalCable createTransmitter(Holder<Block> blockProvider) {
        return new ExtraUniversalCable(blockProvider, this);
    }

    public ExtraUniversalCable getTransmitter() {
        return (ExtraUniversalCable)super.getTransmitter();
    }

    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull AdvancedTier tier) {
        return BlockStateHelper.copyStateData((BlockState)current, switch (tier) {
            default -> throw new MatchException(null, null);
            case AdvancedTier.ABSOLUTE -> ExtraBlocks.ABSOLUTE_UNIVERSAL_CABLE;
            case AdvancedTier.SUPREME -> ExtraBlocks.SUPREME_UNIVERSAL_CABLE;
            case AdvancedTier.COSMIC -> ExtraBlocks.COSMIC_UNIVERSAL_CABLE;
            case AdvancedTier.INFINITE -> ExtraBlocks.INFINITE_UNIVERSAL_CABLE;
        });
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getUpdateTag(provider);
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.putLong("energy", network.energyContainer.getEnergy());
            updateTag.putFloat("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager.getContainers(side);
    }

    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(EnergyCompatUtils.getLoadedEnergyCapabilities(), side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilitiesAll(EnergyCompatUtils.getLoadedEnergyCapabilities());
        } else {
            this.invalidateCapabilities();
        }
    }

    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "UniversalCable";
    }

    @ComputerMethod
    long getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    long getCapacity() {
        ExtraUniversalCable cable = this.getTransmitter();
        return cable.hasTransmitterNetwork() ? ((EnergyNetwork)cable.getTransmitterNetwork()).getCapacity() : cable.getCapacity();
    }

    @ComputerMethod
    long getNeeded() {
        return this.getCapacity() - this.getBuffer();
    }

    @ComputerMethod
    double getFilledPercentage() {
        return MathUtils.divideToLevel((double)this.getBuffer(), (double)this.getCapacity());
    }
}

