/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.capabilities.chemical.StackedLargeCapWasteBarrel;
import com.jerry.mekextras.common.tier.RWBTier;
import java.util.Collections;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPITags;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.ISidedChemicalHandler;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.proxy.ProxyChemicalHandler;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeCapRadioactiveWasteBarrel
extends TileEntityMekanism
implements IConfigurable {
    private long lastProcessTick;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="barrel")
    StackedLargeCapWasteBarrel chemicalTank;
    @Nullable
    private IChemicalTank belowTank;
    private boolean resolvedBelowTank;
    private int processTicks;
    private RWBTier tier;
    private List<BlockCapabilityCache<IChemicalHandler, @Nullable Direction>> chemicalHandlerBelow = Collections.emptyList();

    public TileEntityLargeCapRadioactiveWasteBarrel(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.delaySupplier = NO_DELAY;
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getAdvanceTier((Holder<Block>)this.getBlockHolder(), RWBTier.class);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSide(() -> ((TileEntityLargeCapRadioactiveWasteBarrel)this).getDirection());
        this.chemicalTank = StackedLargeCapWasteBarrel.create(this, listener);
        builder.addTank((IChemicalTank)this.chemicalTank, new RelativeSide[]{RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    public RWBTier getTier() {
        return this.tier;
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.level != null && this.level.getGameTime() > this.lastProcessTick) {
            this.lastProcessTick = this.level.getGameTime();
            if (this.tier.getDecayAmount() > 0L && !this.chemicalTank.isEmpty() && !this.chemicalTank.getStack().is(MekanismAPITags.Chemicals.WASTE_BARREL_DECAY_BLACKLIST) && ++this.processTicks >= this.tier.getProcessTicks()) {
                this.processTicks = 0;
                this.chemicalTank.shrinkStack(this.tier.getDecayAmount(), Action.EXECUTE);
            }
            if (this.getActive()) {
                IChemicalTank below;
                if (this.chemicalHandlerBelow.isEmpty()) {
                    this.chemicalHandlerBelow = List.of(Capabilities.CHEMICAL.createCache((ServerLevel)this.level, this.worldPosition.below(), Direction.UP, ConstantPredicates.ALWAYS_TRUE, () -> {
                        this.resolvedBelowTank = false;
                        this.belowTank = null;
                    }));
                }
                if ((below = this.getBelowTank()) == null) {
                    ChemicalUtil.emit(this.chemicalHandlerBelow, (IChemicalTank)this.chemicalTank);
                } else {
                    ChemicalUtil.emit(this.chemicalHandlerBelow, (IChemicalTank)this.chemicalTank, (long)Math.min(below.getNeeded(), this.chemicalTank.getCapacity()));
                }
            }
        }
        return sendUpdatePacket;
    }

    @Nullable
    private IChemicalTank getBelowTank() {
        if (!this.resolvedBelowTank) {
            ProxyChemicalHandler chemicalHandler;
            ISidedChemicalHandler iSidedChemicalHandler;
            this.resolvedBelowTank = true;
            IChemicalHandler belowHandler = (IChemicalHandler)this.chemicalHandlerBelow.getFirst().getCapability();
            if (belowHandler instanceof ProxyChemicalHandler && (iSidedChemicalHandler = (chemicalHandler = (ProxyChemicalHandler)belowHandler).getInternalHandler()) instanceof TileEntityLargeCapRadioactiveWasteBarrel) {
                TileEntityLargeCapRadioactiveWasteBarrel barrel = (TileEntityLargeCapRadioactiveWasteBarrel)iSidedChemicalHandler;
                this.belowTank = barrel.chemicalTank;
            }
        }
        return this.belowTank;
    }

    public StackedLargeCapWasteBarrel getGasTank() {
        return this.chemicalTank;
    }

    public double getGasScale() {
        return (double)this.chemicalTank.getStored() / (double)this.chemicalTank.getCapacity();
    }

    public ChemicalStack getGas() {
        return this.chemicalTank.getStack();
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.getLevel();
            if (world != null) {
                world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.put("chemical", (Tag)this.chemicalTank.serializeNBT(provider));
        updateTag.putInt("progress", this.processTicks);
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setCompoundIfPresent((CompoundTag)tag, (String)"chemical", nbt -> this.chemicalTank.deserializeNBT(provider, (CompoundTag)nbt));
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"progress", val -> {
            this.processTicks = val;
        });
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.chemicalTank.getStored(), (long)this.chemicalTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }
}

