/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.capabilities.fluid.ExtraFluidTankFluidTank;
import com.jerry.mekextras.common.tier.FTTier;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.upgrade.FluidTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityFluidTank
extends TileEntityMekanism
implements IConfigurable,
IFluidContainerManager {
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    public ExtraFluidTankFluidTank fluidTank;
    private IFluidContainerManager.ContainerEditMode editMode = IFluidContainerManager.ContainerEditMode.BOTH;
    public FTTier tier;
    public int valve;
    @NotNull
    public FluidStack valveFluid = FluidStack.EMPTY;
    private List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> fluidHandlerBelow = Collections.emptyList();
    public float prevScale;
    private boolean needsPacket;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input slot")
    FluidInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output slot")
    OutputInventorySlot outputSlot;
    private int lastLightLevel;
    private int lightUpdateDelay;

    public ExtraTileEntityFluidTank(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getAdvanceTier((Holder<Block>)this.getBlockHolder(), FTTier.class);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((ExtraTileEntityFluidTank)this).getDirection());
        this.fluidTank = ExtraFluidTankFluidTank.create(this, listener);
        builder.addTank((IExtendedFluidTank)this.fluidTank);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((ExtraTileEntityFluidTank)this).getDirection());
        this.inputSlot = FluidInventorySlot.input((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)146, (int)19);
        builder.addSlot((IInventorySlot)this.inputSlot);
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)146, (int)51);
        builder.addSlot((IInventorySlot)this.outputSlot);
        this.inputSlot.setSlotOverlay(SlotOverlay.INPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.OUTPUT);
        return builder.build();
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        this.checkLight();
    }

    private void checkLight() {
        if (this.lightUpdateDelay > 0) {
            int lightLevel;
            --this.lightUpdateDelay;
            if (this.lightUpdateDelay == 0 && (lightLevel = this.getBlockState().getLightEmission((BlockGetter)this.level, this.worldPosition)) != this.lastLightLevel) {
                this.lastLightLevel = lightLevel;
                this.level.getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    protected boolean onUpdateServer() {
        float scale;
        boolean sendUpdatePacket = super.onUpdateServer();
        if (this.valve > 0) {
            --this.valve;
            if (this.valve == 0) {
                this.valveFluid = FluidStack.EMPTY;
                this.needsPacket = true;
            }
        }
        if ((scale = MekanismUtils.getScale((float)this.prevScale, (IExtendedFluidTank)this.fluidTank)) != this.prevScale) {
            if ((this.prevScale == 0.0f || scale == 0.0f) && this.lightUpdateDelay == 0) {
                this.lightUpdateDelay = this.prevScale == 0.0f ? 1 : MekanismConfig.general.blockDeactivationDelay.get();
            }
            this.prevScale = scale;
            sendUpdatePacket = true;
        }
        this.inputSlot.handleTank((IInventorySlot)this.outputSlot, this.editMode);
        if (this.getActive()) {
            if (this.fluidHandlerBelow.isEmpty()) {
                this.fluidHandlerBelow = List.of(Capabilities.FLUID.createCache((ServerLevel)this.level, this.worldPosition.below(), Direction.UP));
            }
            FluidUtils.emit(this.fluidHandlerBelow, (IExtendedFluidTank)this.fluidTank, (int)this.tier.getOutput());
        }
        if (this.needsPacket) {
            sendUpdatePacket = true;
            this.needsPacket = false;
        }
        return sendUpdatePacket;
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        NBTUtils.writeEnum((CompoundTag)data, (String)"edit_mode", (Enum)this.editMode);
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag data) {
        super.writeSustainedData(provider, data);
        NBTUtils.setEnumIfPresent((CompoundTag)data, (String)"edit_mode", (IntFunction)IFluidContainerManager.ContainerEditMode.BY_ID, mode -> {
            this.editMode = mode;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.EDIT_MODE, (Object)this.editMode);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.editMode = (IFluidContainerManager.ContainerEditMode)input.getOrDefault((Supplier)MekanismDataComponents.EDIT_MODE, (Object)this.editMode);
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fluidTank.getFluidAmount(), (long)this.fluidTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    @NotNull
    public FluidStack insertFluid(int tank, @NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action) {
        return this.insertExcess(stack, side, action, super.insertFluid(tank, stack, side, action));
    }

    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action) {
        return this.insertExcess(stack, side, action, super.insertFluid(stack, side, action));
    }

    private FluidStack insertExcess(@NotNull FluidStack stack, @Nullable Direction side, @NotNull Action action, @NotNull FluidStack remainder) {
        if (side == Direction.UP && action.execute() && remainder.getAmount() < stack.getAmount() && !this.isRemote()) {
            if (this.valve == 0) {
                this.needsPacket = true;
            }
            this.valve = 20;
            this.valveFluid = stack.copyWithAmount(1);
        }
        return remainder;
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            this.setActive(!this.getActive());
            Level world = this.getLevel();
            if (world != null) {
                world.playSound(null, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.BLOCKS, 0.3f, 1.0f);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onRightClick(Player player) {
        return InteractionResult.PASS;
    }

    @ComputerMethod
    public IFluidContainerManager.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    public void nextMode() {
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getNext();
        this.markForSave();
    }

    public void previousMode() {
        this.editMode = (IFluidContainerManager.ContainerEditMode)this.editMode.getPrevious();
        this.setChanged();
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof FluidTankUpgradeData) {
            FluidTankUpgradeData data = (FluidTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.inputSlot.setStack(data.inputSlot.getStack());
            this.outputSlot.setStack(data.outputSlot.getStack());
            this.editMode = data.editMode;
            this.fluidTank.setStack(data.stored);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @NotNull
    public FluidTankUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new FluidTankUpgradeData(provider, this.redstone, this.inputSlot, this.outputSlot, this.editMode, this.fluidTank.getFluid(), this.getComponents());
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create((IntFunction)IFluidContainerManager.ContainerEditMode.BY_ID, (Enum)IFluidContainerManager.ContainerEditMode.BOTH, () -> this.editMode, value -> {
            this.editMode = value;
        }));
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        updateTag.putFloat("scale", this.prevScale);
        CompoundTag fluidData = new CompoundTag();
        FluidStack fluid = this.fluidTank.getFluid();
        if (fluid.isEmpty()) {
            fluid = this.valveFluid;
        } else {
            fluidData.putInt("amount", fluid.getAmount());
        }
        if (!fluid.isEmpty()) {
            ResourceKey key = Objects.requireNonNull(fluid.getFluidHolder().getKey(), "Resource key should always be present");
            fluidData.putString("id", key.location().toString());
            if (!fluid.isComponentsPatchEmpty()) {
                DataResult componentData = DataComponentPatch.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)fluid.getComponentsPatch());
                if (componentData.isError()) {
                    componentData.mapError(error -> {
                        Mekanism.logger.error("Failed to encode fluid stack component data: {}", error);
                        return error;
                    });
                } else {
                    fluidData.put("data", (Tag)componentData.getOrThrow());
                }
            }
            fluidData.putBoolean("valve", !this.valveFluid.isEmpty());
            updateTag.put("fluid", (Tag)fluidData);
        }
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        CompoundTag fluidData;
        super.handleUpdateTag(tag, provider);
        NBTUtils.setFloatIfPresent((CompoundTag)tag, (String)"scale", scale -> {
            if (this.lightUpdateDelay == 0 && MekanismUtils.scaleChanged((float)this.prevScale, (float)scale) && (this.prevScale == 0.0f || scale == 0.0f)) {
                this.lightUpdateDelay = this.prevScale == 0.0f ? 1 : MekanismConfig.general.blockDeactivationDelay.get();
            }
            this.prevScale = scale;
        });
        boolean unsetFluid = true;
        if (tag.contains("fluid", 10) && !(fluidData = tag.getCompound("fluid")).isEmpty()) {
            String fluidId = fluidData.getString("id");
            Optional holder = BuiltInRegistries.FLUID.getHolder(ResourceLocation.parse((String)fluidId));
            if (holder.isEmpty()) {
                Mekanism.logger.info("Received update packet for a fluid tank for an unregistered fluid with expected id: {}", (Object)fluidId);
            } else {
                Holder.Reference fluidType = (Holder.Reference)holder.get();
                DataComponentPatch patch = DataComponentPatch.EMPTY;
                int amount = fluidData.getInt("amount");
                if (fluidData.contains("data")) {
                    DataResult componentPatch = DataComponentPatch.CODEC.decode((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)fluidData.get("data"));
                    if (componentPatch.isSuccess()) {
                        patch = (DataComponentPatch)((Pair)componentPatch.getOrThrow()).getFirst();
                    } else {
                        componentPatch.mapError(error -> {
                            Mekanism.logger.info("Received update packet for a fluid tank storing {}, and could not decode the data component patch: {}", (Object)fluidId, error);
                            return error;
                        });
                    }
                }
                unsetFluid = false;
                if (amount == 0) {
                    this.fluidTank.setEmpty();
                } else {
                    this.fluidTank.setStack(new FluidStack((Holder)fluidType, amount, patch));
                }
                this.valveFluid = fluidData.getBoolean("valve") ? new FluidStack((Holder)fluidType, 1, patch) : FluidStack.EMPTY;
            }
        }
        if (unsetFluid) {
            this.fluidTank.setEmpty();
            this.valveFluid = FluidStack.EMPTY;
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setContainerEditMode(IFluidContainerManager.ContainerEditMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.editMode != mode) {
            this.editMode = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementContainerEditMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.previousMode();
    }
}

