/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.tile;

import com.jerry.mekextras.common.block.attribute.ExtraAttribute;
import com.jerry.mekextras.common.capabilities.chemical.ExtraChemicalTankChemicalTank;
import com.jerry.mekextras.common.registries.ExtraDataComponents;
import com.jerry.mekextras.common.tier.CTTier;
import com.jerry.mekextras.common.upgrade.ExtraChemicalTankUpgradeData;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.IIncrementalEnum;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.upgrade.ChemicalTankUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraTileEntityChemicalTank
extends TileEntityConfigurableMachine
implements IHasGasMode {
    @SyntheticComputerMethod(getter="getDumpingMode", getterDescription="Get the current Dumping configuration")
    public GasMode dumping = GasMode.IDLE;
    private IChemicalTank chemicalTank;
    private CTTier tier;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getDrainItem"}, docPlaceholder="drain slot")
    ChemicalInventorySlot drainSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFillItem"}, docPlaceholder="fill slot")
    ChemicalInventorySlot fillSlot;

    public ExtraTileEntityChemicalTank(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.drainSlot, (Object)this.fillSlot, RelativeSide.FRONT, true).setCanEject(false);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.getChemicalTank(), RelativeSide.FRONT);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this, () -> this.tier.getOutput());
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.CHEMICAL}).setCanEject(type -> this.canFunction() && this.dumping != GasMode.DUMPING);
    }

    protected void presetVariables() {
        super.presetVariables();
        this.tier = ExtraAttribute.getAdvanceTier((Holder<Block>)this.getBlockHolder(), CTTier.class);
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = ExtraChemicalTankChemicalTank.create(this.tier, listener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.drainSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)16);
        builder.addSlot((IInventorySlot)this.drainSlot);
        this.fillSlot = ChemicalInventorySlot.fill((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)16, (int)48);
        builder.addSlot((IInventorySlot)this.fillSlot);
        this.drainSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.drainSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fillSlot.setSlotType(ContainerSlotType.INPUT);
        this.fillSlot.setSlotOverlay(SlotOverlay.MINUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.drainSlot.drainTank();
        this.fillSlot.fillTank();
        if (this.dumping != GasMode.IDLE) {
            if (this.dumping == GasMode.DUMPING) {
                this.chemicalTank.shrinkStack(this.tier.getStorage() / 400L, Action.EXECUTE);
            } else {
                long stored;
                long target = MathUtils.clampToLong((double)((double)this.chemicalTank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
                if (target < (stored = this.chemicalTank.getStored())) {
                    this.chemicalTank.shrinkStack(Math.min(stored - target, this.tier.getOutput()), Action.EXECUTE);
                }
            }
        }
        return sendUpdatePacket;
    }

    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumping = (GasMode)this.dumping.getNext();
            this.markForSave();
        }
    }

    public boolean shouldDumpRadiation() {
        return true;
    }

    public int getRedstoneLevel() {
        IChemicalTank currentTank = this.getCurrentTank();
        return MekanismUtils.redstoneLevelFromContents((long)currentTank.getStored(), (long)currentTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.CHEMICAL;
    }

    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getStored", "getCapacity", "getNeeded", "getFilledPercentage"}, docPlaceholder="tank")
    IChemicalTank getCurrentTank() {
        return this.chemicalTank;
    }

    public CTTier getTier() {
        return this.tier;
    }

    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ExtraChemicalTankUpgradeData) {
            ExtraChemicalTankUpgradeData data = (ExtraChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = data.dumping;
            this.getChemicalTank().setStack(data.storedChemical);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else if (upgradeData instanceof ChemicalTankUpgradeData) {
            ChemicalTankUpgradeData data = (ChemicalTankUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.drainSlot.setStack(data.drainSlot.getStack());
            this.fillSlot.setStack(data.fillSlot.getStack());
            this.dumping = (GasMode)((Object)MathUtils.getByIndexMod((Object[])GasMode.values(), (int)data.dumping.ordinal()));
            this.getChemicalTank().setStack(data.storedChemical);
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @NotNull
    public ExtraChemicalTankUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ExtraChemicalTankUpgradeData(provider, this.redstone, this.getControlType(), this.drainSlot, this.fillSlot, this.dumping, this.getChemicalTank().getStack(), this.getComponents());
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dumping", (Enum)this.dumping);
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setEnumIfPresent((CompoundTag)dataMap, (String)"dumping", GasMode.BY_ID, mode -> {
            this.dumping = mode;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ExtraDataComponents.DUMP_MODE, (Object)this.dumping);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.dumping = (GasMode)((Object)input.getOrDefault(ExtraDataComponents.DUMP_MODE, (Object)this.dumping));
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(GasMode.BY_ID, (Enum)GasMode.IDLE, () -> this.dumping, value -> {
            this.dumping = value;
        }));
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set the Dumping mode of the tank")
    void setDumpingMode(GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumping != mode) {
            this.dumping = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Advance the Dumping mode to the next configuration in the list")
    void incrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Descend the Dumping mode to the previous configuration in the list")
    void decrementDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumping = (GasMode)this.dumping.getPrevious();
        this.markForSave();
    }

    @NothingNullByDefault
    public static enum GasMode implements IIncrementalEnum<GasMode>,
    IHasTextComponent,
    StringRepresentable
    {
        IDLE((ILangEntry)MekanismLang.IDLE),
        DUMPING_EXCESS((ILangEntry)MekanismLang.DUMPING_EXCESS),
        DUMPING((ILangEntry)MekanismLang.DUMPING);

        public static final Codec<GasMode> CODEC;
        public static final IntFunction<GasMode> BY_ID;
        public static final StreamCodec<ByteBuf, GasMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ILangEntry langEntry;

        private GasMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        public Component getTextComponent() {
            return this.langEntry.translate();
        }

        public GasMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(GasMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GasMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

