/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.common.capabilities.chemical;

import com.jerry.mekextras.common.capabilities.chemical.variable.ExtraVariableCapacityChemicalTank;
import com.jerry.mekextras.common.tile.TileEntityLargeCapRadioactiveWasteBarrel;
import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.datamaps.chemical.attribute.ChemicalRadioactivity;
import mekanism.api.datamaps.chemical.attribute.IChemicalAttribute;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class StackedLargeCapWasteBarrel
extends ExtraVariableCapacityChemicalTank
implements IChemicalHandler,
IChemicalTank {
    private static final ChemicalAttributeValidator ATTRIBUTE_VALIDATOR = new ChemicalAttributeValidator.ChemicalAttributeValidatorLegacyAdapter(){

        public boolean validate(IChemicalAttribute attr) {
            return attr instanceof ChemicalRadioactivity;
        }

        public boolean process(Chemical chemical) {
            return chemical.isRadioactive();
        }
    };
    private final TileEntityLargeCapRadioactiveWasteBarrel tile;

    public static StackedLargeCapWasteBarrel create(TileEntityLargeCapRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        Objects.requireNonNull(tile, "Radioactive Waste Barrel tile entity cannot be null");
        return new StackedLargeCapWasteBarrel(tile, listener);
    }

    protected StackedLargeCapWasteBarrel(TileEntityLargeCapRadioactiveWasteBarrel tile, @Nullable IContentsListener listener) {
        super(tile.getTier().getStorage(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), ATTRIBUTE_VALIDATOR, listener);
        this.tile = tile;
    }

    public ChemicalStack insert(ChemicalStack stack, Action action, AutomationType automationType) {
        TileEntityLargeCapRadioactiveWasteBarrel tileAbove;
        ChemicalStack remainder = super.insert(stack, action, automationType);
        if (!remainder.isEmpty() && (tileAbove = (TileEntityLargeCapRadioactiveWasteBarrel)WorldUtils.getTileEntity(TileEntityLargeCapRadioactiveWasteBarrel.class, (BlockGetter)this.tile.getLevel(), (BlockPos)this.tile.getBlockPos().above())) != null) {
            remainder = tileAbove.getGasTank().insert(remainder, action, AutomationType.EXTERNAL);
        }
        return remainder;
    }

    public long growStack(long amount, Action action) {
        TileEntityLargeCapRadioactiveWasteBarrel tileAbove;
        long grownAmount = super.growStack(amount, action);
        if (amount > 0L && grownAmount < amount && !this.tile.getActive() && (tileAbove = (TileEntityLargeCapRadioactiveWasteBarrel)WorldUtils.getTileEntity(TileEntityLargeCapRadioactiveWasteBarrel.class, (BlockGetter)this.tile.getLevel(), (BlockPos)this.tile.getBlockPos().above())) != null) {
            long leftOverToInsert = amount - grownAmount;
            ChemicalStack remainder = tileAbove.getGasTank().insert(this.stored.copyWithAmount(leftOverToInsert), action, AutomationType.EXTERNAL);
            grownAmount += leftOverToInsert - remainder.getAmount();
        }
        return grownAmount;
    }
}

