/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.transmitter;

import com.jerry.mekextras.common.content.network.transmitter.ExtraMechanicalPipe;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityMechanicalPipe;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ExtraRenderMechanicalPipe
extends RenderTransmitterBase<ExtraTileEntityMechanicalPipe> {
    private static final int stages = 100;
    private static final float height = 0.45f;
    private static final float offset = 0.02f;
    private static final Int2ObjectMap<Map<FluidStack, Int2ObjectMap<MekanismRenderer.Model3D>>> cachedLiquids = new Int2ObjectArrayMap(8);

    public ExtraRenderMechanicalPipe(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void onStitch() {
        cachedLiquids.clear();
    }

    protected void render(ExtraTileEntityMechanicalPipe tile, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        ExtraMechanicalPipe pipe = tile.getTransmitter();
        FluidNetwork network = (FluidNetwork)pipe.getTransmitterNetwork();
        FluidStack fluidStack = network.lastFluid;
        if (fluidStack.isEmpty()) {
            return;
        }
        float fluidScale = network.currentScale;
        int stage = Math.max(3, ModelRenderer.getStage((FluidStack)fluidStack, (int)100, (double)fluidScale));
        int glow = MekanismRenderer.calculateGlowLight((int)light, (FluidStack)fluidStack);
        int color = MekanismRenderer.getColorARGB((FluidStack)fluidStack, (float)fluidScale);
        ArrayList<CallSite> connectionContents = new ArrayList<CallSite>();
        boolean[] renderSides = new boolean[6];
        boolean hasHorizontalSide = false;
        int verticalSides = 0;
        VertexConsumer buffer = renderer.getBuffer(Sheets.translucentCullBlockSheet());
        Camera camera = this.getCamera();
        for (Direction side : EnumUtils.DIRECTIONS) {
            ConnectionType connectionType = pipe.getConnectionType(side);
            if (connectionType == ConnectionType.NORMAL) {
                MekanismRenderer.renderObject((MekanismRenderer.Model3D)this.getModel(side, fluidStack, stage), (PoseStack)matrix, (VertexConsumer)buffer, (int)color, (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)camera, (BlockPos)tile.getBlockPos());
            } else if (connectionType != ConnectionType.NONE) {
                connectionContents.add((CallSite)((Object)(side.getSerializedName() + connectionType.getSerializedName().toUpperCase(Locale.ROOT))));
            }
            boolean bl = renderSides[side.ordinal()] = connectionType != ConnectionType.NORMAL;
            if (connectionType == ConnectionType.NONE) continue;
            if (side.getAxis().isHorizontal()) {
                hasHorizontalSide = true;
                continue;
            }
            ++verticalSides;
        }
        boolean renderBase = hasHorizontalSide || verticalSides < 2;
        MekanismRenderer.Model3D model = this.getModel(fluidStack, stage, renderBase);
        for (Direction side : EnumUtils.DIRECTIONS) {
            model.setSideRender(side, renderSides[side.ordinal()] || side.getAxis().isVertical() && renderBase && stage != 99);
        }
        MekanismRenderer.renderObject((MekanismRenderer.Model3D)model, (PoseStack)matrix, (VertexConsumer)buffer, (int)color, (int)glow, (int)overlayLight, (RenderResizableCuboid.FaceDisplay)RenderResizableCuboid.FaceDisplay.FRONT, (Camera)camera, (BlockPos)tile.getBlockPos());
        if (!connectionContents.isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.5, 0.5, 0.5);
            this.renderModel(tile, matrix, buffer, MekanismRenderer.getRed((int)color), MekanismRenderer.getGreen((int)color), MekanismRenderer.getBlue((int)color), MekanismRenderer.getAlpha((int)color), glow, overlayLight, MekanismRenderer.getFluidTexture((FluidStack)fluidStack, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL), connectionContents);
            matrix.popPose();
        }
    }

    @NotNull
    protected String getProfilerSection() {
        return "mechanicalPipe";
    }

    protected boolean shouldRenderTransmitter(ExtraTileEntityMechanicalPipe tile, Vec3 camera) {
        ExtraMechanicalPipe pipe;
        if (super.shouldRenderTransmitter((TileEntityTransmitter)tile, camera) && (pipe = tile.getTransmitter()).hasTransmitterNetwork()) {
            FluidNetwork network = (FluidNetwork)pipe.getTransmitterNetwork();
            return !network.lastFluid.isEmpty() && !network.fluidTank.isEmpty() && network.currentScale > 0.0f;
        }
        return false;
    }

    private MekanismRenderer.Model3D getModel(FluidStack fluid, int stage, boolean hasSides) {
        return this.getModel(null, fluid, stage, hasSides);
    }

    private MekanismRenderer.Model3D getModel(Direction side, FluidStack fluid, int stage) {
        return this.getModel(side, fluid, stage, false);
    }

    private MekanismRenderer.Model3D getModel(@Nullable Direction side, FluidStack fluid, int stage, boolean renderBase) {
        int sideOrdinal = side == null ? (renderBase ? 7 : 6) : side.ordinal();
        Int2ObjectMap modelMap = ((Map)cachedLiquids.computeIfAbsent(sideOrdinal, s -> new HashMap())).computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap());
        MekanismRenderer.Model3D model = (MekanismRenderer.Model3D)modelMap.get(stage);
        if (model == null) {
            model = new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture((FluidStack)fluid, (MekanismRenderer.FluidTextureType)MekanismRenderer.FluidTextureType.STILL));
            float stageRatio = (float)stage / 100.0f * 0.45f;
            if (side == null) {
                float max;
                float min;
                if (renderBase) {
                    min = 0.27f;
                    max = 0.73f;
                } else {
                    min = 0.5f - stageRatio / 2.0f;
                    max = 0.5f + stageRatio / 2.0f;
                }
                return model.xBounds(min, max).yBounds(0.27f, 0.27f + stageRatio).zBounds(min, max);
            }
            model.setSideRender(side, false).setSideRender(side.getOpposite(), false);
            if (side.getAxis().isHorizontal()) {
                model.yBounds(0.27f, 0.27f + stageRatio);
                if (side.getAxis() == Direction.Axis.Z) {
                    return ExtraRenderMechanicalPipe.setHorizontalBounds(side, (arg_0, arg_1) -> ((MekanismRenderer.Model3D)model).xBounds(arg_0, arg_1), (arg_0, arg_1) -> ((MekanismRenderer.Model3D)model).zBounds(arg_0, arg_1));
                }
                return ExtraRenderMechanicalPipe.setHorizontalBounds(side, (arg_0, arg_1) -> ((MekanismRenderer.Model3D)model).zBounds(arg_0, arg_1), (arg_0, arg_1) -> ((MekanismRenderer.Model3D)model).xBounds(arg_0, arg_1));
            }
            float min = 0.5f - stageRatio / 2.0f;
            float max = 0.5f + stageRatio / 2.0f;
            model.xBounds(min, max).zBounds(min, max);
            if (side == Direction.DOWN) {
                model.yBounds(0.0f, 0.27f);
            } else {
                model.yBounds(0.27f + stageRatio, 1.0f);
            }
            modelMap.put(stage, (Object)model);
        }
        return model;
    }

    private static MekanismRenderer.Model3D setHorizontalBounds(Direction horizontal, MekanismRenderer.Model3D.ModelBoundsSetter axisBased, MekanismRenderer.Model3D.ModelBoundsSetter directionBased) {
        axisBased.set(0.27f, 0.73f);
        if (horizontal.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
            return directionBased.set(0.73f, 1.0f);
        }
        return directionBased.set(0.0f, 0.27f);
    }
}

