/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.render.transmitter;

import com.jerry.mekextras.common.tier.transmitter.TPTier;
import com.jerry.mekextras.common.tile.transmitter.ExtraTileEntityLogisticalTransporterBase;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtraRenderLogisticalTransporter
extends RenderTransmitterBase<ExtraTileEntityLogisticalTransporterBase> {
    private static final Map<Direction, MekanismRenderer.Model3D> cachedOverlays = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private final ModelTransporterBox modelBox;
    private final LazyItemRenderer itemRenderer = new LazyItemRenderer();

    public ExtraRenderLogisticalTransporter(BlockEntityRendererProvider.Context context) {
        super(context);
        this.modelBox = new ModelTransporterBox(context.getModelSet());
    }

    protected void render(@NotNull ExtraTileEntityLogisticalTransporterBase tile, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, @NotNull ProfilerFiller profiler) {
        Collection inTransit;
        LogisticalTransporterBase transporter = tile.getTransmitter();
        BlockPos pos = tile.getBlockPos();
        if (!MekanismConfig.client.opaqueTransmitters.get() && !(inTransit = transporter.getTransit()).isEmpty()) {
            matrix.pushPose();
            this.itemRenderer.init(tile.getLevel(), pos);
            float partial = partialTick * (float)TPTier.getSpeed(transporter.tier);
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                float[] stackPos = TransporterUtils.getStackPosition((LogisticalTransporterBase)transporter, (TransporterStack)stack, (float)partial);
                matrix.pushPose();
                matrix.translate(stackPos[0], stackPos[1], stackPos[2]);
                matrix.scale(0.75f, 0.75f, 0.75f);
                this.itemRenderer.renderAsStack(matrix, renderer, stack.itemStack, light);
                matrix.popPose();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.popPose();
        }
    }

    @NotNull
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    protected boolean shouldRenderTransmitter(@NotNull ExtraTileEntityLogisticalTransporterBase tile, @NotNull Vec3 camera) {
        return super.shouldRenderTransmitter((TileEntityTransmitter)tile, camera);
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.isEmpty() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private static class LazyItemRenderer {
        @Nullable
        private ItemEntity entityItem;
        @Nullable
        private EntityRenderer<? super ItemEntity> renderer;

        private LazyItemRenderer() {
        }

        public void init(Level world, BlockPos pos) {
            if (this.entityItem == null) {
                this.entityItem = new ItemEntity(EntityType.ITEM, world);
            } else {
                this.entityItem.setLevel(world);
            }
            this.entityItem.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            this.entityItem.age = 0;
        }

        private void renderAsStack(PoseStack matrix, MultiBufferSource buffer, ItemStack stack, int light) {
            if (this.entityItem != null) {
                if (this.renderer == null) {
                    this.renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.entityItem);
                }
                this.entityItem.setItem(stack);
                this.renderer.render((Entity)this.entityItem, 0.0f, 0.0f, matrix, buffer, light);
            }
        }
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = HashedItem.create((ItemStack)transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TransportInformation)) return false;
            TransportInformation other = (TransportInformation)obj;
            if (this.progress != other.progress) return false;
            if (this.color != other.color) return false;
            if (!this.item.equals((Object)other.item)) return false;
            return true;
        }
    }
}

