/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.client.recipe_viewer.jei;

import com.jerry.mekextras.common.registries.ExtraBlocks;
import com.jerry.mekextras.common.tier.ExtraFactoryTier;
import com.jerry.mekextras.common.util.ExtraEnumUtils;
import java.util.List;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeFactoryType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ExtraCatalystRegistryHelper {
    private ExtraCatalystRegistryHelper() {
    }

    public static void register(IRecipeCatalystRegistration registry, IRecipeViewerRecipeType<?> ... categories) {
        for (IRecipeViewerRecipeType<?> category : categories) {
            ExtraCatalystRegistryHelper.register(registry, MekanismJEI.genericRecipeType(category), category.workstations());
        }
    }

    public static void register(IRecipeCatalystRegistration registry, RecipeType<?> recipeType, List<ItemLike> workstations) {
        for (ItemLike workstation : workstations) {
            BlockItem blockItem;
            AttributeFactoryType factoryType;
            Item item = workstation.asItem();
            if (!(item instanceof BlockItem) || (factoryType = (AttributeFactoryType)Attribute.get((Block)(blockItem = (BlockItem)item).getBlock(), AttributeFactoryType.class)) == null) continue;
            for (ExtraFactoryTier tier : ExtraEnumUtils.EXTRA_FACTORY_TIERS) {
                registry.addRecipeCatalyst(ExtraBlocks.getExtraFactory(tier, factoryType.getFactoryType()), new RecipeType[]{recipeType});
            }
        }
    }
}

