/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekextras.api.tier;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.SupportsColorMap;
import mekanism.api.math.MathUtils;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;

public enum AdvancedTier implements StringRepresentable,
SupportsColorMap
{
    ABSOLUTE("Absolute", new int[]{95, 255, 184}, MapColor.COLOR_LIGHT_GREEN),
    SUPREME("Supreme", new int[]{255, 128, 106}, MapColor.TERRACOTTA_PINK),
    COSMIC("Cosmic", new int[]{75, 248, 255}, MapColor.DIAMOND),
    INFINITE("Infinite", new int[]{247, 135, 255}, MapColor.COLOR_MAGENTA);

    public static final IntFunction<AdvancedTier> BY_ID;
    public static final StreamCodec<ByteBuf, AdvancedTier> STREAM_CODEC;
    private static final AdvancedTier[] TIERS;
    private final String name;
    private final MapColor mapColor;
    private TextColor textColor;
    private int[] rgbCode;
    private int argb;

    private AdvancedTier(String name, int[] rgbCode, MapColor mapColor) {
        this.name = name;
        this.mapColor = mapColor;
        this.setColorFromAtlas(rgbCode);
    }

    public String getSimpleName() {
        return this.name;
    }

    public String getLowerName() {
        return this.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public int getPackedColor() {
        return this.argb;
    }

    public int[] getRgbCode() {
        return this.rgbCode;
    }

    public void setColorFromAtlas(int[] color) {
        this.rgbCode = color;
        this.argb = FastColor.ARGB32.color((int)this.rgbCode[0], (int)this.rgbCode[1], (int)this.rgbCode[2]);
        this.textColor = TextColor.fromRgb((int)this.argb);
    }

    public TextColor getColor() {
        return this.textColor;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static AdvancedTier byIndexStatic(int index) {
        return (AdvancedTier)((Object)MathUtils.getByIndexMod((Object[])TIERS, (int)index));
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])AdvancedTier.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        TIERS = AdvancedTier.values();
    }
}

