/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.genextras.common.network.to_server;

import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorCasing;
import com.jerry.genextras.common.tile.naquadah.TileEntityNaquadahReactorLogicAdapter;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketGenExtraGuiInteract(GenExtraGuiInteraction interaction, BlockPos tilePosition, double extra) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketGenExtraGuiInteract> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"generator_extras", (String)"gui_interact"));
    public static final StreamCodec<ByteBuf, PacketGenExtraGuiInteract> STREAM_CODEC = StreamCodec.composite(GenExtraGuiInteraction.STREAM_CODEC, PacketGenExtraGuiInteract::interaction, (StreamCodec)BlockPos.STREAM_CODEC, PacketGenExtraGuiInteract::tilePosition, (StreamCodec)ByteBufCodecs.DOUBLE, PacketGenExtraGuiInteract::extra, PacketGenExtraGuiInteract::new);

    public PacketGenExtraGuiInteract(GenExtraGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.getBlockPos());
    }

    public PacketGenExtraGuiInteract(GenExtraGuiInteraction interaction, BlockEntity tile, double extra) {
        this(interaction, tile.getBlockPos(), extra);
    }

    public PacketGenExtraGuiInteract(GenExtraGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    @NotNull
    public CustomPacketPayload.Type<PacketGenExtraGuiInteract> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        Player player = context.player();
        TileEntityMekanism tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.level(), (BlockPos)this.tilePosition);
        if (tile != null) {
            this.interaction.consume(tile, player, this.extra);
        }
    }

    public static enum GenExtraGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityNaquadahReactorCasing) {
                TileEntityNaquadahReactorCasing reactorBlock = (TileEntityNaquadahReactorCasing)((Object)tile);
                reactorBlock.setInjectionRateFromPacket((int)Math.round(extra));
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityNaquadahReactorLogicAdapter) {
                TileEntityNaquadahReactorLogicAdapter logicAdapter = (TileEntityNaquadahReactorLogicAdapter)((Object)tile);
                logicAdapter.setLogicTypeFromPacket(TileEntityNaquadahReactorLogicAdapter.NaquadahReactorLogic.BY_ID.apply((int)Math.round(extra)));
            }
        }));

        public static final IntFunction<GenExtraGuiInteraction> BY_ID;
        public static final StreamCodec<ByteBuf, GenExtraGuiInteraction> STREAM_CODEC;
        private final TriConsumer<TileEntityMekanism, Player, Double> consumerForTile;

        private GenExtraGuiInteraction(TriConsumer<TileEntityMekanism, Player, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])GenExtraGuiInteraction.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

