/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.mekajadeupgrade.client.provider;

import java.util.ArrayList;
import mekanism.api.Upgrade;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.registration.impl.ItemRegistryObject;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum UpgradeProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag tag = accessor.getServerData();
        ArrayList<IElement> elements = new ArrayList<IElement>();
        int x = 0;
        for (Upgrade upgrade : Upgrade.values()) {
            if (!tag.contains(upgrade.getSerializedName())) continue;
            int count = tag.getInt(upgrade.getSerializedName());
            elements.add(this.item(upgrade, x));
            elements.add(this.countText(count, x));
            x += 10;
        }
        tooltip.add(elements);
    }

    public IElement item(Upgrade upgrade, int x) {
        return IElementHelper.get().item(new ItemStack((ItemLike)this.getUpgrade(upgrade).get()), 0.55f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2((float)x, -2.0f)).message(null);
    }

    public IElement countText(int count, int x) {
        return IElementHelper.get().text((Component)Component.literal((String)("x" + count))).size(new Vec2(5.0f, 5.0f)).translate(new Vec2((float)x, -1.0f)).message(null);
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        TileEntityMekanism be = (TileEntityMekanism)accessor.getBlockEntity();
        for (Upgrade upgrade : Upgrade.values()) {
            if (!be.getComponent().isUpgradeInstalled(upgrade)) continue;
            data.putInt(upgrade.getSerializedName(), be.getComponent().getUpgrades(upgrade));
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"mekajadeupgrade", (String)"upgrades");
    }

    public ItemRegistryObject<ItemUpgrade> getUpgrade(Upgrade upgrade) {
        return switch (upgrade) {
            case Upgrade.SPEED -> MekanismItems.SPEED_UPGRADE;
            case Upgrade.ENERGY -> MekanismItems.ENERGY_UPGRADE;
            case Upgrade.CHEMICAL -> MekanismItems.CHEMICAL_UPGRADE;
            case Upgrade.ANCHOR -> MekanismItems.ANCHOR_UPGRADE;
            case Upgrade.FILTER -> MekanismItems.FILTER_UPGRADE;
            case Upgrade.MUFFLING -> MekanismItems.MUFFLING_UPGRADE;
            case Upgrade.STONE_GENERATOR -> MekanismItems.STONE_GENERATOR_UPGRADE;
            default -> null;
        };
    }
}

