/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.mekagenjei.utils;

public class Numbers {
    public static String toCompact(double value) {
        if (value < 1.0) {
            return String.valueOf(value);
        }
        String suffix = "";
        double scaledValue = value;
        if (value >= 1.0E9) {
            scaledValue = value / 1.0E9;
            suffix = "B";
        } else if (value >= 1000000.0) {
            scaledValue = value / 1000000.0;
            suffix = "M";
        } else if (value >= 1000.0) {
            scaledValue = value / 1000.0;
            suffix = "k";
        }
        double truncated = Math.floor(scaledValue * 10.0) / 10.0;
        if (truncated == (double)((long)truncated)) {
            return String.format("%d%s", (long)truncated, suffix);
        }
        return String.format("%.1f%s", truncated, suffix);
    }

    public static int jouleToFE(long j) {
        return (int)(j * 2L) / 5;
    }

    public static long feToJoule(int fe) {
        return (long)(fe * 5) / 2L;
    }

    public static String simplify(double value) {
        return value % 1.0 == 0.0 ? String.format("%.0f", value) : String.valueOf(value);
    }
}

