/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.core.definitions.BlockDefinition;
import appeng.core.definitions.ItemDefinition;
import appeng.items.AEBaseItem;
import gripe._90.megacells.definition.MEGABlocks;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.definition.MEGATranslations;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class MEGACreativeTab {
    public static final DeferredRegister<CreativeModeTab> DR = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"megacells");

    private static void populateTab(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output output) {
        ArrayList<Object> itemDefs = new ArrayList<Object>();
        itemDefs.addAll(MEGAItems.getItems());
        itemDefs.addAll(MEGABlocks.getBlocks().stream().map(BlockDefinition::item).toList());
        for (ItemDefinition itemDefinition : itemDefs) {
            AEBaseBlockItem baseItem;
            Block block;
            Item item = itemDefinition.asItem();
            if (item instanceof AEBaseBlockItem && (block = (baseItem = (AEBaseBlockItem)item).getBlock()) instanceof AEBaseBlock) {
                AEBaseBlock baseBlock = (AEBaseBlock)block;
                baseBlock.addToMainCreativeTab(params, output);
                continue;
            }
            if (item instanceof AEBaseItem) {
                AEBaseItem baseItem2 = (AEBaseItem)item;
                baseItem2.addToMainCreativeTab(params, output);
                continue;
            }
            output.accept((ItemLike)itemDefinition);
        }
    }

    static {
        DR.register("tab", () -> CreativeModeTab.builder().title((Component)MEGATranslations.ModName.text()).icon(() -> MEGAItems.ITEM_CELL_256M.stack()).displayItems(MEGACreativeTab::populateTab).build());
    }
}

