/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class WandUndoManager {
    private static final int MAX_UNDO_ACTIONS = 3;
    private static final Map<UUID, LinkedList<WandAction>> playerUndoHistory = new HashMap<UUID, LinkedList<WandAction>>();

    public static void recordAction(ServerPlayer player, List<BlockPlacement> placements) {
        UUID playerId = player.getUUID();
        LinkedList history = playerUndoHistory.computeIfAbsent(playerId, k -> new LinkedList());
        history.addFirst(new WandAction(placements, System.currentTimeMillis()));
        while (history.size() > 3) {
            history.removeLast();
        }
    }

    public static boolean undoLastAction(ServerPlayer player) {
        UUID playerId = player.getUUID();
        LinkedList<WandAction> history = playerUndoHistory.get(playerId);
        if (history == null || history.isEmpty()) {
            return false;
        }
        WandAction action = history.removeFirst();
        Level level = player.level();
        for (int i = action.placements.size() - 1; i >= 0; --i) {
            BlockEntity blockEntity;
            BlockPlacement placement = action.placements.get(i);
            level.setBlock(placement.pos, placement.originalState, 3);
            if (placement.originalBlockEntityData != null && (blockEntity = level.getBlockEntity(placement.pos)) != null) {
                blockEntity.loadWithComponents(placement.originalBlockEntityData, (HolderLookup.Provider)level.registryAccess());
            }
            if (player.isCreative() || placement.usedItem == null || player.getInventory().add(placement.usedItem.copy())) continue;
            player.drop(placement.usedItem.copy(), false);
        }
        return true;
    }

    public static int getUndoCount(UUID playerId) {
        LinkedList<WandAction> history = playerUndoHistory.get(playerId);
        return history != null ? history.size() : 0;
    }

    public static void clearHistory(UUID playerId) {
        playerUndoHistory.remove(playerId);
    }

    private static class WandAction {
        public final List<BlockPlacement> placements;
        public final long timestamp;

        public WandAction(List<BlockPlacement> placements, long timestamp) {
            this.placements = placements;
            this.timestamp = timestamp;
        }
    }

    public static class BlockPlacement {
        public final BlockPos pos;
        public final BlockState originalState;
        public final BlockState placedState;
        public final ItemStack usedItem;
        public final CompoundTag originalBlockEntityData;

        public BlockPlacement(BlockPos pos, BlockState originalState, BlockState placedState, ItemStack usedItem, CompoundTag originalBlockEntityData) {
            this.pos = pos;
            this.originalState = originalState;
            this.placedState = placedState;
            this.usedItem = usedItem;
            this.originalBlockEntityData = originalBlockEntityData;
        }
    }
}

