/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.CuriosCompat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ReplaceSystem {
    private static Set<Block> blacklistedBlocksCache = null;
    private static Set<TagKey<Block>> blacklistedTagsCache = null;
    private static long lastCacheUpdate = 0L;
    private static final long CACHE_DURATION = 60000L;

    public static boolean isReplaceModeActive(Player player, boolean trowelReplaceMode) {
        if (!MechTrowel.Config.isReplaceModeEnabled()) {
            return false;
        }
        if (player.isCreative()) {
            return trowelReplaceMode;
        }
        return trowelReplaceMode;
    }

    public static boolean canReplaceBlock(Level level, BlockPos pos, BlockState state, Player player) {
        if (state.isAir()) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        if (ReplaceSystem.isBlacklisted(state)) {
            return false;
        }
        if (state.getBlock().defaultDestroyTime() < 0.0f) {
            return false;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            // empty if block
        }
        return true;
    }

    public static boolean replaceBlock(Level level, BlockPos pos, BlockState oldState, BlockState newState, Player player) {
        if (!ReplaceSystem.canReplaceBlock(level, pos, oldState, player)) {
            return false;
        }
        if (!player.isCreative() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)oldState);
            List drops = oldState.getDrops(lootBuilder);
            for (ItemStack drop : drops) {
                if (drop.isEmpty() || ReplaceSystem.addToPlayerInventory(player, drop)) continue;
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity != null) {
                // empty if block
            }
        }
        level.removeBlock(pos, false);
        return level.setBlock(pos, newState, 3);
    }

    private static boolean isBlacklisted(BlockState state) {
        ReplaceSystem.updateCacheIfNeeded();
        Block block = state.getBlock();
        if (blacklistedBlocksCache.contains(block)) {
            return true;
        }
        for (TagKey<Block> tag : blacklistedTagsCache) {
            if (!state.is(tag)) continue;
            return true;
        }
        return false;
    }

    private static void updateCacheIfNeeded() {
        long currentTime = System.currentTimeMillis();
        if (blacklistedBlocksCache == null || currentTime - lastCacheUpdate > 60000L) {
            ReplaceSystem.updateCache();
            lastCacheUpdate = currentTime;
        }
    }

    private static void updateCache() {
        blacklistedBlocksCache = new HashSet<Block>();
        for (String string : MechTrowel.Config.getReplaceBlacklistBlocks()) {
            try {
                ResourceLocation resourceLocation = ResourceLocation.parse((String)string);
                Block block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
                if (block == Blocks.AIR) continue;
                blacklistedBlocksCache.add(block);
            }
            catch (Exception e) {
                MechTrowel.LOGGER.warn("Invalid block ID in replace blacklist: " + string);
            }
        }
        blacklistedTagsCache = new HashSet<TagKey<Block>>();
        for (String string : MechTrowel.Config.getReplaceBlacklistTags()) {
            if (!string.startsWith("#")) continue;
            try {
                String cleanTagId = string.substring(1);
                ResourceLocation resourceLocation = ResourceLocation.parse((String)cleanTagId);
                TagKey tag = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)resourceLocation);
                blacklistedTagsCache.add((TagKey<Block>)tag);
            }
            catch (Exception e) {
                MechTrowel.LOGGER.warn("Invalid tag ID in replace blacklist: " + string);
            }
        }
    }

    public static void clearCache() {
        blacklistedBlocksCache = null;
        blacklistedTagsCache = null;
        lastCacheUpdate = 0L;
    }

    private static boolean addToPlayerInventory(Player player, ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return true;
        }
        ItemStack remaining = itemStack.copy();
        if ((remaining = ReplaceSystem.addToMainInventory(player, remaining)).isEmpty()) {
            return true;
        }
        if ((remaining = ReplaceSystem.addToShulkerBoxes(player, remaining)).isEmpty()) {
            return true;
        }
        if ((remaining = ReplaceSystem.addToModdedContainers(player, remaining)).isEmpty()) {
            return true;
        }
        if (ModList.get().isLoaded("curios") && (remaining = ReplaceSystem.addToCuriosContainers(player, remaining)).isEmpty()) {
            return true;
        }
        return remaining.isEmpty();
    }

    private static ItemStack addToMainInventory(Player player, ItemStack itemStack) {
        ItemStack existing;
        int i;
        Inventory inventory = player.getInventory();
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            int maxStackSize;
            int canAdd;
            existing = inventory.getItem(i);
            if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)itemStack) || (canAdd = (maxStackSize = Math.min(itemStack.getMaxStackSize(), existing.getMaxStackSize())) - existing.getCount()) <= 0) continue;
            int toAdd = Math.min(canAdd, itemStack.getCount());
            existing.grow(toAdd);
            itemStack.shrink(toAdd);
            if (!itemStack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            existing = inventory.getItem(i);
            if (!existing.isEmpty()) continue;
            inventory.setItem(i, itemStack.copy());
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private static ItemStack addToShulkerBoxes(Player player, ItemStack itemStack) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            BlockItem blockItem;
            Item item;
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock) || !(itemStack = ReplaceSystem.addToShulkerBox(stack, itemStack)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private static ItemStack addToShulkerBox(ItemStack shulkerBox, ItemStack itemStack) {
        ItemContainerContents contents = (ItemContainerContents)shulkerBox.get(DataComponents.CONTAINER);
        if (contents != null) {
            ItemStack existing;
            int slot;
            ArrayList items = new ArrayList(contents.stream().toList());
            while (items.size() < 27) {
                items.add(ItemStack.EMPTY);
            }
            for (slot = 0; slot < items.size(); ++slot) {
                int maxStackSize;
                int canAdd;
                existing = (ItemStack)items.get(slot);
                if (existing.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)itemStack) || (canAdd = (maxStackSize = Math.min(itemStack.getMaxStackSize(), existing.getMaxStackSize())) - existing.getCount()) <= 0) continue;
                int toAdd = Math.min(canAdd, itemStack.getCount());
                existing.grow(toAdd);
                itemStack.shrink(toAdd);
                items.set(slot, existing);
                if (!itemStack.isEmpty()) continue;
                ItemContainerContents newContents = ItemContainerContents.fromItems(items);
                shulkerBox.set(DataComponents.CONTAINER, (Object)newContents);
                return ItemStack.EMPTY;
            }
            for (slot = 0; slot < items.size(); ++slot) {
                existing = (ItemStack)items.get(slot);
                if (!existing.isEmpty()) continue;
                items.set(slot, itemStack.copy());
                ItemContainerContents newContents = ItemContainerContents.fromItems(items);
                shulkerBox.set(DataComponents.CONTAINER, (Object)newContents);
                return ItemStack.EMPTY;
            }
        }
        return itemStack;
    }

    private static ItemStack addToModdedContainers(Player player, ItemStack itemStack) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !ReplaceSystem.isModdedContainer(stack) || !(itemStack = ReplaceSystem.addToModdedContainer(stack, itemStack)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        for (ItemStack stack : player.getArmorSlots()) {
            if (stack.isEmpty() || !ReplaceSystem.isModdedContainer(stack) || !(itemStack = ReplaceSystem.addToModdedContainer(stack, itemStack)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private static ItemStack addToModdedContainer(ItemStack container, ItemStack itemStack) {
        IItemHandler cap = (IItemHandler)container.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack remaining = cap.insertItem(-1, itemStack, false);
            return remaining;
        }
        return itemStack;
    }

    private static ItemStack addToCuriosContainers(Player player, ItemStack itemStack) {
        if (!ModList.get().isLoaded("curios")) {
            return itemStack;
        }
        List<ItemStack> containers = CuriosCompat.getContainersFromCurios(player);
        for (ItemStack container : containers) {
            if (!ReplaceSystem.isModdedContainer(container) || !(itemStack = ReplaceSystem.addToModdedContainer(container, itemStack)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private static boolean isModdedContainer(ItemStack stack) {
        String itemClass;
        if (ModList.get().isLoaded("sophisticatedbackpacks") && (itemClass = stack.getItem().getClass().getName()).contains("sophisticatedbackpacks")) {
            return true;
        }
        itemClass = stack.getItem().getClass().getName().toLowerCase();
        String itemId = stack.getItem().toString().toLowerCase();
        String registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().toLowerCase();
        if (itemClass.contains("backpack") || itemClass.contains("bag") || itemClass.contains("pouch") || itemId.contains("backpack") || itemId.contains("bag") || itemId.contains("pouch") || registryName.contains("backpack") || registryName.contains("bag") || registryName.contains("pouch")) {
            IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
            return cap != null;
        }
        return false;
    }
}

