/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.BlockRotationConfig;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.util.CopycatSlabHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockRotationHelper {
    public static BlockState applyRotation(BlockState state, RotationLockData globalRotation, BlockRotationConfig blockRotation, Player player, Direction clickedFace) {
        Direction horizontalLock = null;
        Direction verticalLock = null;
        Direction lastActivated = null;
        if (BlockRotationHelper.hasActiveGlobalDirectionLocks(globalRotation)) {
            horizontalLock = globalRotation.getLockedHorizontalDirection();
            verticalLock = globalRotation.getLockedVerticalDirection();
            lastActivated = globalRotation.getLastActivatedDirection();
        } else if (blockRotation != null && !blockRotation.getLockedFaces().isEmpty()) {
            for (Direction dir : blockRotation.getLockedFaces()) {
                if (dir.getAxis() == Direction.Axis.Y) {
                    verticalLock = dir;
                    continue;
                }
                horizontalLock = dir;
            }
        }
        RotationLockData.StairMode stairMode = RotationLockData.StairMode.AUTO;
        RotationLockData.SlabMode slabMode = RotationLockData.SlabMode.AUTO;
        RotationLockData.OpenMode openMode = RotationLockData.OpenMode.AUTO;
        if (blockRotation != null && blockRotation.getStairMode() != RotationLockData.StairMode.AUTO) {
            stairMode = blockRotation.getStairMode();
        } else if (globalRotation.getStairMode() != RotationLockData.StairMode.AUTO) {
            stairMode = globalRotation.getStairMode();
        }
        if (blockRotation != null && blockRotation.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            slabMode = blockRotation.getSlabMode();
        } else if (globalRotation.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            slabMode = globalRotation.getSlabMode();
        }
        if (blockRotation != null && blockRotation.getOpenMode() != RotationLockData.OpenMode.AUTO) {
            openMode = blockRotation.getOpenMode();
        } else if (globalRotation.getOpenMode() != RotationLockData.OpenMode.AUTO) {
            openMode = globalRotation.getOpenMode();
        }
        return BlockRotationHelper.applyRotationCombined(state, horizontalLock, verticalLock, lastActivated, stairMode, slabMode, openMode, player, clickedFace);
    }

    public static boolean hasActiveGlobalDirectionLocks(RotationLockData data) {
        return !data.getLockedFaces().isEmpty();
    }

    public static boolean hasActiveGlobalSettings(RotationLockData data) {
        return !data.getLockedFaces().isEmpty() || data.getStairMode() != RotationLockData.StairMode.AUTO || data.getSlabMode() != RotationLockData.SlabMode.AUTO || data.getOpenMode() != RotationLockData.OpenMode.AUTO;
    }

    private static BlockState applyRotationCombined(BlockState state, Direction horizontalLock, Direction verticalLock, Direction lastActivated, RotationLockData.StairMode stairMode, RotationLockData.SlabMode slabMode, RotationLockData.OpenMode openMode, Player player, Direction clickedFace) {
        Block block = state.getBlock();
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction lockedDir = BlockRotationHelper.getDirectionForFullFacing(horizontalLock, verticalLock, lastActivated);
            state = lockedDir != null ? (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)lockedDir) : (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !(block instanceof StairBlock) && !(block instanceof FenceGateBlock)) {
            state = horizontalLock != null ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalLock) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection().getOpposite());
        }
        if (block instanceof FenceGateBlock) {
            state = BlockRotationHelper.applyFenceGateRotationCombined(state, horizontalLock, openMode, player);
        }
        if (block instanceof StairBlock && state.hasProperty((Property)BlockStateProperties.HALF)) {
            state = BlockRotationHelper.applyStairRotationCombined(state, horizontalLock, verticalLock, stairMode, player, clickedFace);
        }
        if (block instanceof SlabBlock && state.hasProperty((Property)BlockStateProperties.SLAB_TYPE) && !CopycatSlabHelper.isCopycatSlab(state)) {
            state = BlockRotationHelper.applySlabRotationCombined(state, verticalLock, slabMode, player, clickedFace);
        }
        if (state.hasProperty((Property)BlockStateProperties.AXIS)) {
            Direction axisDirection = BlockRotationHelper.getDirectionForAxis(horizontalLock, verticalLock, lastActivated);
            state = axisDirection != null ? (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)axisDirection.getAxis()) : (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)clickedFace.getAxis());
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && !(block instanceof FenceGateBlock)) {
            boolean shouldBeOpen = switch (openMode) {
                default -> throw new MatchException(null, null);
                case RotationLockData.OpenMode.OPEN -> true;
                case RotationLockData.OpenMode.CLOSED -> false;
                case RotationLockData.OpenMode.AUTO -> false;
            };
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        }
        return state;
    }

    private static Direction getDirectionForFullFacing(Direction horizontalLock, Direction verticalLock, Direction lastActivated) {
        if (horizontalLock != null && verticalLock != null) {
            return lastActivated;
        }
        if (horizontalLock != null) {
            return horizontalLock;
        }
        if (verticalLock != null) {
            return verticalLock;
        }
        return null;
    }

    private static Direction getDirectionForAxis(Direction horizontalLock, Direction verticalLock, Direction lastActivated) {
        if (horizontalLock != null && verticalLock != null) {
            return lastActivated;
        }
        if (horizontalLock != null) {
            return horizontalLock;
        }
        if (verticalLock != null) {
            return verticalLock;
        }
        return null;
    }

    private static BlockState applyStairRotationCombined(BlockState state, Direction horizontalLock, Direction verticalLock, RotationLockData.StairMode stairMode, Player player, Direction clickedFace) {
        Half half;
        if (verticalLock != null) {
            half = verticalLock == Direction.UP ? Half.TOP : Half.BOTTOM;
        } else {
            switch (stairMode) {
                case TOP: {
                    half = Half.TOP;
                    break;
                }
                case BOTTOM: {
                    half = Half.BOTTOM;
                    break;
                }
                default: {
                    half = clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? Half.TOP : Half.BOTTOM;
                }
            }
        }
        state = (BlockState)state.setValue((Property)BlockStateProperties.HALF, (Comparable)half);
        state = horizontalLock != null ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)horizontalLock) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        return state;
    }

    private static BlockState applySlabRotationCombined(BlockState state, Direction verticalLock, RotationLockData.SlabMode slabMode, Player player, Direction clickedFace) {
        SlabType type;
        if (verticalLock != null) {
            type = verticalLock == Direction.UP ? SlabType.TOP : SlabType.BOTTOM;
        } else {
            switch (slabMode) {
                case TOP: {
                    type = SlabType.TOP;
                    break;
                }
                case BOTTOM: {
                    type = SlabType.BOTTOM;
                    break;
                }
                default: {
                    type = clickedFace == Direction.DOWN || clickedFace != Direction.UP && player.getXRot() > 0.0f ? SlabType.TOP : SlabType.BOTTOM;
                }
            }
        }
        return (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)type);
    }

    private static BlockState applyFenceGateRotationCombined(BlockState state, Direction lockedDirection, RotationLockData.OpenMode openMode, Player player) {
        state = lockedDirection != null && lockedDirection.getAxis() != Direction.Axis.Y ? (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)lockedDirection) : (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)player.getDirection());
        boolean shouldBeOpen = switch (openMode) {
            default -> throw new MatchException(null, null);
            case RotationLockData.OpenMode.OPEN -> true;
            case RotationLockData.OpenMode.CLOSED -> false;
            case RotationLockData.OpenMode.AUTO -> false;
        };
        state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(shouldBeOpen));
        return state;
    }
}

