/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public class VerticalLockToggle
extends Button {
    private static final int TRACK_WIDTH = 6;
    private static final int TRACK_HEIGHT = 12;
    private static final int CUBE_SIZE = 4;
    private static final int SLOT_BG = -12829636;
    private static final int BORDER_DARK = -14803426;
    private static final int BORDER_LIGHT = -10855846;
    private static final int ON_COLOR = -11751600;
    private static final int OFF_COLOR = -769226;
    private boolean locked;
    private final OnLockToggle onToggle;
    private float animationProgress = 0.0f;
    private boolean isProcessingClick = false;
    private boolean hasBeenInitialized = false;

    public VerticalLockToggle(int x, int y, boolean initialLocked, OnLockToggle onToggle) {
        super(x, y, 6, 12, (Component)Component.empty(), button -> {
            VerticalLockToggle toggle = (VerticalLockToggle)button;
            if (!toggle.isProcessingClick) {
                toggle.toggle();
            }
        }, DEFAULT_NARRATION);
        this.locked = initialLocked;
        this.animationProgress = initialLocked ? 1.0f : 0.0f;
        this.onToggle = onToggle;
    }

    private void toggle() {
        if (this.isProcessingClick) {
            return;
        }
        this.isProcessingClick = true;
        boolean newLocked = !this.locked;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        if (this.onToggle != null) {
            this.onToggle.onToggle(newLocked);
        }
        this.locked = newLocked;
        Minecraft.getInstance().tell(() -> {
            this.isProcessingClick = false;
        });
    }

    public void setLocked(boolean locked) {
        if (!this.hasBeenInitialized) {
            this.locked = locked;
            this.animationProgress = locked ? 1.0f : 0.0f;
            this.hasBeenInitialized = true;
        } else if (this.locked != locked) {
            this.locked = locked;
        }
        this.isProcessingClick = false;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float targetProgress;
        if (!this.visible) {
            return;
        }
        float f = targetProgress = this.locked ? 1.0f : 0.0f;
        if (this.animationProgress != targetProgress) {
            float animSpeed = 0.15f;
            this.animationProgress = this.animationProgress < targetProgress ? Math.min(this.animationProgress + animSpeed, targetProgress) : Math.max(this.animationProgress - animSpeed, targetProgress);
        }
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12829636);
        this.renderInsetBorder(guiGraphics, this.getX(), this.getY(), this.width, this.height);
        int cubeX = this.getX() + (this.width - 4) / 2;
        int topY = this.getY() + 2;
        int bottomY = this.getY() + this.height - 4 - 2;
        int cubeY = (int)((float)topY + (float)(bottomY - topY) * this.animationProgress);
        this.renderCube(guiGraphics, cubeX, cubeY);
        if (this.isProcessingClick) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0x20FFFFFF);
        }
    }

    private void renderInsetBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.hLine(x, x + width - 1, y, -14803426);
        guiGraphics.vLine(x, y, y + height - 1, -14803426);
        guiGraphics.hLine(x, x + width - 1, y + height - 1, -10855846);
        guiGraphics.vLine(x + width - 1, y, y + height - 1, -10855846);
    }

    private void renderCube(GuiGraphics guiGraphics, int x, int y) {
        int color;
        int n = color = this.locked ? -769226 : -11751600;
        if (this.isHovered && !this.isProcessingClick) {
            int glowColor = this.locked ? 0x33FF0000 : 0x3300FF00;
            guiGraphics.fill(x - 1, y - 1, x + 4 + 1, y + 4 + 1, glowColor);
        }
        guiGraphics.fill(x, y, x + 4, y + 4, color);
        guiGraphics.hLine(x, x + 4 - 1, y, 0x33FFFFFF);
        guiGraphics.vLine(x, y, y + 4 - 1, 0x33FFFFFF);
    }

    public Component getMessage() {
        return Component.literal((String)(this.locked ? "Locked" : "Unlocked"));
    }

    public static interface OnLockToggle {
        public void onToggle(boolean var1);
    }
}

