/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class StyledToggleButton
extends Button {
    private static final int SLOT_BG = -12829636;
    private static final int BORDER_DARK = -14803426;
    private static final int BORDER_LIGHT = -10855846;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int TOGGLE_WIDTH = 8;
    private static final int CUBE_SIZE = 4;
    private static final int ON_COLOR = -11751600;
    private static final int OFF_COLOR = -769226;
    private final boolean isToggle;
    private boolean toggled;
    private final Consumer<Boolean> onToggle;
    private final Runnable onClick;
    private float animationProgress = 0.0f;

    public StyledToggleButton(int x, int y, int width, int height, Component text, boolean initialState, Consumer<Boolean> onToggle) {
        super(x, y, width, height, text, button -> {
            StyledToggleButton stb = (StyledToggleButton)button;
            stb.toggled = !stb.toggled;
            stb.playDownSound(Minecraft.getInstance().getSoundManager());
            if (stb.onToggle != null) {
                stb.onToggle.accept(stb.toggled);
            }
        }, DEFAULT_NARRATION);
        this.isToggle = true;
        this.toggled = initialState;
        this.animationProgress = initialState ? 1.0f : 0.0f;
        this.onToggle = onToggle;
        this.onClick = null;
    }

    public StyledToggleButton(int x, int y, int width, int height, Component text, Runnable onClick) {
        super(x, y, width, height, text, button -> {
            button.playDownSound(Minecraft.getInstance().getSoundManager());
            if (((StyledToggleButton)button).onClick != null) {
                ((StyledToggleButton)button).onClick.run();
            }
        }, DEFAULT_NARRATION);
        this.isToggle = false;
        this.toggled = false;
        this.onToggle = null;
        this.onClick = onClick;
    }

    public void setToggled(boolean toggled) {
        if (this.isToggle) {
            this.toggled = toggled;
        }
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        if (this.isToggle) {
            float targetProgress;
            float f = targetProgress = this.toggled ? 1.0f : 0.0f;
            if (this.animationProgress != targetProgress) {
                float animSpeed = 0.2f;
                this.animationProgress = this.animationProgress < targetProgress ? Math.min(this.animationProgress + animSpeed, targetProgress) : Math.max(this.animationProgress - animSpeed, targetProgress);
            }
        }
        int buttonWidth = this.isToggle ? this.width - 8 : this.width;
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + buttonWidth, this.getY() + this.height, -12829636);
        this.renderInsetBorder(guiGraphics, this.getX(), this.getY(), buttonWidth, this.height);
        if (this.isHovered) {
            guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + buttonWidth - 1, this.getY() + this.height - 1, 0x20FFFFFF);
        }
        Component displayText = this.getMessage();
        int textWidth = Minecraft.getInstance().font.width((FormattedText)displayText);
        int textX = this.getX() + (buttonWidth - textWidth) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        guiGraphics.drawString(Minecraft.getInstance().font, displayText, textX, textY, 0xFFFFFF, false);
        if (this.isToggle) {
            this.renderToggleIndicator(guiGraphics, this.getX() + buttonWidth, this.getY(), 8, this.height);
        }
        if (!this.active) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Integer.MIN_VALUE);
        }
    }

    private void renderInsetBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.hLine(x, x + width - 1, y, -14803426);
        guiGraphics.vLine(x, y, y + height - 1, -14803426);
        guiGraphics.hLine(x, x + width - 1, y + height - 1, -10855846);
        guiGraphics.vLine(x + width - 1, y, y + height - 1, -10855846);
    }

    private void renderToggleIndicator(GuiGraphics guiGraphics, int x, int y, int w, int h) {
        guiGraphics.fill(x, y, x + w, y + h, -12829636);
        this.renderInsetBorder(guiGraphics, x, y, w, h);
        int cubeX = x + (w - 4) / 2;
        int topY = y + 2;
        int bottomY = y + h - 4 - 2;
        int cubeY = (int)((float)topY + (float)(bottomY - topY) * this.animationProgress);
        this.renderCube(guiGraphics, cubeX, cubeY);
    }

    private void renderCube(GuiGraphics guiGraphics, int x, int y) {
        int color;
        int n = color = this.toggled ? -11751600 : -769226;
        if (this.isHovered) {
            int glowColor = this.toggled ? 0x3300FF00 : 0x33FF0000;
            guiGraphics.fill(x - 1, y - 1, x + 4 + 1, y + 4 + 1, glowColor);
        }
        guiGraphics.fill(x, y, x + 4, y + 4, color);
        guiGraphics.hLine(x, x + 4 - 1, y, 0x33FFFFFF);
        guiGraphics.vLine(x, y, y + 4 - 1, 0x33FFFFFF);
    }
}

