/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import com.asger.mechtrowel.compat.create.CreateCompat;
import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.BlockRotationConfig;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.PaletteLayoutConstants;
import com.asger.mechtrowel.gui.PaletteMenu;
import com.asger.mechtrowel.gui.widget.GhostSlot;
import com.asger.mechtrowel.gui.widget.InteractivePercentageBar;
import com.asger.mechtrowel.gui.widget.NoFocusButton;
import com.asger.mechtrowel.gui.widget.PaletteDropdown;
import com.asger.mechtrowel.gui.widget.StyledToggleButton;
import com.asger.mechtrowel.gui.widget.VerticalLockToggle;
import com.asger.mechtrowel.network.TrowelPacket;
import com.asger.mechtrowel.util.PaletteBalancer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class PaletteScreen
extends AbstractContainerScreen<PaletteMenu> {
    private static final ResourceLocation PALETTE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"textures/gui/palette_gui.png");
    private static final ResourceLocation PALETTE_TEXTURE_SMALL = ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"textures/gui/small_palette_gui.png");
    private static final ResourceLocation PALETTE_ROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"textures/gui/palette_row_gui.png");
    private static final ResourceLocation INVENTORY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"textures/gui/inventory_gui.png");
    private static final int PALETTE_TEX_WIDTH = 230;
    private static final int PALETTE_TEX_HEIGHT = 240;
    private static final int PALETTE_TEX_HEIGHT_SMALL = 172;
    private static final int PALETTE_ROW_TEX_WIDTH = 203;
    private static final int PALETTE_ROW_TEX_HEIGHT = 34;
    private static final int INVENTORY_TEX_WIDTH = 176;
    private static final int INVENTORY_TEX_HEIGHT = 100;
    private int calculatedInventoryY;
    private int calculatedGridY;
    private int dropdownY;
    private int calculatedControlsY;
    private int calculatedGlobalY;
    private TrowelData trowelData;
    private PaletteData currentPalette;
    private int currentPaletteIndex;
    private PaletteDropdown paletteSelector;
    private Button createButton;
    private Button renameButton;
    private Button deleteButton;
    private EditBox renameBox;
    private Button confirmDeleteButton;
    private Button cancelDeleteButton;
    private boolean isRenaming = false;
    private boolean isDeleting = false;
    private Button confirmRenameButton;
    private Button cancelRenameButton;
    private SimpleContainer iconContainer;
    private BlockState selectedIconBlock;
    private List<InteractivePercentageBar> percentageBars;
    private List<VerticalLockToggle> lockButtons;
    private Button resetButton;
    private Button equalButton;
    private boolean isUpdatingUI = false;
    private long lastUpdateTime = 0L;
    private boolean isConfiguringCopycat = false;
    private int copycatConfigSlot = -1;
    private CopycatBlockConfig workingCopycatConfig = null;
    private Button copycatLitButton;
    private Button copycatAxisButton;
    private Button copycatRotationButton;
    private Component copycatInstructionText;
    private boolean isConfiguringFramed = false;
    private int framedConfigSlot = -1;
    private FramedBlockConfig workingFramedConfig = null;
    private Button framedRotationButton;
    private Component framedInstructionText;
    private boolean isConfiguringRotation = false;
    private Set<Integer> rotationConfigSlots = new HashSet<Integer>();
    private BlockRotationConfig workingRotationConfig = null;
    private boolean rotationBlockHasProperties = false;
    private StyledToggleButton rotationNorthButton;
    private StyledToggleButton rotationSouthButton;
    private StyledToggleButton rotationEastButton;
    private StyledToggleButton rotationWestButton;
    private StyledToggleButton rotationUpButton;
    private StyledToggleButton rotationDownButton;
    private StyledToggleButton rotationStairAutoButton;
    private StyledToggleButton rotationStairTopButton;
    private StyledToggleButton rotationStairBottomButton;
    private StyledToggleButton rotationSlabAutoButton;
    private StyledToggleButton rotationSlabTopButton;
    private StyledToggleButton rotationSlabBottomButton;
    private StyledToggleButton rotationOpenAutoButton;
    private StyledToggleButton rotationOpenOpenButton;
    private StyledToggleButton rotationOpenClosedButton;
    private StyledToggleButton rotationStairLinkButton;
    private Button rotationConfirmButton;
    private Button rotationResetButton;
    private StyledToggleButton replaceToggle;
    private StyledToggleButton gradientButton;
    private Button undoButton;
    private int scrollOffset = 0;
    private int maxScrollOffset = 0;
    private boolean canScroll = false;
    private int visibleRows = 4;
    private boolean isScrolling = false;
    private double scrollingStartY = 0.0;
    private static final int LOCK_HEIGHT = 14;

    public PaletteScreen(PaletteMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 230;
        this.imageHeight = PaletteLayoutConstants.calculateTotalHeight();
        this.trowelData = menu.getTrowelData();
        if (this.trowelData.getPalettes().isEmpty()) {
            PaletteData defaultPalette = new PaletteData();
            defaultPalette.setName("Default");
            this.trowelData.addPalette(defaultPalette);
            this.trowelData.save(menu.getTrowelStack());
        }
        this.currentPaletteIndex = this.trowelData.getActivePaletteIndex();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette == null && !this.trowelData.getPalettes().isEmpty()) {
            this.currentPaletteIndex = 0;
            this.currentPalette = this.trowelData.getPalettes().get(0);
            this.trowelData.setActivePaletteIndex(0);
            this.trowelData.save(menu.getTrowelStack());
        }
        this.percentageBars = new ArrayList<InteractivePercentageBar>();
        this.lockButtons = new ArrayList<VerticalLockToggle>();
        this.iconContainer = new SimpleContainer(1);
    }

    protected void init() {
        super.init();
        this.calculateVisibleRows();
        ((PaletteMenu)this.menu).setVisibleRows(this.visibleRows);
        int totalRows = ((PaletteMenu)this.menu).paletteRows;
        this.canScroll = totalRows > this.visibleRows;
        this.maxScrollOffset = this.canScroll ? totalRows - this.visibleRows : 0;
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScrollOffset);
        ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
        int paletteEndY = 52 + this.visibleRows * 34;
        int controlsY = paletteEndY + 2;
        int globalY = controlsY + 20 + 4;
        int inventoryY = globalY + 20 + PaletteLayoutConstants.getInventoryOffset(this.visibleRows);
        this.imageHeight = inventoryY + 100;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        int x = this.leftPos;
        this.dropdownY = this.topPos + 1;
        this.calculatedGridY = this.topPos + 52;
        this.calculatedInventoryY = this.topPos + inventoryY;
        this.calculatedControlsY = this.topPos + controlsY;
        this.calculatedGlobalY = this.topPos + globalY;
        this.initPaletteDropdown(x, this.dropdownY);
        this.initPaletteButtons(x, this.topPos + 28);
        this.initPaletteGrid(x, this.calculatedGridY);
        this.initPaletteControls(x, this.topPos + controlsY);
        this.initGlobalSettings(x, this.topPos + globalY);
        ((PaletteMenu)this.menu).syncContainerWithPalette();
        this.updateUI();
        this.updateRotationButtonPositions();
        this.applyScrollToWidgets();
    }

    private void initPaletteDropdown(int x, int y) {
        if (this.trowelData.getPalettes().isEmpty()) {
            PaletteData defaultPalette = new PaletteData();
            defaultPalette.setName("Default");
            this.trowelData.addPalette(defaultPalette);
            this.currentPaletteIndex = 0;
            this.currentPalette = defaultPalette;
        }
        ArrayList<Integer> paletteIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.trowelData.getPalettes().size(); ++i) {
            paletteIndices.add(i);
        }
        this.paletteSelector = new PaletteDropdown(x + 10, y + 5, 210, 20, paletteIndices, this.currentPaletteIndex, idx -> {
            if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                return Component.literal((String)this.trowelData.getPalettes().get((int)idx).getName());
            }
            return Component.literal((String)"No Palette");
        }, value -> {
            if (value != this.currentPaletteIndex) {
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, (int)value, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
        this.paletteSelector.setIconProvider(idx -> {
            if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                return this.trowelData.getPalettes().get((int)idx).getIconBlock();
            }
            return null;
        });
        this.addRenderableWidget((GuiEventListener)this.paletteSelector);
    }

    private void initPaletteGrid(int x, int y) {
        this.percentageBars.clear();
        this.lockButtons.clear();
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 36;
        int startX = x + (this.imageWidth - totalWidth) / 2;
        PaletteData palette = this.currentPalette;
        for (int i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
            int row = i / 7;
            int col = i % 7;
            int slotX = startX + col * (unitWidth + 6);
            int slotY = y + row * 34 + 3;
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            PaletteData.WeightedBlock paletteBlock = null;
            if (hasBlock && palette != null) {
                for (PaletteData.WeightedBlock block : palette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
            }
            int slotIndex = i;
            int barY = slotY + 18 + 2 + -1;
            InteractivePercentageBar percentBar = new InteractivePercentageBar(slotX, barY, 18, (Screen)this, newPercentage -> this.onPercentageChanged(slotIndex, (int)newPercentage), locked -> this.onLockToggled(slotIndex, (boolean)locked));
            if (paletteBlock != null) {
                percentBar.setPercentage(Math.round(paletteBlock.getWeight()));
                percentBar.setLocked(paletteBlock.isLocked());
                percentBar.setVisible(true);
                percentBar.active = true;
            } else {
                percentBar.setPercentage(0);
                percentBar.setVisible(false);
                percentBar.active = false;
            }
            this.percentageBars.add(percentBar);
            this.addRenderableWidget((GuiEventListener)percentBar);
            int lockY = slotY + 0;
            boolean initialLocked = paletteBlock != null && paletteBlock.isLocked();
            VerticalLockToggle lockButton = new VerticalLockToggle(slotX + 18, lockY, initialLocked, locked -> this.onLockToggled(slotIndex, locked));
            lockButton.visible = paletteBlock != null;
            this.lockButtons.add(lockButton);
            this.addRenderableWidget((GuiEventListener)lockButton);
        }
    }

    private void initPaletteButtons(int x, int y) {
        int buttonWidth = 65;
        int buttonSpacing = 5;
        int totalButtonWidth = buttonWidth * 3 + buttonSpacing * 2;
        int buttonStartX = x + (this.imageWidth - totalButtonWidth) / 2;
        this.createButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.create"), btn -> this.createNewPalette()).bounds(buttonStartX, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.createButton);
        this.renameButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.rename"), btn -> this.startRename()).bounds(buttonStartX + buttonWidth + buttonSpacing, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.renameButton);
        this.deleteButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.delete"), btn -> this.startDelete()).bounds(buttonStartX + (buttonWidth + buttonSpacing) * 2, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.initRenameUI(x, y);
        int deleteButtonWidth = 70;
        int deleteButtonSpacing = 10;
        int deleteTotalWidth = deleteButtonWidth * 2 + deleteButtonSpacing;
        int deleteButtonStartX = x + (this.imageWidth - deleteTotalWidth) / 2;
        this.confirmDeleteButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm \u2713").withStyle(ChatFormatting.RED), btn -> this.confirmDelete()).bounds(deleteButtonStartX, y, deleteButtonWidth, 20).build();
        this.confirmDeleteButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.confirmDeleteButton);
        this.cancelDeleteButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Cancel \u2717").withStyle(ChatFormatting.GRAY), btn -> this.cancelDelete()).bounds(deleteButtonStartX + deleteButtonWidth + deleteButtonSpacing, y, deleteButtonWidth, 20).build();
        this.cancelDeleteButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.cancelDeleteButton);
        int copycatButton1Width = 60;
        int copycatButton2Width = 70;
        int copycatButton3Width = 70;
        int copycatButtonSpacing = 5;
        int copycatTotalWidth = copycatButton1Width + copycatButton2Width + copycatButton3Width + copycatButtonSpacing * 2;
        int copycatButtonStartX = x + (this.imageWidth - copycatTotalWidth) / 2;
        this.copycatLitButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Lit \u2600"), btn -> this.toggleCopycatLit()).bounds(copycatButtonStartX, y, copycatButton1Width, 20).build();
        this.copycatLitButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.copycatLitButton);
        this.copycatAxisButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Axis: Off"), btn -> this.cycleCopycatAxis()).bounds(copycatButtonStartX + copycatButton1Width + copycatButtonSpacing, y, copycatButton2Width, 20).build();
        this.copycatAxisButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.copycatAxisButton);
        NoFocusButton copycatDoneButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN)), btn -> {
            if (this.isConfiguringCopycat) {
                this.finishCopycatConfig();
            } else if (this.isConfiguringFramed) {
                this.finishFramedConfig();
            }
        }).bounds(copycatButtonStartX + copycatButton1Width + copycatButton2Width + copycatButtonSpacing * 2, y, copycatButton3Width, 20).build();
        copycatDoneButton.visible = false;
        this.addRenderableWidget((GuiEventListener)copycatDoneButton);
        int rotationButtonWidth = 70;
        this.copycatRotationButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Rotation"), btn -> {
            if (this.isConfiguringCopycat && this.copycatConfigSlot >= 0) {
                this.openRotationConfig(this.copycatConfigSlot);
            }
        }).bounds(0, 0, rotationButtonWidth, 20).build();
        this.copycatRotationButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.copycatRotationButton);
        this.framedRotationButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Rotation"), btn -> {
            if (this.isConfiguringFramed && this.framedConfigSlot >= 0) {
                this.openRotationConfig(this.framedConfigSlot);
            }
        }).bounds(0, 0, rotationButtonWidth, 20).build();
        this.framedRotationButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.framedRotationButton);
        this.initRotationConfigUI(x, y);
        this.updateUI();
    }

    private void initRotationConfigUI(int x, int y) {
        int dirButtonWidth = 50;
        int dirButtonSpacing = 4;
        int dirRowWidth = dirButtonWidth * 3 + dirButtonSpacing * 2;
        int dirStartX = x + (this.imageWidth - dirRowWidth) / 2;
        int dirRow1Y = this.dropdownY + 5;
        int dirRow2Y = dirRow1Y + 20 + 3;
        this.rotationUpButton = new StyledToggleButton(dirStartX, dirRow1Y, dirButtonWidth, 20, (Component)Component.literal((String)"Up"), false, toggled -> this.onRotationDirectionToggle(Direction.UP, (boolean)toggled));
        this.rotationUpButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationUpButton);
        this.rotationNorthButton = new StyledToggleButton(dirStartX + dirButtonWidth + dirButtonSpacing, dirRow1Y, dirButtonWidth, 20, (Component)Component.literal((String)"North"), false, toggled -> this.onRotationDirectionToggle(Direction.NORTH, (boolean)toggled));
        this.rotationNorthButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationNorthButton);
        this.rotationDownButton = new StyledToggleButton(dirStartX + (dirButtonWidth + dirButtonSpacing) * 2, dirRow1Y, dirButtonWidth, 20, (Component)Component.literal((String)"Down"), false, toggled -> this.onRotationDirectionToggle(Direction.DOWN, (boolean)toggled));
        this.rotationDownButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationDownButton);
        this.rotationWestButton = new StyledToggleButton(dirStartX, dirRow2Y, dirButtonWidth, 20, (Component)Component.literal((String)"West"), false, toggled -> this.onRotationDirectionToggle(Direction.WEST, (boolean)toggled));
        this.rotationWestButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationWestButton);
        this.rotationSouthButton = new StyledToggleButton(dirStartX + dirButtonWidth + dirButtonSpacing, dirRow2Y, dirButtonWidth, 20, (Component)Component.literal((String)"South"), false, toggled -> this.onRotationDirectionToggle(Direction.SOUTH, (boolean)toggled));
        this.rotationSouthButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationSouthButton);
        this.rotationEastButton = new StyledToggleButton(dirStartX + (dirButtonWidth + dirButtonSpacing) * 2, dirRow2Y, dirButtonWidth, 20, (Component)Component.literal((String)"East"), false, toggled -> this.onRotationDirectionToggle(Direction.EAST, (boolean)toggled));
        this.rotationEastButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationEastButton);
        int propButtonWidth = 42;
        int propButtonSpacing = 3;
        int confirmWidth = 55;
        this.rotationStairAutoButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Auto"), true, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationStairMode(RotationLockData.StairMode.AUTO);
            }
        });
        this.rotationStairAutoButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationStairAutoButton);
        this.rotationStairTopButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Top"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationStairMode(RotationLockData.StairMode.TOP);
            }
        });
        this.rotationStairTopButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationStairTopButton);
        this.rotationStairBottomButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Bottom"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationStairMode(RotationLockData.StairMode.BOTTOM);
            }
        });
        this.rotationStairBottomButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationStairBottomButton);
        this.rotationSlabAutoButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Auto"), true, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationSlabMode(RotationLockData.SlabMode.AUTO);
            }
        });
        this.rotationSlabAutoButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationSlabAutoButton);
        this.rotationSlabTopButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Top"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationSlabMode(RotationLockData.SlabMode.TOP);
            }
        });
        this.rotationSlabTopButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationSlabTopButton);
        this.rotationSlabBottomButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Bottom"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationSlabMode(RotationLockData.SlabMode.BOTTOM);
            }
        });
        this.rotationSlabBottomButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationSlabBottomButton);
        this.rotationOpenAutoButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Auto"), true, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationOpenMode(RotationLockData.OpenMode.AUTO);
            }
        });
        this.rotationOpenAutoButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationOpenAutoButton);
        this.rotationOpenOpenButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Open"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationOpenMode(RotationLockData.OpenMode.OPEN);
            }
        });
        this.rotationOpenOpenButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationOpenOpenButton);
        this.rotationOpenClosedButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Closed"), false, toggled -> {
            if (toggled.booleanValue()) {
                this.setRotationOpenMode(RotationLockData.OpenMode.CLOSED);
            }
        });
        this.rotationOpenClosedButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationOpenClosedButton);
        this.rotationStairLinkButton = new StyledToggleButton(x, y, propButtonWidth, 20, (Component)Component.literal((String)"Link"), true, toggled -> {
            if (this.workingRotationConfig != null) {
                this.workingRotationConfig.setStairLink((boolean)toggled);
            }
        });
        this.rotationStairLinkButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationStairLinkButton);
        int actionButtonWidth = 70;
        this.rotationResetButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Reset").withStyle(ChatFormatting.WHITE), btn -> this.resetRotationConfig()).bounds(x, y, actionButtonWidth, 20).build();
        this.rotationResetButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationResetButton);
        this.rotationConfirmButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN)), btn -> this.finishRotationConfig()).bounds(x, y, actionButtonWidth, 20).build();
        this.rotationConfirmButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.rotationConfirmButton);
    }

    private void resetRotationConfig() {
        if (this.workingRotationConfig != null) {
            this.workingRotationConfig.clear();
            this.updateRotationDirectionButtonStates();
            this.updateRotationPropertyButtonStates();
            if (this.rotationStairLinkButton != null) {
                this.rotationStairLinkButton.setToggled(true);
            }
        }
    }

    private void setRotationStairMode(RotationLockData.StairMode mode) {
        if (this.workingRotationConfig != null) {
            this.workingRotationConfig.setStairMode(mode);
            this.updateRotationPropertyButtonStates();
        }
    }

    private void setRotationSlabMode(RotationLockData.SlabMode mode) {
        if (this.workingRotationConfig != null) {
            this.workingRotationConfig.setSlabMode(mode);
            this.updateRotationPropertyButtonStates();
        }
    }

    private void setRotationOpenMode(RotationLockData.OpenMode mode) {
        if (this.workingRotationConfig != null) {
            this.workingRotationConfig.setOpenMode(mode);
            this.updateRotationPropertyButtonStates();
        }
    }

    private void updateRotationPropertyButtonStates() {
        if (this.workingRotationConfig == null) {
            return;
        }
        RotationLockData.StairMode stairMode = this.workingRotationConfig.getStairMode();
        if (this.rotationStairAutoButton != null) {
            this.rotationStairAutoButton.setToggled(stairMode == RotationLockData.StairMode.AUTO);
        }
        if (this.rotationStairTopButton != null) {
            this.rotationStairTopButton.setToggled(stairMode == RotationLockData.StairMode.TOP);
        }
        if (this.rotationStairBottomButton != null) {
            this.rotationStairBottomButton.setToggled(stairMode == RotationLockData.StairMode.BOTTOM);
        }
        RotationLockData.SlabMode slabMode = this.workingRotationConfig.getSlabMode();
        if (this.rotationSlabAutoButton != null) {
            this.rotationSlabAutoButton.setToggled(slabMode == RotationLockData.SlabMode.AUTO);
        }
        if (this.rotationSlabTopButton != null) {
            this.rotationSlabTopButton.setToggled(slabMode == RotationLockData.SlabMode.TOP);
        }
        if (this.rotationSlabBottomButton != null) {
            this.rotationSlabBottomButton.setToggled(slabMode == RotationLockData.SlabMode.BOTTOM);
        }
        RotationLockData.OpenMode openMode = this.workingRotationConfig.getOpenMode();
        if (this.rotationOpenAutoButton != null) {
            this.rotationOpenAutoButton.setToggled(openMode == RotationLockData.OpenMode.AUTO);
        }
        if (this.rotationOpenOpenButton != null) {
            this.rotationOpenOpenButton.setToggled(openMode == RotationLockData.OpenMode.OPEN);
        }
        if (this.rotationOpenClosedButton != null) {
            this.rotationOpenClosedButton.setToggled(openMode == RotationLockData.OpenMode.CLOSED);
        }
    }

    private void onRotationDirectionToggle(Direction direction, boolean toggled) {
        if (this.workingRotationConfig == null) {
            return;
        }
        this.workingRotationConfig.clearLocks();
        if (toggled) {
            this.workingRotationConfig.setDirectionLock(direction);
        }
        this.updateRotationDirectionButtonStates();
    }

    private void updateRotationDirectionButtonStates() {
        if (this.workingRotationConfig == null) {
            return;
        }
        if (this.rotationNorthButton != null) {
            this.rotationNorthButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.NORTH));
        }
        if (this.rotationSouthButton != null) {
            this.rotationSouthButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.SOUTH));
        }
        if (this.rotationEastButton != null) {
            this.rotationEastButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.EAST));
        }
        if (this.rotationWestButton != null) {
            this.rotationWestButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.WEST));
        }
        if (this.rotationUpButton != null) {
            this.rotationUpButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.UP));
        }
        if (this.rotationDownButton != null) {
            this.rotationDownButton.setToggled(this.workingRotationConfig.isDirectionLocked(Direction.DOWN));
        }
    }

    private void updateRotationButtonPositions() {
        int actionButtonY;
        int dirButtonWidth = 50;
        int dirButtonSpacing = 4;
        int dirRowWidth = dirButtonWidth * 3 + dirButtonSpacing * 2;
        int dirStartX = this.leftPos + (this.imageWidth - dirRowWidth) / 2;
        int dirRow1Y = this.dropdownY + 5;
        int dirRow2Y = dirRow1Y + 20 + 3;
        if (this.rotationUpButton != null) {
            this.rotationUpButton.setX(dirStartX);
            this.rotationUpButton.setY(dirRow1Y);
        }
        if (this.rotationNorthButton != null) {
            this.rotationNorthButton.setX(dirStartX + dirButtonWidth + dirButtonSpacing);
            this.rotationNorthButton.setY(dirRow1Y);
        }
        if (this.rotationDownButton != null) {
            this.rotationDownButton.setX(dirStartX + (dirButtonWidth + dirButtonSpacing) * 2);
            this.rotationDownButton.setY(dirRow1Y);
        }
        if (this.rotationWestButton != null) {
            this.rotationWestButton.setX(dirStartX);
            this.rotationWestButton.setY(dirRow2Y);
        }
        if (this.rotationSouthButton != null) {
            this.rotationSouthButton.setX(dirStartX + dirButtonWidth + dirButtonSpacing);
            this.rotationSouthButton.setY(dirRow2Y);
        }
        if (this.rotationEastButton != null) {
            this.rotationEastButton.setX(dirStartX + (dirButtonWidth + dirButtonSpacing) * 2);
            this.rotationEastButton.setY(dirRow2Y);
        }
        int propButtonWidth = 42;
        int propButtonSpacing = 3;
        int stairPropWidth = propButtonWidth * 4 + propButtonSpacing * 3;
        int otherPropWidth = propButtonWidth * 3 + propButtonSpacing * 2;
        int stairPropStartX = this.leftPos + (this.imageWidth - stairPropWidth) / 2;
        int otherPropStartX = this.leftPos + (this.imageWidth - otherPropWidth) / 2;
        int propY = this.calculatedControlsY + 1;
        if (this.rotationStairAutoButton != null) {
            this.rotationStairAutoButton.setX(stairPropStartX);
            this.rotationStairAutoButton.setY(propY);
        }
        if (this.rotationStairTopButton != null) {
            this.rotationStairTopButton.setX(stairPropStartX + propButtonWidth + propButtonSpacing);
            this.rotationStairTopButton.setY(propY);
        }
        if (this.rotationStairBottomButton != null) {
            this.rotationStairBottomButton.setX(stairPropStartX + (propButtonWidth + propButtonSpacing) * 2);
            this.rotationStairBottomButton.setY(propY);
        }
        if (this.rotationStairLinkButton != null) {
            this.rotationStairLinkButton.setX(stairPropStartX + (propButtonWidth + propButtonSpacing) * 3);
            this.rotationStairLinkButton.setY(propY);
        }
        if (this.rotationSlabAutoButton != null) {
            this.rotationSlabAutoButton.setX(otherPropStartX);
            this.rotationSlabAutoButton.setY(propY);
        }
        if (this.rotationSlabTopButton != null) {
            this.rotationSlabTopButton.setX(otherPropStartX + propButtonWidth + propButtonSpacing);
            this.rotationSlabTopButton.setY(propY);
        }
        if (this.rotationSlabBottomButton != null) {
            this.rotationSlabBottomButton.setX(otherPropStartX + (propButtonWidth + propButtonSpacing) * 2);
            this.rotationSlabBottomButton.setY(propY);
        }
        if (this.rotationOpenAutoButton != null) {
            this.rotationOpenAutoButton.setX(otherPropStartX);
            this.rotationOpenAutoButton.setY(propY);
        }
        if (this.rotationOpenOpenButton != null) {
            this.rotationOpenOpenButton.setX(otherPropStartX + propButtonWidth + propButtonSpacing);
            this.rotationOpenOpenButton.setY(propY);
        }
        if (this.rotationOpenClosedButton != null) {
            this.rotationOpenClosedButton.setX(otherPropStartX + (propButtonWidth + propButtonSpacing) * 2);
            this.rotationOpenClosedButton.setY(propY);
        }
        int actionButtonWidth = 70;
        int actionButtonSpacing = 10;
        int actionTotalWidth = actionButtonWidth * 2 + actionButtonSpacing;
        int actionStartX = this.leftPos + (this.imageWidth - actionTotalWidth) / 2;
        if (this.rotationBlockHasProperties) {
            actionButtonY = this.calculatedGlobalY;
        } else {
            int availableHeight = this.calculatedGlobalY - this.calculatedControlsY + 20;
            actionButtonY = this.calculatedControlsY + (availableHeight - 20) / 2;
        }
        if (this.rotationConfirmButton != null) {
            this.rotationConfirmButton.setX(actionStartX);
            this.rotationConfirmButton.setY(actionButtonY);
        }
        if (this.rotationResetButton != null) {
            this.rotationResetButton.setX(actionStartX + actionButtonWidth + actionButtonSpacing);
            this.rotationResetButton.setY(actionButtonY);
        }
    }

    private void initPaletteControls(int x, int y) {
        int buttonWidth = 60;
        int buttonSpacing = 10;
        int totalButtonWidth = buttonWidth * 2 + buttonSpacing;
        int buttonStartX = x + (this.imageWidth - totalButtonWidth) / 2;
        this.resetButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.reset"), btn -> this.resetPalette()).bounds(buttonStartX, y, buttonWidth, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Reset Palette").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Clear all locks, rotation configs,").withStyle(ChatFormatting.GRAY)).append("\n").append((Component)Component.literal((String)"camos, and distribute evenly").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.equalButton = NoFocusButton.noFocusBuilder((Component)Component.translatable((String)"gui.mechtrowel.equal"), btn -> this.equalDistribution()).bounds(buttonStartX + buttonWidth + buttonSpacing, y, buttonWidth, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Equal Distribution").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Distribute evenly (respects locks)").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.equalButton);
        int undoButtonWidth = 25;
        int undoButtonX = buttonStartX + buttonWidth * 2 + buttonSpacing + 10;
        this.undoButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"\u27f2"), btn -> PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UNDO_WAND, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(undoButtonX, y, undoButtonWidth, 20).tooltip(Tooltip.create((Component)Component.literal((String)"Undo Last Wand Action").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Revert up to the last 3 wand actions").withStyle(ChatFormatting.GRAY)))).build();
        this.addRenderableWidget((GuiEventListener)this.undoButton);
        this.undoButton.visible = this.trowelData.getBuildingMode() == TrowelData.BuildingMode.WAND;
    }

    private void initRenameUI(int x, int buttonsY) {
        int renameBoxWidth = 170;
        this.renameBox = new EditBox(this.font, x + 10, this.dropdownY + 5, renameBoxWidth, 20, (Component)Component.literal((String)"New Name"));
        this.renameBox.setMaxLength(20);
        this.renameBox.setVisible(false);
        this.addRenderableWidget((GuiEventListener)this.renameBox);
        int renameButtonWidth = 70;
        int renameButtonSpacing = 10;
        int renameTotalWidth = renameButtonWidth * 2 + renameButtonSpacing;
        int renameButtonStartX = x + (this.imageWidth - renameTotalWidth) / 2;
        this.confirmRenameButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Confirm ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN)), btn -> this.finishRename()).bounds(renameButtonStartX, buttonsY, renameButtonWidth, 20).build();
        this.confirmRenameButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.confirmRenameButton);
        this.cancelRenameButton = NoFocusButton.noFocusBuilder((Component)Component.literal((String)"Cancel ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2717").withStyle(ChatFormatting.RED)), btn -> this.cancelRename()).bounds(renameButtonStartX + renameButtonWidth + renameButtonSpacing, buttonsY, renameButtonWidth, 20).build();
        this.cancelRenameButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.cancelRenameButton);
    }

    private void initGlobalSettings(int x, int y) {
        int startX;
        int toggleWidth = 52;
        int featureWidth = 52;
        int buttonSpacing = 3;
        boolean showReplace = MechTrowel.Config.isReplaceModeEnabled();
        int buttonCount = showReplace ? 2 : 1;
        int toggleCount = showReplace ? 1 : 0;
        int featureCount = 1;
        int totalWidth = toggleWidth * toggleCount + featureWidth * featureCount + buttonSpacing * (buttonCount - 1);
        int currentX = startX = x + (this.imageWidth - totalWidth) / 2;
        if (showReplace) {
            this.replaceToggle = new StyledToggleButton(currentX, y, toggleWidth, 20, (Component)Component.literal((String)"Replace"), this.trowelData.isReplaceMode(), value -> {
                this.trowelData.setReplaceMode((boolean)value);
                this.sendSettingsUpdate();
            });
            this.replaceToggle.setTooltip(Tooltip.create((Component)Component.literal((String)"Replace Mode").withStyle(ChatFormatting.WHITE).append("\n").append((Component)Component.literal((String)"Replace existing blocks when placing").withStyle(ChatFormatting.GRAY))));
            this.addRenderableWidget((GuiEventListener)this.replaceToggle);
            currentX += toggleWidth + buttonSpacing;
        }
        boolean hasGradientActive = !this.trowelData.getGradientData().getSections().isEmpty() && this.trowelData.isGradientEnabled();
        this.gradientButton = new StyledToggleButton(currentX, y, featureWidth, 20, (Component)Component.literal((String)"Gradient"), hasGradientActive, value -> this.openGradientScreen()){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.visible && this.active && this.isMouseOver(mouseX, mouseY)) {
                    if (button == 1) {
                        if (!PaletteScreen.this.trowelData.getGradientData().getSections().isEmpty()) {
                            boolean newState = !PaletteScreen.this.trowelData.isGradientEnabled();
                            PaletteScreen.this.trowelData.setGradientEnabled(newState);
                            this.setToggled(newState);
                            PaletteScreen.this.sendSettingsUpdate();
                            PaletteScreen.this.updateGradientButtonTooltip();
                            this.playDownSound(PaletteScreen.this.minecraft.getSoundManager());
                            return true;
                        }
                    } else if (button == 0) {
                        this.playDownSound(PaletteScreen.this.minecraft.getSoundManager());
                        PaletteScreen.this.openGradientScreen();
                        return true;
                    }
                }
                return false;
            }
        };
        this.updateGradientButtonTooltip();
        this.addRenderableWidget((GuiEventListener)this.gradientButton);
    }

    private void updateUI() {
        boolean hideBottomSection;
        int rotBtnY;
        int availableHeight;
        int rotBtnX;
        int rotBtnWidth;
        boolean normalState;
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime < 50L) {
            return;
        }
        this.lastUpdateTime = currentTime;
        this.isUpdatingUI = true;
        if (this.paletteSelector != null) {
            if (!this.paletteSelector.isOpen()) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < this.trowelData.getPalettes().size(); ++i) {
                    indices.add(i);
                }
                this.paletteSelector.updateOptions(indices, this.currentPaletteIndex);
            }
            this.paletteSelector.setIconProvider(idx -> {
                if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                    return this.trowelData.getPalettes().get((int)idx).getIconBlock();
                }
                return null;
            });
        }
        this.paletteSelector.visible = normalState = !this.isRenaming && !this.isDeleting && !this.isConfiguringCopycat && !this.isConfiguringFramed && !this.isConfiguringRotation;
        this.createButton.visible = normalState;
        this.renameButton.visible = normalState;
        this.deleteButton.visible = normalState;
        this.renameBox.visible = this.isRenaming;
        this.confirmRenameButton.visible = this.isRenaming;
        this.cancelRenameButton.visible = this.isRenaming;
        this.confirmDeleteButton.visible = this.isDeleting;
        this.cancelDeleteButton.visible = this.isDeleting;
        this.copycatLitButton.visible = this.isConfiguringCopycat;
        this.copycatAxisButton.visible = this.isConfiguringCopycat;
        if (this.copycatRotationButton != null) {
            this.copycatRotationButton.visible = this.isConfiguringCopycat;
            rotBtnWidth = 70;
            rotBtnX = this.leftPos + (this.imageWidth - rotBtnWidth) / 2;
            availableHeight = this.calculatedGlobalY - this.calculatedControlsY + 20;
            rotBtnY = this.calculatedControlsY + (availableHeight - 20) / 2;
            this.copycatRotationButton.setX(rotBtnX);
            this.copycatRotationButton.setY(rotBtnY);
        }
        if (this.framedRotationButton != null) {
            this.framedRotationButton.visible = this.isConfiguringFramed;
            rotBtnWidth = 70;
            rotBtnX = this.leftPos + (this.imageWidth - rotBtnWidth) / 2;
            availableHeight = this.calculatedGlobalY - this.calculatedControlsY + 20;
            rotBtnY = this.calculatedControlsY + (availableHeight - 20) / 2;
            this.framedRotationButton.setX(rotBtnX);
            this.framedRotationButton.setY(rotBtnY);
        }
        if (!this.renderables.isEmpty()) {
            for (Renderable widget : this.renderables) {
                Button btn;
                if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("Confirm") || !btn.getMessage().getString().contains("\u2713") || btn == this.confirmRenameButton || btn == this.confirmDeleteButton || btn == this.rotationConfirmButton) continue;
                btn.visible = this.isConfiguringCopycat || this.isConfiguringFramed;
            }
        }
        if (this.rotationNorthButton != null) {
            this.rotationNorthButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationSouthButton != null) {
            this.rotationSouthButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationEastButton != null) {
            this.rotationEastButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationWestButton != null) {
            this.rotationWestButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationUpButton != null) {
            this.rotationUpButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationDownButton != null) {
            this.rotationDownButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationConfirmButton != null) {
            this.rotationConfirmButton.visible = this.isConfiguringRotation;
        }
        if (this.rotationResetButton != null) {
            this.rotationResetButton.visible = this.isConfiguringRotation;
        }
        boolean bl = hideBottomSection = this.isConfiguringRotation || this.isConfiguringCopycat || this.isConfiguringFramed;
        if (this.resetButton != null) {
            boolean bl2 = this.resetButton.visible = !hideBottomSection;
        }
        if (this.equalButton != null) {
            boolean bl3 = this.equalButton.visible = !hideBottomSection;
        }
        if (this.undoButton != null && hideBottomSection) {
            this.undoButton.visible = false;
        }
        if (this.replaceToggle != null) {
            boolean bl4 = this.replaceToggle.visible = !hideBottomSection;
        }
        if (this.gradientButton != null) {
            this.gradientButton.visible = !hideBottomSection;
        }
        this.createButton.active = this.trowelData.getPalettes().size() < MechTrowel.Config.getMaxPalettes();
        this.deleteButton.active = this.trowelData.getPalettes().size() > 1;
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        for (int i = 0; i < this.percentageBars.size(); ++i) {
            boolean hasBlock;
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean bl5 = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            if (hasBlock && this.currentPalette != null) {
                PaletteData.WeightedBlock paletteBlock = null;
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
                if (paletteBlock != null) {
                    this.percentageBars.get(i).setVisible(true);
                    this.percentageBars.get((int)i).active = true;
                    int percentage = Math.round(paletteBlock.getWeight());
                    this.percentageBars.get(i).setPercentage(percentage);
                    this.percentageBars.get(i).setLocked(paletteBlock.isLocked());
                    this.lockButtons.get(i).setLocked(paletteBlock.isLocked());
                    this.lockButtons.get((int)i).visible = true;
                    continue;
                }
                int existingBlockCount = this.currentPalette.getBlocks().size();
                int tempPercentage = existingBlockCount > 0 ? 100 / (existingBlockCount + 1) : 100;
                this.percentageBars.get(i).setVisible(true);
                this.percentageBars.get((int)i).active = true;
                this.percentageBars.get(i).setPercentage(tempPercentage);
                this.percentageBars.get(i).setLocked(false);
                this.lockButtons.get(i).setLocked(false);
                this.lockButtons.get((int)i).visible = true;
                continue;
            }
            this.percentageBars.get(i).setPercentage(0);
            this.percentageBars.get(i).setVisible(false);
            this.percentageBars.get((int)i).active = false;
            this.lockButtons.get((int)i).visible = false;
        }
        if (this.replaceToggle != null && !this.isConfiguringRotation) {
            this.replaceToggle.setToggled(this.trowelData.isReplaceMode());
        }
        if (this.gradientButton != null && !this.isConfiguringRotation) {
            this.gradientButton.setToggled(!this.trowelData.getGradientData().getSections().isEmpty() && this.trowelData.isGradientEnabled());
            this.updateGradientButtonTooltip();
        }
        if (this.undoButton != null && !this.isConfiguringRotation) {
            boolean shouldShowUndo;
            this.undoButton.visible = shouldShowUndo = this.trowelData.getBuildingMode() == TrowelData.BuildingMode.WAND;
        }
        this.isUpdatingUI = false;
    }

    private void onPercentageChanged(int slot, int newPercentage) {
        boolean isTextInputChange = false;
        if (slot < this.percentageBars.size()) {
            isTextInputChange = this.percentageBars.get(slot).isInTextInputMode();
        }
        if (this.currentPalette == null || this.isUpdatingUI && !isTextInputChange) {
            return;
        }
        PaletteData.WeightedBlock targetBlock = null;
        int paletteIndex = -1;
        for (int i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
            if (this.currentPalette.getBlocks().get(i).getSlotPosition() != slot) continue;
            targetBlock = this.currentPalette.getBlocks().get(i);
            paletteIndex = i;
            break;
        }
        if (targetBlock == null || paletteIndex == -1) {
            return;
        }
        newPercentage = Math.max(1, Math.min(100, newPercentage));
        int oldPercentage = Math.round(targetBlock.getWeight());
        if (oldPercentage != newPercentage) {
            PaletteBalancer.handlePercentageChange(this.currentPalette, paletteIndex, oldPercentage, newPercentage);
            if (!this.isUpdatingUI) {
                for (int i = 0; i < this.percentageBars.size(); ++i) {
                    boolean hasBlock;
                    if (i == slot) continue;
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                    boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                    if (!hasBlock || this.currentPalette == null) continue;
                    PaletteData.WeightedBlock paletteBlock = null;
                    for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                        if (block.getSlotPosition() != i) continue;
                        paletteBlock = block;
                        break;
                    }
                    if (paletteBlock == null) continue;
                    int balancedPercentage = Math.round(paletteBlock.getWeight());
                    this.percentageBars.get(i).setPercentage(balancedPercentage);
                }
            }
            this.savePalette();
        }
    }

    private void onLockToggled(int slot, boolean locked) {
        if (this.currentPalette == null || this.isUpdatingUI) {
            return;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock targetBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            targetBlock = block;
            break;
        }
        if (targetBlock == null) {
            return;
        }
        targetBlock.setLocked(locked);
        if (slot < this.lockButtons.size()) {
            this.lockButtons.get(slot).setLocked(locked);
        }
        if (slot < this.percentageBars.size()) {
            this.percentageBars.get(slot).setLocked(locked);
        }
        this.savePalette();
    }

    private void checkAndBalance() {
        if (this.currentPalette == null) {
            return;
        }
        if (!PaletteBalancer.isBalanced(this.currentPalette)) {
            PaletteBalancer.autoBalance(this.currentPalette);
            this.updateUI();
        }
    }

    private void createNewPalette() {
        if (this.trowelData.getPalettes().size() < MechTrowel.Config.getMaxPalettes()) {
            CompoundTag nameTag = new CompoundTag();
            nameTag.putString("name", "Palette " + (this.trowelData.getPalettes().size() + 1));
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.CREATE_PALETTE, 0, nameTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void startRename() {
        this.isRenaming = true;
        this.isDeleting = false;
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        this.renameBox.setValue(this.currentPalette.getName());
        this.renameBox.setFocused(true);
        this.renameBox.setHighlightPos(0);
        this.renameBox.setCursorPosition(this.renameBox.getValue().length());
        if (this.currentPalette.getIconBlock() != null) {
            this.selectedIconBlock = this.currentPalette.getIconBlock();
            ItemStack iconStack = new ItemStack((ItemLike)this.selectedIconBlock.getBlock());
            this.iconContainer.setItem(0, iconStack);
        } else {
            this.selectedIconBlock = null;
            this.iconContainer.setItem(0, ItemStack.EMPTY);
        }
        this.updateUI();
    }

    private void finishRename() {
        if (this.isRenaming && this.currentPalette != null) {
            boolean iconChanged;
            Object newName = this.renameBox.getValue().trim();
            if (((String)newName).isEmpty()) {
                newName = "Palette " + (this.currentPaletteIndex + 1);
            }
            this.isRenaming = false;
            boolean nameChanged = !((String)newName).equals(this.currentPalette.getName());
            boolean bl = iconChanged = this.selectedIconBlock != null && !this.selectedIconBlock.equals(this.currentPalette.getIconBlock()) || this.selectedIconBlock == null && this.currentPalette.getIconBlock() != null;
            if (nameChanged || iconChanged) {
                CompoundTag nameTag = new CompoundTag();
                nameTag.putString("name", (String)newName);
                if (this.selectedIconBlock != null) {
                    nameTag.put("iconBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.selectedIconBlock));
                } else if (this.currentPalette.getIconBlock() != null && this.selectedIconBlock == null) {
                    nameTag.putBoolean("clearIcon", true);
                }
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.RENAME_PALETTE, this.currentPaletteIndex, nameTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.selectedIconBlock = null;
            this.iconContainer.setItem(0, ItemStack.EMPTY);
            this.updateUI();
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
    }

    private void cancelRename() {
        this.isRenaming = false;
        this.selectedIconBlock = null;
        this.iconContainer.setItem(0, ItemStack.EMPTY);
        this.updateUI();
        if (this.paletteSelector != null) {
            this.paletteSelector.refreshDisplay();
        }
    }

    private void startDelete() {
        if (this.trowelData.getPalettes().size() > 1) {
            this.isDeleting = true;
            this.isRenaming = false;
            if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
                this.paletteSelector.close();
            }
            this.updateUI();
        }
    }

    private void confirmDelete() {
        if (this.trowelData.getPalettes().size() > 1 && this.isDeleting) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.DELETE_PALETTE, this.currentPaletteIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.isDeleting = false;
        }
    }

    private void cancelDelete() {
        this.isDeleting = false;
        this.updateUI();
    }

    private void resetPalette() {
        if (this.currentPalette == null || this.currentPalette.isEmpty()) {
            return;
        }
        if (this.resetButton != null) {
            this.resetButton.active = false;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette != null && !this.currentPalette.isEmpty()) {
            int i;
            for (i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
                PaletteData.WeightedBlock block = this.currentPalette.getBlocks().get(i);
                this.currentPalette.setLocked(i, false);
                block.setSlotPosition(i);
                block.setRotationConfig(null);
                block.setCopycatConfig(null);
                block.setFramedConfig(null);
            }
            PaletteBalancer.equalDistribution(this.currentPalette);
            ((PaletteMenu)this.menu).syncContainerWithPalette();
            for (i = 0; i < this.currentPalette.getBlocks().size(); ++i) {
                int slot = this.currentPalette.getBlocks().get(i).getSlotPosition();
                if (slot < this.percentageBars.size()) {
                    this.percentageBars.get(slot).setLocked(false);
                    this.percentageBars.get(slot).setPercentage(Math.round(this.currentPalette.getBlocks().get(i).getWeight()));
                }
                if (slot >= this.lockButtons.size()) continue;
                this.lockButtons.get(slot).setLocked(false);
            }
            this.savePalette();
            if (this.resetButton != null) {
                this.resetButton.active = true;
            }
        }
    }

    private void equalDistribution() {
        if (this.currentPalette == null || this.currentPalette.isEmpty()) {
            return;
        }
        if (this.equalButton != null) {
            this.equalButton.active = false;
        }
        this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
        this.currentPalette = this.trowelData.getActivePalette();
        if (this.currentPalette != null && !this.currentPalette.isEmpty()) {
            PaletteBalancer.equalDistribution(this.currentPalette, true);
            this.updateUI();
            this.savePalette();
            if (this.equalButton != null) {
                this.equalButton.active = true;
            }
        }
    }

    private void savePalette() {
        if (this.currentPalette != null) {
            TrowelData freshTrowelData = ((PaletteMenu)this.menu).getTrowelData();
            if (this.currentPaletteIndex < freshTrowelData.getPalettes().size()) {
                PaletteData containerPalette = freshTrowelData.getPalettes().get(this.currentPaletteIndex);
                for (int i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                    if (containerItem.isEmpty() || !(containerItem.getItem() instanceof BlockItem)) continue;
                    for (PaletteData.WeightedBlock block : containerPalette.getBlocks()) {
                        if (block.getSlotPosition() == i) break;
                    }
                }
                freshTrowelData.getPalettes().set(this.currentPaletteIndex, this.currentPalette);
            }
            freshTrowelData.save(((PaletteMenu)this.menu).getTrowelStack());
            ((PaletteMenu)this.menu).broadcastChanges();
            CompoundTag paletteTag = new CompoundTag();
            this.currentPalette.save(paletteTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_PALETTE, this.currentPaletteIndex, paletteTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendSettingsUpdate() {
        CompoundTag settingsTag = new CompoundTag();
        this.trowelData.save(settingsTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_SETTINGS, 0, settingsTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void openGradientScreen() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.OPEN_GRADIENT_GUI, 0, null), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private boolean hasActiveRotationSettings() {
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        if (!rotationData.getLockedFaces().isEmpty()) {
            return true;
        }
        if (rotationData.getStairMode() != RotationLockData.StairMode.AUTO) {
            return true;
        }
        if (rotationData.getSlabMode() != RotationLockData.SlabMode.AUTO) {
            return true;
        }
        return !rotationData.isStairLink();
    }

    private void updateGradientButtonTooltip() {
        boolean hasGradientConfigured;
        if (this.gradientButton == null) {
            return;
        }
        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
        tooltipLines.add(Component.literal((String)"Gradient Settings").withStyle(ChatFormatting.WHITE));
        boolean bl = hasGradientConfigured = !this.trowelData.getGradientData().getSections().isEmpty();
        if (hasGradientConfigured) {
            if (this.trowelData.isGradientEnabled()) {
                tooltipLines.add(Component.literal((String)"Active").withStyle(ChatFormatting.GREEN));
            } else {
                tooltipLines.add(Component.literal((String)"Disabled").withStyle(ChatFormatting.RED));
            }
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.literal((String)"Left-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Configure settings").withStyle(ChatFormatting.GRAY)));
            tooltipLines.add(Component.literal((String)"Right-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Toggle on/off").withStyle(ChatFormatting.GRAY)));
        } else {
            tooltipLines.add(Component.literal((String)"Not configured").withStyle(ChatFormatting.GRAY));
            tooltipLines.add(Component.empty());
            tooltipLines.add(Component.literal((String)"Left-click: ").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)"Configure settings").withStyle(ChatFormatting.GRAY)));
        }
        if (tooltipLines.size() > 1) {
            Component combinedTooltip = (Component)tooltipLines.get(0);
            for (int i = 1; i < tooltipLines.size(); ++i) {
                combinedTooltip = Component.empty().append(combinedTooltip).append("\n").append((Component)tooltipLines.get(i));
            }
            this.gradientButton.setTooltip(Tooltip.create((Component)combinedTooltip));
        } else if (!tooltipLines.isEmpty()) {
            this.gradientButton.setTooltip(Tooltip.create((Component)((Component)tooltipLines.get(0))));
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int bgX = this.leftPos + (this.imageWidth - 230) / 2;
        if (this.visibleRows <= 2) {
            graphics.blit(PALETTE_TEXTURE_SMALL, bgX, this.topPos, 0.0f, 0.0f, 230, 172, 230, 172);
        } else {
            graphics.blit(PALETTE_TEXTURE, bgX, this.topPos, 0.0f, 0.0f, 230, 240, 230, 240);
        }
        int rowTexX = this.leftPos + (this.imageWidth - 203) / 2;
        int rowsToDraw = Math.min(this.visibleRows, ((PaletteMenu)this.menu).paletteRows - this.scrollOffset);
        for (int row = 0; row < rowsToDraw; ++row) {
            int rowY = this.calculatedGridY + row * 34;
            graphics.blit(PALETTE_ROW_TEXTURE, rowTexX, rowY, 0.0f, 0.0f, 203, 34, 203, 34);
        }
        int invTexX = this.leftPos + (this.imageWidth - 176) / 2;
        graphics.blit(INVENTORY_TEXTURE, invTexX, this.calculatedInventoryY, 0.0f, 0.0f, 176, 100, 176, 100);
        if (this.isConfiguringRotation) {
            this.renderRotationConfigBackgrounds(graphics);
        }
    }

    private void drawSlot(GuiGraphics graphics, int x, int y) {
        graphics.fill(x, y, x + 18, y + 1, -13158601);
        graphics.fill(x, y, x + 1, y + 18, -13158601);
        graphics.fill(x + 1, y + 17, x + 18, y + 18, -1);
        graphics.fill(x + 17, y + 1, x + 18, y + 18, -1);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        int invLabelX = (this.imageWidth - 176) / 2 + 8;
        int invLabelY = this.calculatedInventoryY - this.topPos + 6;
        graphics.drawString(this.font, this.playerInventoryTitle, invLabelX, invLabelY, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return;
        }
        super.renderTooltip(graphics, mouseX, mouseY);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int slotY;
        int maxTextWidth;
        int boxX;
        int boxHeight;
        int boxWidth;
        int boxWidth2;
        int boxY;
        int boxX2;
        int slotY2;
        int slotX;
        int remainingSpace;
        this.renderBackground(graphics, mouseX, mouseY, partialTick);
        this.applyScrollToWidgets();
        super.render(graphics, mouseX, mouseY, partialTick);
        int x = this.leftPos;
        int y = this.topPos;
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 36;
        int startX = x + (this.imageWidth - totalWidth) / 2;
        int gridY = this.calculatedGridY;
        if (this.canScroll) {
            int scissorLeft = startX - 5;
            int scissorRight = startX + totalWidth + 5;
            int scissorTop = gridY - 2;
            int scissorBottom = gridY + this.visibleRows * 34;
            graphics.enableScissor(scissorLeft, scissorTop, scissorRight, scissorBottom);
        }
        if (this.canScroll) {
            graphics.disableScissor();
        }
        if (this.canScroll) {
            this.drawScrollBar(graphics, mouseX, mouseY);
        }
        if (this.createButton.isHoveredOrFocused() && !this.createButton.active) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)("Maximum palettes reached (" + MechTrowel.Config.getMaxPalettes() + ")")), mouseX, mouseY);
        }
        if (this.deleteButton.isHoveredOrFocused() && !this.deleteButton.active) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)"Cannot delete the last palette"), mouseX, mouseY);
        }
        if (this.isRenaming) {
            remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            slotX = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            slotY2 = this.renameBox.getY() + 1;
            this.drawSlot(graphics, slotX - 1, slotY2 - 1);
            if (!this.iconContainer.getItem(0).isEmpty()) {
                graphics.renderItem(this.iconContainer.getItem(0), slotX, slotY2);
            }
        }
        if (this.isDeleting && this.currentPalette != null) {
            boxX2 = this.paletteSelector.getX();
            boxY = this.paletteSelector.getY();
            boxWidth2 = 210;
            int boxHeight2 = this.paletteSelector.getHeight();
            graphics.fill(boxX2, boxY, boxX2 + boxWidth2, boxY + boxHeight2, -12829636);
            graphics.fill(boxX2, boxY, boxX2 + boxWidth2, boxY + 1, -14803426);
            graphics.fill(boxX2, boxY, boxX2 + 1, boxY + boxHeight2, -14803426);
            graphics.fill(boxX2 + 1, boxY + boxHeight2 - 1, boxX2 + boxWidth2, boxY + boxHeight2, -10855846);
            graphics.fill(boxX2 + boxWidth2 - 1, boxY + 1, boxX2 + boxWidth2, boxY + boxHeight2, -10855846);
            graphics.fill(boxX2 + 1, boxY + 1, boxX2 + boxWidth2 - 1, boxY + boxHeight2 - 1, 0x20FF0000);
            MutableComponent deleteText = Component.literal((String)"DELETE \"").withStyle(ChatFormatting.RED);
            int textX = boxX2 + 5;
            int textY = boxY + 6;
            if (this.currentPalette.getIconBlock() != null) {
                graphics.drawString(this.font, (Component)deleteText, textX, textY, 0xFFFFFF, false);
                ItemStack iconStack = new ItemStack((ItemLike)this.currentPalette.getIconBlock().getBlock());
                graphics.pose().pushPose();
                graphics.pose().translate((float)(textX += this.font.width((FormattedText)deleteText)), (float)(boxY + 2), 0.0f);
                graphics.pose().scale(0.75f, 0.75f, 0.75f);
                graphics.renderItem(iconStack, 0, 0);
                graphics.pose().popPose();
                MutableComponent nameAndQuote = Component.literal((String)this.currentPalette.getName()).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\"?").withStyle(ChatFormatting.RED));
                graphics.drawString(this.font, (Component)nameAndQuote, textX += 14, textY, 0xFFFFFF, false);
            } else {
                MutableComponent fullMessage = deleteText.append((Component)Component.literal((String)this.currentPalette.getName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"\"?").withStyle(ChatFormatting.RED));
                graphics.drawString(this.font, (Component)fullMessage, textX, textY, 0xFFFFFF, false);
            }
        }
        if (this.isRenaming) {
            remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            slotX = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            slotY2 = this.renameBox.getY() + 1;
            if (mouseX >= slotX - 1 && mouseX < slotX + 17 && mouseY >= slotY2 - 1 && mouseY < slotY2 + 17) {
                ArrayList<Object> tooltip = new ArrayList<Object>();
                if (this.iconContainer.getItem(0).isEmpty()) {
                    tooltip.add(Component.literal((String)"Click to set icon"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(this.iconContainer.getItem(0).getHoverName());
                    tooltip.add(Component.literal((String)"Right-click to remove").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringCopycat) {
            boxX2 = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth2 = 183;
            int slotX2 = boxX2 + boxWidth2 + 10;
            int slotY3 = boxY + 1;
            if (mouseX >= slotX2 - 1 && mouseX < slotX2 + 17 && mouseY >= slotY3 - 1 && mouseY < slotY3 + 17) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (this.workingCopycatConfig == null || this.workingCopycatConfig.getMaterial() == null) {
                    tooltip.add(Component.literal((String)"Click to set material"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Component.literal((String)this.workingCopycatConfig.getMaterial().getBlock().getName().getString()));
                    tooltip.add(Component.literal((String)"Click another block to change").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringCopycat) {
            MutableComponent materialText;
            boxWidth = 183;
            boxHeight = 20;
            boxX = this.leftPos + 10;
            int boxY2 = this.dropdownY + 5;
            graphics.fill(boxX, boxY2, boxX + boxWidth, boxY2 + boxHeight, -12829636);
            graphics.fill(boxX, boxY2, boxX + boxWidth, boxY2 + 1, -14803426);
            graphics.fill(boxX, boxY2, boxX + 1, boxY2 + boxHeight, -14803426);
            graphics.fill(boxX + 1, boxY2 + boxHeight - 1, boxX + boxWidth, boxY2 + boxHeight, -10855846);
            graphics.fill(boxX + boxWidth - 1, boxY2 + 1, boxX + boxWidth, boxY2 + boxHeight, -10855846);
            if (this.workingCopycatConfig != null && this.workingCopycatConfig.getMaterial() != null) {
                Object blockName = this.workingCopycatConfig.getMaterial().getBlock().getName().getString();
                maxTextWidth = boxWidth - 85;
                if (this.font.width((String)blockName) > maxTextWidth) {
                    while (this.font.width((String)blockName + "...") > maxTextWidth && ((String)blockName).length() > 0) {
                        blockName = ((String)blockName).substring(0, ((String)blockName).length() - 1);
                    }
                    blockName = (String)blockName + "...";
                }
                materialText = Component.literal((String)"Select Material: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)blockName).withStyle(ChatFormatting.WHITE));
            } else {
                materialText = Component.literal((String)"Select Material: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None").withStyle(ChatFormatting.DARK_GRAY));
            }
            graphics.drawString(this.font, (Component)materialText, boxX + 5, boxY2 + 6, 0xFFFFFF, false);
            int slotX3 = boxX + boxWidth + 10;
            slotY = boxY2 + 1;
            this.drawSlot(graphics, slotX3 - 1, slotY - 1);
            if (this.workingCopycatConfig != null && this.workingCopycatConfig.getMaterial() != null) {
                ItemStack materialStack = new ItemStack((ItemLike)this.workingCopycatConfig.getMaterial().getBlock());
                graphics.renderItem(materialStack, slotX3, slotY);
            }
        }
        if (this.isConfiguringFramed) {
            boxX2 = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth2 = 183;
            int slotX4 = boxX2 + boxWidth2 + 10;
            int slotY4 = boxY + 1;
            if (mouseX >= slotX4 - 1 && mouseX < slotX4 + 17 && mouseY >= slotY4 - 1 && mouseY < slotY4 + 17) {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                if (this.workingFramedConfig == null || this.workingFramedConfig.getCamo() == null) {
                    tooltip.add(Component.literal((String)"Click to set camo"));
                    tooltip.add(Component.literal((String)"Left-click any block").withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Component.literal((String)this.workingFramedConfig.getCamo().getBlock().getName().getString()));
                    tooltip.add(Component.literal((String)"Click another block to change").withStyle(ChatFormatting.GRAY));
                }
                graphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
        if (this.isConfiguringFramed) {
            MutableComponent camoText;
            boxWidth = 183;
            boxHeight = 20;
            boxX = this.leftPos + 10;
            int boxY3 = this.dropdownY + 5;
            graphics.fill(boxX, boxY3, boxX + boxWidth, boxY3 + boxHeight, -12829636);
            graphics.fill(boxX, boxY3, boxX + boxWidth, boxY3 + 1, -14803426);
            graphics.fill(boxX, boxY3, boxX + 1, boxY3 + boxHeight, -14803426);
            graphics.fill(boxX + 1, boxY3 + boxHeight - 1, boxX + boxWidth, boxY3 + boxHeight, -10855846);
            graphics.fill(boxX + boxWidth - 1, boxY3 + 1, boxX + boxWidth, boxY3 + boxHeight, -10855846);
            if (this.workingFramedConfig != null && this.workingFramedConfig.getCamo() != null) {
                Object blockName = this.workingFramedConfig.getCamo().getBlock().getName().getString();
                maxTextWidth = boxWidth - 85;
                if (this.font.width((String)blockName) > maxTextWidth) {
                    while (this.font.width((String)blockName + "...") > maxTextWidth && ((String)blockName).length() > 0) {
                        blockName = ((String)blockName).substring(0, ((String)blockName).length() - 1);
                    }
                    blockName = (String)blockName + "...";
                }
                camoText = Component.literal((String)"Select Camo: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)blockName).withStyle(ChatFormatting.WHITE));
            } else {
                camoText = Component.literal((String)"Select Camo: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None").withStyle(ChatFormatting.DARK_GRAY));
            }
            graphics.drawString(this.font, (Component)camoText, boxX + 5, boxY3 + 6, 0xFFFFFF, false);
            int slotX5 = boxX + boxWidth + 10;
            slotY = boxY3 + 1;
            this.drawSlot(graphics, slotX5 - 1, slotY - 1);
            if (this.workingFramedConfig != null && this.workingFramedConfig.getCamo() != null) {
                ItemStack camoStack = new ItemStack((ItemLike)this.workingFramedConfig.getCamo().getBlock());
                graphics.renderItem(camoStack, slotX5, slotY);
            }
        }
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.paletteSelector != null) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 300.0f);
            this.paletteSelector.renderDropdownOverlay(graphics, mouseX, mouseY);
            graphics.pose().popPose();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (InteractivePercentageBar bar : this.percentageBars) {
            if (!bar.isInTextInputMode()) continue;
            if (keyCode == 257) {
                bar.keyPressed(keyCode, scanCode, modifiers);
                return true;
            }
            if (keyCode == 256) {
                bar.keyPressed(keyCode, scanCode, modifiers);
                return true;
            }
            bar.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        if (this.isRenaming) {
            if (keyCode == 257) {
                this.finishRename();
                return true;
            }
            if (keyCode == 256) {
                this.cancelRename();
                return true;
            }
            this.renameBox.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        if (this.isDeleting) {
            if (keyCode == 256) {
                this.cancelDelete();
                return true;
            }
            return true;
        }
        if (this.isConfiguringCopycat) {
            if (keyCode == 256) {
                this.finishCopycatConfig();
                return true;
            }
            return true;
        }
        if (this.isConfiguringFramed) {
            if (keyCode == 256) {
                this.finishFramedConfig();
                return true;
            }
            return true;
        }
        if (this.isConfiguringRotation && (keyCode == 256 || this.minecraft.options.keyInventory.matches(keyCode, scanCode))) {
            this.finishRotationConfig();
            if (keyCode == 256) {
                return true;
            }
        }
        if (keyCode == 256 && this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        for (InteractivePercentageBar bar : this.percentageBars) {
            if (!bar.isInTextInputMode()) continue;
            bar.charTyped(codePoint, modifiers);
            return true;
        }
        if (this.isRenaming) {
            this.renameBox.charTyped(codePoint, modifiers);
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    protected void containerTick() {
        BlockItem blockItem;
        Item item;
        ItemStack slotItem;
        int i;
        super.containerTick();
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return;
        }
        TrowelData latestData = ((PaletteMenu)this.menu).getTrowelData();
        boolean dataChanged = false;
        if (this.trowelData.getPalettes().size() != latestData.getPalettes().size()) {
            dataChanged = true;
        }
        if (this.trowelData.getActivePaletteIndex() != latestData.getActivePaletteIndex()) {
            dataChanged = true;
        }
        if (this.currentPalette != null && this.currentPaletteIndex < latestData.getPalettes().size()) {
            boolean iconChanged;
            PaletteData latestPalette = latestData.getPalettes().get(this.currentPaletteIndex);
            if (!this.currentPalette.getName().equals(latestPalette.getName())) {
                dataChanged = true;
            }
            boolean bl = iconChanged = this.currentPalette.getIconBlock() == null && latestPalette.getIconBlock() != null || this.currentPalette.getIconBlock() != null && latestPalette.getIconBlock() == null || this.currentPalette.getIconBlock() != null && latestPalette.getIconBlock() != null && !this.currentPalette.getIconBlock().equals(latestPalette.getIconBlock());
            if (iconChanged) {
                dataChanged = true;
            }
            if (this.currentPalette.getBlocks().size() != latestPalette.getBlocks().size()) {
                dataChanged = true;
            }
            for (i = 0; i < latestPalette.getBlocks().size(); ++i) {
                if (i >= this.currentPalette.getBlocks().size()) continue;
                PaletteData.WeightedBlock currentBlock = this.currentPalette.getBlocks().get(i);
                PaletteData.WeightedBlock latestBlock = latestPalette.getBlocks().get(i);
                if (currentBlock.getSlotPosition() == latestBlock.getSlotPosition() && !(Math.abs(currentBlock.getWeight() - latestBlock.getWeight()) > 0.1f)) continue;
                dataChanged = true;
                break;
            }
        }
        if (dataChanged) {
            this.trowelData = latestData;
            this.currentPaletteIndex = this.trowelData.getActivePaletteIndex();
            this.currentPalette = this.trowelData.getActivePalette();
            if (this.isRenaming) {
                this.isRenaming = false;
            }
            if (this.isDeleting) {
                this.isDeleting = false;
            }
            if (this.isConfiguringCopycat) {
                this.isConfiguringCopycat = false;
                this.copycatConfigSlot = -1;
                this.workingCopycatConfig = null;
            }
            if (this.paletteSelector == null || !this.paletteSelector.isOpen()) {
                this.updateUI();
            } else {
                this.paletteSelector.setIconProvider(idx -> {
                    if (idx >= 0 && idx < this.trowelData.getPalettes().size()) {
                        return this.trowelData.getPalettes().get((int)idx).getIconBlock();
                    }
                    return null;
                });
            }
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
        boolean containerChanged = false;
        if (this.currentPalette != null) {
            ItemStack containerItem;
            int containerBlockCount = 0;
            for (i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                if (containerItem.isEmpty() || !(containerItem.getItem() instanceof BlockItem)) continue;
                ++containerBlockCount;
            }
            if (containerBlockCount != this.currentPalette.getBlocks().size()) {
                containerChanged = true;
                this.trowelData = latestData;
                this.currentPalette = this.trowelData.getActivePalette();
            }
            for (i = 0; i < ((PaletteMenu)this.menu).paletteSlots; ++i) {
                boolean barVisible;
                containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
                boolean hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                if (hasBlock == (barVisible = this.percentageBars.get((int)i).visible)) continue;
                containerChanged = true;
                break;
            }
        }
        if (containerChanged || dataChanged) {
            this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
            this.currentPalette = this.trowelData.getActivePalette();
            if (this.paletteSelector == null || !this.paletteSelector.isOpen()) {
                this.updateUI();
            } else {
                for (int i2 = 0; i2 < this.percentageBars.size(); ++i2) {
                    boolean hasBlock;
                    ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i2);
                    boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
                    if (hasBlock && this.currentPalette != null) {
                        PaletteData.WeightedBlock paletteBlock = null;
                        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                            if (block.getSlotPosition() != i2) continue;
                            paletteBlock = block;
                            break;
                        }
                        if (paletteBlock != null) {
                            this.percentageBars.get(i2).setVisible(true);
                            this.percentageBars.get((int)i2).active = true;
                            this.percentageBars.get(i2).setPercentage(Math.round(paletteBlock.getWeight()));
                            this.percentageBars.get(i2).setLocked(paletteBlock.isLocked());
                            this.lockButtons.get(i2).setLocked(paletteBlock.isLocked());
                            this.lockButtons.get((int)i2).visible = true;
                            continue;
                        }
                        this.percentageBars.get(i2).setPercentage(0);
                        this.percentageBars.get(i2).setVisible(false);
                        this.percentageBars.get((int)i2).active = false;
                        this.lockButtons.get((int)i2).visible = false;
                        continue;
                    }
                    this.percentageBars.get(i2).setPercentage(0);
                    this.percentageBars.get(i2).setVisible(false);
                    this.percentageBars.get((int)i2).active = false;
                    this.lockButtons.get((int)i2).visible = false;
                }
            }
            if (this.paletteSelector != null) {
                this.paletteSelector.refreshDisplay();
            }
        }
        if (this.isConfiguringCopycat && this.copycatConfigSlot >= 0 && ((slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(this.copycatConfigSlot)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem) || !CreateCompat.isCopycatBlock((blockItem = (BlockItem)item).getBlock()))) {
            this.finishCopycatConfig();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slotY;
        int slotX;
        int boxHeight;
        int boxWidth;
        int boxY;
        int boxX;
        int col;
        int actualRow;
        int row;
        int totalWidth;
        int unitWidth;
        if (this.canScroll && button == 0) {
            int scrollBarWidth = 6;
            int scrollBarX = this.leftPos + this.imageWidth - scrollBarWidth - 8;
            int scrollBarTop = this.calculatedGridY;
            int scrollBarHeight = this.visibleRows * 34;
            if (mouseX >= (double)scrollBarX && mouseX < (double)(scrollBarX + scrollBarWidth) && mouseY >= (double)scrollBarTop && mouseY < (double)(scrollBarTop + scrollBarHeight)) {
                this.isScrolling = true;
                return true;
            }
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            boolean handled = this.paletteSelector.mouseClicked(mouseX, mouseY, button);
            if (!handled) {
                this.paletteSelector.close();
            }
            return true;
        }
        if (button == 0 && !this.isRenaming && !this.isDeleting) {
            unitWidth = 23;
            totalWidth = unitWidth * 7 + 36;
            int startX = this.leftPos + (this.imageWidth - totalWidth) / 2;
            for (row = 0; row < this.visibleRows && (actualRow = row + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row) {
                int slotIndex;
                for (col = 0; col < 7 && (slotIndex = actualRow * 7 + col) < ((PaletteMenu)this.menu).paletteSlots; ++col) {
                    Item item;
                    ItemStack slotItem;
                    int slotX2 = startX + col * (unitWidth + 6);
                    int slotY2 = this.calculatedGridY + row * 34;
                    if (!(mouseX >= (double)slotX2) || !(mouseX < (double)(slotX2 + 18)) || !(mouseY >= (double)slotY2) || !(mouseY < (double)(slotY2 + 18)) || (slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    this.setFocused(null);
                    if (CreateCompat.isCopycatBlock(blockItem.getBlock())) {
                        this.openCopycatConfig(slotIndex);
                        return true;
                    }
                    if (FramedBlocksCompat.isFramedBlock(blockItem.getBlock())) {
                        this.openFramedConfig(slotIndex);
                        return true;
                    }
                    this.openRotationConfig(slotIndex, PaletteScreen.hasControlDown());
                    return true;
                }
            }
        }
        for (int i = 0; i < this.percentageBars.size(); ++i) {
            InteractivePercentageBar bar = this.percentageBars.get(i);
            if (!bar.visible) continue;
            if (bar.isInTextInputMode()) {
                if (bar.isMouseOver(mouseX, mouseY)) {
                    return bar.mouseClicked(mouseX, mouseY, button);
                }
                bar.keyPressed(256, 0, 0);
                return true;
            }
            if (!bar.active || !bar.isMouseOver(mouseX, mouseY)) continue;
            return bar.mouseClicked(mouseX, mouseY, button);
        }
        if (this.isConfiguringCopycat) {
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            boxHeight = 20;
            slotX = boxX + boxWidth + 10;
            slotY = boxY + 1;
            boolean clickOnCopycatElements = mouseX >= (double)boxX && mouseX < (double)(boxX + boxWidth) && mouseY >= (double)boxY && mouseY < (double)(boxY + boxHeight) || mouseX >= (double)(slotX - 1) && mouseX < (double)(slotX + 17) && mouseY >= (double)(slotY - 1) && mouseY < (double)(slotY + 17) || this.copycatLitButton.isMouseOver(mouseX, mouseY) || this.copycatAxisButton.isMouseOver(mouseX, mouseY) || this.copycatRotationButton != null && this.copycatRotationButton.visible && this.copycatRotationButton.isMouseOver(mouseX, mouseY);
            for (Renderable widget : this.renderables) {
                Button btn;
                if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("\u2713") || !btn.visible || !btn.isMouseOver(mouseX, mouseY)) continue;
                clickOnCopycatElements = true;
                break;
            }
            boolean clickOnSlots = false;
            for (Slot slot : ((PaletteMenu)this.menu).slots) {
                if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
                clickOnSlots = true;
                break;
            }
            if (!clickOnSlots) {
                int actualRow2;
                int unitWidth2 = 23;
                int totalWidth2 = unitWidth2 * 7 + 36;
                int paletteStartX = this.leftPos + (this.imageWidth - totalWidth2) / 2;
                for (int row2 = 0; row2 < this.visibleRows && (actualRow2 = row2 + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row2) {
                    int slotIndex;
                    for (int col2 = 0; col2 < 7 && (slotIndex = actualRow2 * 7 + col2) < ((PaletteMenu)this.menu).paletteSlots; ++col2) {
                        int checkSlotX = paletteStartX + col2 * (unitWidth2 + 6);
                        int checkSlotY = this.calculatedGridY + row2 * 34;
                        if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY) || !(mouseY < (double)(checkSlotY + 18))) continue;
                        clickOnSlots = true;
                        break;
                    }
                    if (clickOnSlots) break;
                }
            }
            if (!clickOnCopycatElements && !clickOnSlots) {
                this.finishCopycatConfig();
                return true;
            }
        }
        if (this.isRenaming) {
            int remainingSpace = this.leftPos + this.imageWidth - (this.renameBox.getX() + this.renameBox.getWidth());
            int slotX3 = this.renameBox.getX() + this.renameBox.getWidth() + (remainingSpace - 18) / 2;
            int slotY3 = this.renameBox.getY() + 1;
            if (mouseX >= (double)(slotX3 - 1) && mouseX < (double)(slotX3 + 17) && mouseY >= (double)(slotY3 - 1) && mouseY < (double)(slotY3 + 17) && button == 1) {
                this.selectedIconBlock = null;
                this.iconContainer.setItem(0, ItemStack.EMPTY);
                return true;
            }
            boolean clickOnRenameElements = this.renameBox.isMouseOver(mouseX, mouseY) || this.confirmRenameButton.isMouseOver(mouseX, mouseY) || this.cancelRenameButton.isMouseOver(mouseX, mouseY) || mouseX >= (double)(slotX3 - 1) && mouseX < (double)(slotX3 + 17) && mouseY >= (double)(slotY3 - 1) && mouseY < (double)(slotY3 + 17);
            boolean clickOnSlots = false;
            int unitWidth3 = 23;
            int totalWidth3 = unitWidth3 * 7 + 36;
            int startX = this.leftPos + (this.imageWidth - totalWidth3) / 2;
            int gridY = this.calculatedGridY;
            for (int i2 = 0; i2 < ((PaletteMenu)this.menu).paletteSlots && i2 < ((PaletteMenu)this.menu).slots.size(); ++i2) {
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i2);
                if (!(slot instanceof GhostSlot) || slot.y < 0 || !(mouseX >= (double)slot.x) || !(mouseX < (double)(slot.x + 18)) || !(mouseY >= (double)slot.y) || !(mouseY < (double)(slot.y + 18))) continue;
                clickOnSlots = true;
                break;
            }
            if (!clickOnSlots) {
                for (Slot slot : ((PaletteMenu)this.menu).slots) {
                    if (!this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) continue;
                    clickOnSlots = true;
                    break;
                }
            }
            if (!clickOnRenameElements && !clickOnSlots) {
                this.cancelRename();
                return true;
            }
        }
        if (this.isDeleting) {
            boolean clickOnDeleteElements;
            boxX = this.paletteSelector.getX();
            boxY = this.paletteSelector.getY();
            boxWidth = 210;
            boxHeight = this.paletteSelector.getHeight();
            boolean bl = clickOnDeleteElements = this.confirmDeleteButton.isMouseOver(mouseX, mouseY) || this.cancelDeleteButton.isMouseOver(mouseX, mouseY) || mouseX >= (double)boxX && mouseX < (double)(boxX + boxWidth) && mouseY >= (double)boxY && mouseY < (double)(boxY + boxHeight);
            if (!clickOnDeleteElements) {
                this.cancelDelete();
                return true;
            }
        }
        if (this.isConfiguringCopycat) {
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            int slotX4 = boxX + boxWidth + 10;
            int slotY4 = boxY + 1;
            if (mouseX >= (double)(slotX4 - 1) && mouseX < (double)(slotX4 + 17) && mouseY >= (double)(slotY4 - 1) && mouseY < (double)(slotY4 + 17)) {
                if (button == 1 && this.workingCopycatConfig != null) {
                    this.workingCopycatConfig.setMaterial(null);
                    this.updateCopycatConfigButtons();
                }
                return true;
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item i2;
                ItemStack stack;
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot.container instanceof Inventory) || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (stack = slot.getItem()).isEmpty() || !((i2 = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)i2;
                if (!CreateCompat.isValidCopycatMaterial(blockItem.getBlock())) {
                    if (this.minecraft != null && this.minecraft.player != null) {
                        this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                    }
                    return true;
                }
                if (this.workingCopycatConfig != null) {
                    this.workingCopycatConfig.setMaterial(blockItem.getBlock().defaultBlockState());
                    this.updateCopycatConfigButtons();
                }
                return true;
            }
        }
        if (this.isConfiguringFramed) {
            boxX = this.leftPos + 10;
            boxY = this.dropdownY + 5;
            boxWidth = 183;
            boxHeight = 20;
            slotX = boxX + boxWidth + 10;
            slotY = boxY + 1;
            if (mouseX >= (double)(slotX - 1) && mouseX < (double)(slotX + 17) && mouseY >= (double)(slotY - 1) && mouseY < (double)(slotY + 17)) {
                if (button == 1 && this.workingFramedConfig != null) {
                    this.workingFramedConfig.setCamo(null);
                }
                return true;
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item slot;
                ItemStack stack;
                Slot slot2 = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot2.container instanceof Inventory) || !this.isHovering(slot2.x, slot2.y, 16, 16, mouseX, mouseY) || (stack = slot2.getItem()).isEmpty() || !((slot = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)slot;
                if (!FramedBlocksCompat.isValidFramedCamo(blockItem.getBlock())) {
                    if (this.minecraft != null && this.minecraft.player != null) {
                        this.minecraft.player.playSound(SoundEvents.ITEM_BREAK, 0.5f, 1.5f);
                    }
                    return true;
                }
                if (this.workingFramedConfig != null) {
                    this.workingFramedConfig.setCamo(blockItem.getBlock().defaultBlockState());
                }
                return true;
            }
        }
        if (this.isRenaming) {
            unitWidth = 23;
            totalWidth = unitWidth * 7 + 36;
            int paletteStartX = this.leftPos + (this.imageWidth - totalWidth) / 2;
            for (row = 0; row < this.visibleRows && (actualRow = row + this.scrollOffset) < ((PaletteMenu)this.menu).paletteRows; ++row) {
                int slotIndex;
                for (col = 0; col < 7 && (slotIndex = actualRow * 7 + col) < ((PaletteMenu)this.menu).paletteSlots; ++col) {
                    Item item;
                    ItemStack slotItem;
                    int checkSlotX = paletteStartX + col * (unitWidth + 6);
                    int checkSlotY = this.calculatedGridY + row * 34;
                    if (!(mouseX >= (double)checkSlotX) || !(mouseX < (double)(checkSlotX + 18)) || !(mouseY >= (double)checkSlotY) || !(mouseY < (double)(checkSlotY + 18)) || (slotItem = ((PaletteMenu)this.menu).paletteContainer.getItem(slotIndex)).isEmpty() || !((item = slotItem.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    this.selectedIconBlock = blockItem.getBlock().defaultBlockState();
                    this.iconContainer.setItem(0, new ItemStack((ItemLike)blockItem));
                    return true;
                }
            }
            for (int i = 0; i < ((PaletteMenu)this.menu).slots.size(); ++i) {
                Item item;
                ItemStack stack;
                Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
                if (!(slot.container instanceof Inventory) || !this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY) || (stack = slot.getItem()).isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                this.selectedIconBlock = blockItem.getBlock().defaultBlockState();
                this.iconContainer.setItem(0, new ItemStack((ItemLike)blockItem));
                return true;
            }
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot instanceof GhostSlot) {
            super.slotClicked(slot, slotId, mouseButton, type);
            return;
        }
        super.slotClicked(slot, slotId, mouseButton, type);
        if (slotId >= 0 && slotId < ((PaletteMenu)this.menu).paletteSlots) {
            this.trowelData = ((PaletteMenu)this.menu).getTrowelData();
            this.currentPalette = this.trowelData.getActivePalette();
            this.updateUI();
        }
    }

    public void onClose() {
        super.onClose();
    }

    private void calculateVisibleRows() {
        int paletteHeight;
        int fixedHeight;
        int totalRequiredHeight;
        this.visibleRows = Math.min(4, ((PaletteMenu)this.menu).paletteRows);
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        while (this.visibleRows > 2 && (totalRequiredHeight = (fixedHeight = 98 + PaletteLayoutConstants.getInventoryOffset(this.visibleRows) + 100) + (paletteHeight = this.visibleRows * 34) + 40) > screenHeight) {
            --this.visibleRows;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        for (int i = 0; i < this.percentageBars.size(); ++i) {
            InteractivePercentageBar bar = this.percentageBars.get(i);
            int row = i / 7;
            if (row < this.scrollOffset || row >= this.scrollOffset + this.visibleRows) continue;
            double adjustedMouseY = mouseY + (double)(this.scrollOffset * 34);
            if (!bar.visible || !bar.active || !bar.mouseScrolled(mouseX, adjustedMouseY, deltaX, deltaY)) continue;
            return true;
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            return this.paletteSelector.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        if (this.canScroll && this.isMouseInPaletteArea(mouseX, mouseY)) {
            double scrollAmount = deltaY;
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScrollOffset, (double)this.scrollOffset - scrollAmount));
            ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
            this.applyScrollToWidgets();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private boolean isMouseInPaletteArea(double mouseX, double mouseY) {
        int paletteTop = this.calculatedGridY;
        int paletteBottom = this.calculatedGridY + this.visibleRows * 34;
        return mouseX >= (double)this.leftPos && mouseX < (double)(this.leftPos + this.imageWidth) && mouseY >= (double)paletteTop && mouseY < (double)paletteBottom;
    }

    private void renderRotationConfigBackgrounds(GuiGraphics graphics) {
        int bgColor = -5263441;
        int borderTopLeft = -7631989;
        int borderBottomRight = -1;
        int bgWidth = 203;
        int bgX = this.leftPos + (this.imageWidth - bgWidth) / 2;
        int topBgY = this.dropdownY + 2;
        int topBgHeight = 49;
        graphics.fill(bgX, topBgY, bgX + bgWidth, topBgY + topBgHeight, bgColor);
        graphics.hLine(bgX, bgX + bgWidth - 1, topBgY, borderTopLeft);
        graphics.vLine(bgX, topBgY, topBgY + topBgHeight - 1, borderTopLeft);
        graphics.hLine(bgX, bgX + bgWidth - 1, topBgY + topBgHeight - 1, borderBottomRight);
        graphics.vLine(bgX + bgWidth - 1, topBgY, topBgY + topBgHeight - 1, borderBottomRight);
        if (this.rotationBlockHasProperties) {
            int bottomBgY = this.calculatedControlsY - 2;
            int bottomBgHeight = this.calculatedGlobalY - this.calculatedControlsY + 20 + 5;
            graphics.fill(bgX, bottomBgY, bgX + bgWidth, bottomBgY + bottomBgHeight, bgColor);
            graphics.hLine(bgX, bgX + bgWidth - 1, bottomBgY, borderTopLeft);
            graphics.vLine(bgX, bottomBgY, bottomBgY + bottomBgHeight - 1, borderTopLeft);
            graphics.hLine(bgX, bgX + bgWidth - 1, bottomBgY + bottomBgHeight - 1, borderBottomRight);
            graphics.vLine(bgX + bgWidth - 1, bottomBgY, bottomBgY + bottomBgHeight - 1, borderBottomRight);
        }
    }

    private void drawScrollBar(GuiGraphics graphics, int mouseX, int mouseY) {
        int scrollBarWidth = 6;
        int scrollBarX = this.leftPos + this.imageWidth - scrollBarWidth - 6;
        int scrollBarTop = this.calculatedGridY + 1;
        int scrollBarHeight = this.visibleRows * 34 - 2;
        int trackX1 = scrollBarX;
        int trackY1 = scrollBarTop;
        int trackX2 = scrollBarX + scrollBarWidth;
        int trackY2 = scrollBarTop + scrollBarHeight;
        graphics.fill(trackX1 - 1, trackY1 - 1, trackX2 + 1, trackY2 + 1, -13158601);
        graphics.fill(trackX1, trackY1, trackX2, trackY2, -14803426);
        float scrollPercent = this.maxScrollOffset > 0 ? (float)this.scrollOffset / (float)this.maxScrollOffset : 0.0f;
        int thumbHeight = Math.max(16, (int)((float)this.visibleRows / (float)((PaletteMenu)this.menu).paletteRows * (float)scrollBarHeight));
        int thumbY = scrollBarTop + (int)((float)(scrollBarHeight - thumbHeight) * scrollPercent);
        boolean isHovering = mouseX >= scrollBarX && mouseX < scrollBarX + scrollBarWidth && mouseY >= thumbY && mouseY < thumbY + thumbHeight;
        boolean isActive = isHovering || this.isScrolling;
        int thumbX1 = scrollBarX;
        int thumbX2 = scrollBarX + scrollBarWidth;
        int thumbY1 = thumbY;
        int thumbY2 = thumbY + thumbHeight;
        int mainColor = isActive ? -3750202 : -7631989;
        graphics.fill(thumbX1, thumbY1, thumbX2, thumbY2, mainColor);
        int highlightColor = isActive ? -1 : -3750202;
        graphics.fill(thumbX1, thumbY1, thumbX2, thumbY1 + 1, highlightColor);
        graphics.fill(thumbX1, thumbY1, thumbX1 + 1, thumbY2, highlightColor);
        int shadowColor = isActive ? -7631989 : -11184811;
        graphics.fill(thumbX1, thumbY2 - 1, thumbX2, thumbY2, shadowColor);
        graphics.fill(thumbX2 - 1, thumbY1, thumbX2, thumbY2, shadowColor);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.paletteSelector != null && this.paletteSelector.isOpen() && this.paletteSelector.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (this.isScrolling && this.canScroll) {
            int scrollBarTop = this.calculatedGridY;
            int scrollBarHeight = this.visibleRows * 34;
            int thumbHeight = Math.max(20, (int)((float)this.visibleRows / (float)((PaletteMenu)this.menu).paletteRows * (float)scrollBarHeight));
            double scrollRange = scrollBarHeight - thumbHeight;
            double scrollPercent = (mouseY - (double)scrollBarTop - (double)thumbHeight / 2.0) / scrollRange;
            scrollPercent = Math.max(0.0, Math.min(1.0, scrollPercent));
            this.scrollOffset = (int)((double)this.maxScrollOffset * scrollPercent);
            ((PaletteMenu)this.menu).updateScrollOffset(this.scrollOffset);
            this.applyScrollToWidgets();
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.paletteSelector != null) {
            this.paletteSelector.mouseReleased(mouseX, mouseY, button);
        }
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void renderSlot(GuiGraphics graphics, Slot slot) {
        if (slot instanceof GhostSlot && slot.index < ((PaletteMenu)this.menu).paletteSlots) {
            boolean isCurrentlyConfiguring;
            if (slot.y < 0) {
                return;
            }
            int x = slot.x;
            int y = slot.y;
            ItemStack stack = slot.getItem();
            boolean hasConfiguredCamo = false;
            boolean hasConfiguredRotation = false;
            if (this.currentPalette != null && !stack.isEmpty()) {
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != slot.index) continue;
                    if (block.getCopycatConfig() != null && block.getCopycatConfig().isConfigured()) {
                        hasConfiguredCamo = true;
                    }
                    if (block.getFramedConfig() != null && block.getFramedConfig().isConfigured()) {
                        hasConfiguredCamo = true;
                    }
                    if (!block.hasRotationConfig()) break;
                    hasConfiguredRotation = true;
                    break;
                }
            }
            if (this.hoveredSlot == slot && slot.isActive()) {
                graphics.fill(x - 1, y - 1, x + 17, y + 17, -2130706433);
            }
            graphics.renderItem(stack, x, y);
            graphics.renderItemDecorations(this.font, stack, x, y);
            boolean isCurrentlyConfiguringRotation = this.isConfiguringRotation && this.rotationConfigSlots.contains(slot.index);
            boolean isCurrentlyConfiguringCopycat = this.isConfiguringCopycat && this.copycatConfigSlot == slot.index;
            boolean isCurrentlyConfiguringFramed = this.isConfiguringFramed && this.framedConfigSlot == slot.index;
            boolean bl = isCurrentlyConfiguring = isCurrentlyConfiguringRotation || isCurrentlyConfiguringCopycat || isCurrentlyConfiguringFramed;
            if (isCurrentlyConfiguring) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                int edgeColor = -5614081;
                int innerColor = 1621775871;
                graphics.fill(x, y, x + 16, y + 1, edgeColor);
                graphics.fill(x, y + 15, x + 16, y + 16, edgeColor);
                graphics.fill(x, y + 1, x + 1, y + 15, edgeColor);
                graphics.fill(x + 15, y + 1, x + 16, y + 15, edgeColor);
                graphics.fill(x + 1, y + 1, x + 15, y + 2, innerColor);
                graphics.fill(x + 1, y + 14, x + 15, y + 15, innerColor);
                graphics.fill(x + 1, y + 2, x + 2, y + 14, innerColor);
                graphics.fill(x + 14, y + 2, x + 15, y + 14, innerColor);
                graphics.pose().popPose();
            } else if (hasConfiguredCamo || hasConfiguredRotation) {
                graphics.pose().pushPose();
                graphics.pose().translate(0.0f, 0.0f, 200.0f);
                graphics.fill(x, y + 14, x + 16, y + 15, -2136320513);
                graphics.fill(x, y + 15, x + 16, y + 16, -5614081);
                graphics.pose().popPose();
            }
        } else {
            super.renderSlot(graphics, slot);
        }
    }

    private boolean isSlotHovered(Slot slot, double mouseX, double mouseY) {
        if (slot instanceof GhostSlot && slot.index < ((PaletteMenu)this.menu).paletteSlots && slot.y < 0) {
            return false;
        }
        return this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY);
    }

    private void applyScrollToWidgets() {
        for (int i = 0; i < this.percentageBars.size() && i < this.lockButtons.size() && i < ((PaletteMenu)this.menu).slots.size(); ++i) {
            boolean hasBlock;
            Slot slot = (Slot)((PaletteMenu)this.menu).slots.get(i);
            if (!(slot instanceof GhostSlot)) continue;
            InteractivePercentageBar bar = this.percentageBars.get(i);
            VerticalLockToggle lock = this.lockButtons.get(i);
            if (slot.y < 0) {
                bar.visible = false;
                lock.visible = false;
                continue;
            }
            int screenX = this.leftPos + slot.x;
            int screenY = this.topPos + slot.y;
            bar.setX(screenX - 1);
            bar.setY(screenY + 18 + 2 + -1 - 1);
            lock.setX(screenX + 18 - 1);
            lock.setY(screenY + 0);
            ItemStack containerItem = ((PaletteMenu)this.menu).paletteContainer.getItem(i);
            boolean bl = hasBlock = !containerItem.isEmpty() && containerItem.getItem() instanceof BlockItem;
            if (hasBlock && this.currentPalette != null) {
                PaletteData.WeightedBlock paletteBlock = null;
                for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                    if (block.getSlotPosition() != i) continue;
                    paletteBlock = block;
                    break;
                }
                if (paletteBlock != null) {
                    bar.visible = true;
                    lock.visible = true;
                    continue;
                }
                bar.visible = false;
                lock.visible = false;
                continue;
            }
            bar.visible = false;
            lock.visible = false;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getCalculatedGridY() {
        return this.calculatedGridY;
    }

    private void openCopycatConfig(int slot) {
        PaletteData.WeightedBlock paletteBlock = null;
        if (this.currentPalette != null) {
            for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                paletteBlock = block;
                break;
            }
        }
        if (paletteBlock == null) {
            return;
        }
        this.isConfiguringCopycat = true;
        this.copycatConfigSlot = slot;
        if (this.isConfiguringRotation) {
            this.finishRotationConfig();
        }
        if (this.isConfiguringFramed) {
            this.finishFramedConfig();
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        if (paletteBlock.getCopycatConfig() != null) {
            this.workingCopycatConfig = new CopycatBlockConfig();
            this.workingCopycatConfig.setMaterial(paletteBlock.getCopycatConfig().getMaterial());
            this.workingCopycatConfig.setLit(paletteBlock.getCopycatConfig().isLit());
            this.workingCopycatConfig.setAxisMode(paletteBlock.getCopycatConfig().getAxisMode());
        } else {
            this.workingCopycatConfig = new CopycatBlockConfig();
        }
        this.updateCopycatConfigButtons();
        this.updateUI();
    }

    private void finishCopycatConfig() {
        if (this.workingCopycatConfig == null || this.copycatConfigSlot == -1) {
            this.isConfiguringCopycat = false;
            this.copycatConfigSlot = -1;
            this.workingCopycatConfig = null;
            this.hideCopycatConfigButtons();
            this.updateUI();
            return;
        }
        this.onCopycatConfigChanged(this.copycatConfigSlot, this.workingCopycatConfig);
        this.isConfiguringCopycat = false;
        this.copycatConfigSlot = -1;
        this.workingCopycatConfig = null;
        this.hideCopycatConfigButtons();
        this.updateUI();
    }

    private void hideCopycatConfigButtons() {
        if (this.copycatLitButton != null) {
            this.copycatLitButton.visible = false;
        }
        if (this.copycatAxisButton != null) {
            this.copycatAxisButton.visible = false;
        }
        if (this.copycatRotationButton != null) {
            this.copycatRotationButton.visible = false;
        }
        for (Renderable widget : this.renderables) {
            Button btn;
            if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("Confirm") || !btn.getMessage().getString().contains("\u2713") || btn == this.confirmRenameButton || btn == this.confirmDeleteButton || btn == this.rotationConfirmButton) continue;
            btn.visible = false;
        }
    }

    private void toggleCopycatLit() {
        if (this.workingCopycatConfig != null) {
            this.workingCopycatConfig.setLit(!this.workingCopycatConfig.isLit());
            this.updateCopycatConfigButtons();
        }
    }

    private void cycleCopycatAxis() {
        if (this.workingCopycatConfig != null) {
            this.workingCopycatConfig.setAxisMode(this.workingCopycatConfig.getAxisMode().next());
            this.updateCopycatConfigButtons();
        }
    }

    public void updateCopycatConfigButtons() {
        if (this.workingCopycatConfig == null) {
            return;
        }
        if (this.copycatLitButton != null) {
            boolean supportsLit = false;
            if (this.workingCopycatConfig.getMaterial() != null) {
                supportsLit = CreateCompat.supportsLitProperty(this.workingCopycatConfig.getMaterial());
            }
            if (!supportsLit && this.workingCopycatConfig.isLit()) {
                this.workingCopycatConfig.setLit(false);
            }
            if (supportsLit && this.workingCopycatConfig.isLit()) {
                this.copycatLitButton.setMessage((Component)Component.literal((String)"Lit ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)"\u2600").withStyle(ChatFormatting.YELLOW)));
            } else {
                this.copycatLitButton.setMessage((Component)Component.literal((String)"Lit ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u2600").withStyle(ChatFormatting.DARK_GRAY)));
            }
            this.copycatLitButton.active = supportsLit;
        }
        if (this.copycatAxisButton != null) {
            boolean supportsAxis = false;
            if (this.workingCopycatConfig.getMaterial() != null) {
                supportsAxis = CreateCompat.supportsAxisProperty(this.workingCopycatConfig.getMaterial());
            }
            if (!supportsAxis && this.workingCopycatConfig.getAxisMode() != CopycatBlockConfig.AxisMode.OFF) {
                this.workingCopycatConfig.setAxisMode(CopycatBlockConfig.AxisMode.OFF);
            }
            String axisText = "Axis: " + this.workingCopycatConfig.getAxisMode().getDisplayName();
            if (supportsAxis && this.workingCopycatConfig.getAxisMode() != CopycatBlockConfig.AxisMode.OFF) {
                this.copycatAxisButton.setMessage((Component)Component.literal((String)axisText).withStyle(ChatFormatting.WHITE));
            } else {
                this.copycatAxisButton.setMessage((Component)Component.literal((String)axisText).withStyle(ChatFormatting.GRAY));
            }
            this.copycatAxisButton.active = supportsAxis;
        }
    }

    private void onCopycatConfigChanged(int slot, CopycatBlockConfig config) {
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock != null) {
            paletteBlock.setCopycatConfig(config);
            this.savePalette();
            CompoundTag updateTag = new CompoundTag();
            updateTag.putInt("slot", slot);
            CompoundTag configTag = new CompoundTag();
            config.save(configTag);
            updateTag.put("config", (Tag)configTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_COPYCAT_CONFIG, this.currentPaletteIndex, updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void openFramedConfig(int slot) {
        if (this.isRenaming || this.isDeleting) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        if (this.currentPalette != null) {
            for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                paletteBlock = block;
                break;
            }
        }
        if (paletteBlock == null) {
            return;
        }
        this.isConfiguringFramed = true;
        this.framedConfigSlot = slot;
        if (this.isConfiguringRotation) {
            this.finishRotationConfig();
        }
        if (this.isConfiguringCopycat) {
            this.finishCopycatConfig();
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        if (paletteBlock.getFramedConfig() != null) {
            this.workingFramedConfig = new FramedBlockConfig();
            this.workingFramedConfig.setCamo(paletteBlock.getFramedConfig().getCamo());
        } else {
            this.workingFramedConfig = new FramedBlockConfig();
        }
        this.framedInstructionText = Component.literal((String)"Drag a block from your inventory or JEI to set camo");
        this.updateUI();
    }

    private void finishFramedConfig() {
        if (this.workingFramedConfig == null || this.framedConfigSlot == -1) {
            this.isConfiguringFramed = false;
            this.framedConfigSlot = -1;
            this.workingFramedConfig = null;
            this.hideFramedConfigButtons();
            this.updateUI();
            return;
        }
        this.onFramedConfigChanged(this.framedConfigSlot, this.workingFramedConfig);
        this.isConfiguringFramed = false;
        this.framedConfigSlot = -1;
        this.workingFramedConfig = null;
        this.hideFramedConfigButtons();
        this.updateUI();
    }

    private void hideFramedConfigButtons() {
        if (this.framedRotationButton != null) {
            this.framedRotationButton.visible = false;
        }
        for (Renderable widget : this.renderables) {
            Button btn;
            if (!(widget instanceof Button) || !(btn = (Button)widget).getMessage().getString().contains("Confirm") || !btn.getMessage().getString().contains("\u2713") || btn == this.confirmRenameButton || btn == this.confirmDeleteButton || btn == this.rotationConfirmButton) continue;
            btn.visible = false;
        }
    }

    private void onFramedConfigChanged(int slot, FramedBlockConfig config) {
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock != null) {
            paletteBlock.setFramedConfig(config);
            this.savePalette();
            CompoundTag updateTag = new CompoundTag();
            updateTag.putInt("slot", slot);
            CompoundTag configTag = new CompoundTag();
            config.save(configTag);
            updateTag.put("config", (Tag)configTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_FRAMED_CONFIG, this.currentPaletteIndex, updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isConfiguringFramed() {
        return this.isConfiguringFramed;
    }

    public FramedBlockConfig getWorkingFramedConfig() {
        return this.workingFramedConfig;
    }

    public boolean isRenaming() {
        return this.isRenaming;
    }

    public boolean isConfiguringCopycat() {
        return this.isConfiguringCopycat;
    }

    public EditBox getRenameBox() {
        return this.renameBox;
    }

    public void setSelectedIconBlock(BlockState blockState) {
        this.selectedIconBlock = blockState;
    }

    public SimpleContainer getIconContainer() {
        return this.iconContainer;
    }

    public int getDropdownY() {
        return this.dropdownY;
    }

    public CopycatBlockConfig getWorkingCopycatConfig() {
        return this.workingCopycatConfig;
    }

    private void openRotationConfig(int slot) {
        this.openRotationConfig(slot, false);
    }

    private void openRotationConfig(int slot, boolean addToSelection) {
        if (this.isRenaming || this.isDeleting) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        if (this.currentPalette != null) {
            for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
                if (block.getSlotPosition() != slot) continue;
                paletteBlock = block;
                break;
            }
        }
        if (paletteBlock == null) {
            return;
        }
        if (addToSelection && this.isConfiguringRotation && !this.rotationConfigSlots.isEmpty()) {
            if (this.rotationConfigSlots.contains(slot)) {
                this.rotationConfigSlots.remove(slot);
                if (this.rotationConfigSlots.isEmpty()) {
                    this.cancelRotationConfig();
                    return;
                }
            } else {
                this.rotationConfigSlots.add(slot);
            }
            this.updateRotationPropertyButtonsForSelection();
            this.updateRotationButtonPositions();
            this.updateUI();
            return;
        }
        if (this.isConfiguringRotation && !this.rotationConfigSlots.isEmpty() && this.workingRotationConfig != null) {
            Iterator<Object> iterator = this.rotationConfigSlots.iterator();
            while (iterator.hasNext()) {
                int selectedSlot = (Integer)iterator.next();
                this.onRotationConfigChanged(selectedSlot, this.workingRotationConfig);
            }
        }
        this.isConfiguringRotation = true;
        this.rotationConfigSlots.clear();
        this.rotationConfigSlots.add(slot);
        if (this.isConfiguringCopycat) {
            this.finishCopycatConfig();
        }
        if (this.isConfiguringFramed) {
            this.finishFramedConfig();
        }
        if (this.paletteSelector != null && this.paletteSelector.isOpen()) {
            this.paletteSelector.close();
        }
        this.workingRotationConfig = paletteBlock.getRotationConfig() != null ? new BlockRotationConfig(paletteBlock.getRotationConfig()) : new BlockRotationConfig();
        this.updateRotationDirectionButtonStates();
        this.updateRotationPropertyButtonsForSelection();
        this.updateRotationPropertyButtonStates();
        if (this.rotationStairLinkButton != null) {
            this.rotationStairLinkButton.setToggled(this.workingRotationConfig.isStairLink());
        }
        this.updateRotationButtonPositions();
        this.updateUI();
    }

    private void cancelRotationConfig() {
        this.isConfiguringRotation = false;
        this.rotationConfigSlots.clear();
        this.workingRotationConfig = null;
        this.rotationBlockHasProperties = false;
        this.hideRotationPropertyButtons();
        this.updateUI();
    }

    private void updateRotationPropertyButtons(Block block) {
        boolean isStair = block instanceof StairBlock;
        boolean isSlab = block instanceof SlabBlock;
        boolean isOpenable = block instanceof FenceGateBlock || block instanceof DoorBlock || block instanceof TrapDoorBlock;
        boolean bl = this.rotationBlockHasProperties = isStair || isSlab || isOpenable;
        if (this.rotationStairAutoButton != null) {
            boolean bl2 = this.rotationStairAutoButton.visible = this.isConfiguringRotation && isStair;
        }
        if (this.rotationStairTopButton != null) {
            boolean bl3 = this.rotationStairTopButton.visible = this.isConfiguringRotation && isStair;
        }
        if (this.rotationStairBottomButton != null) {
            boolean bl4 = this.rotationStairBottomButton.visible = this.isConfiguringRotation && isStair;
        }
        if (this.rotationSlabAutoButton != null) {
            boolean bl5 = this.rotationSlabAutoButton.visible = this.isConfiguringRotation && isSlab;
        }
        if (this.rotationSlabTopButton != null) {
            boolean bl6 = this.rotationSlabTopButton.visible = this.isConfiguringRotation && isSlab;
        }
        if (this.rotationSlabBottomButton != null) {
            boolean bl7 = this.rotationSlabBottomButton.visible = this.isConfiguringRotation && isSlab;
        }
        if (this.rotationOpenAutoButton != null) {
            boolean bl8 = this.rotationOpenAutoButton.visible = this.isConfiguringRotation && isOpenable;
        }
        if (this.rotationOpenOpenButton != null) {
            boolean bl9 = this.rotationOpenOpenButton.visible = this.isConfiguringRotation && isOpenable;
        }
        if (this.rotationOpenClosedButton != null) {
            boolean bl10 = this.rotationOpenClosedButton.visible = this.isConfiguringRotation && isOpenable;
        }
        if (this.rotationStairLinkButton != null) {
            boolean bl11 = this.rotationStairLinkButton.visible = this.isConfiguringRotation && isStair;
        }
        if (this.workingRotationConfig != null) {
            this.updateRotationPropertyButtonStates();
        }
    }

    private void updateRotationPropertyButtonsForSelection() {
        if (this.rotationConfigSlots.isEmpty() || this.currentPalette == null) {
            this.rotationBlockHasProperties = false;
            this.hideRotationPropertyButtons();
            return;
        }
        boolean allStairs = true;
        boolean allSlabs = true;
        boolean allOpenable = true;
        int count = 0;
        for (int slot : this.rotationConfigSlots) {
            boolean isOpenable;
            PaletteData.WeightedBlock block = null;
            for (PaletteData.WeightedBlock b : this.currentPalette.getBlocks()) {
                if (b.getSlotPosition() != slot) continue;
                block = b;
                break;
            }
            if (block == null) continue;
            Block blockType = block.getState().getBlock();
            boolean isStair = blockType instanceof StairBlock;
            boolean isSlab = blockType instanceof SlabBlock;
            boolean bl = isOpenable = blockType instanceof FenceGateBlock || blockType instanceof DoorBlock || blockType instanceof TrapDoorBlock;
            if (!isStair) {
                allStairs = false;
            }
            if (!isSlab) {
                allSlabs = false;
            }
            if (!isOpenable) {
                allOpenable = false;
            }
            ++count;
        }
        boolean showStairButtons = allStairs && count > 0;
        boolean showSlabButtons = allSlabs && count > 0;
        boolean showOpenButtons = allOpenable && count > 0;
        boolean bl = this.rotationBlockHasProperties = showStairButtons || showSlabButtons || showOpenButtons;
        if (this.rotationStairAutoButton != null) {
            boolean bl2 = this.rotationStairAutoButton.visible = this.isConfiguringRotation && showStairButtons;
        }
        if (this.rotationStairTopButton != null) {
            boolean bl3 = this.rotationStairTopButton.visible = this.isConfiguringRotation && showStairButtons;
        }
        if (this.rotationStairBottomButton != null) {
            boolean bl4 = this.rotationStairBottomButton.visible = this.isConfiguringRotation && showStairButtons;
        }
        if (this.rotationSlabAutoButton != null) {
            boolean bl5 = this.rotationSlabAutoButton.visible = this.isConfiguringRotation && showSlabButtons;
        }
        if (this.rotationSlabTopButton != null) {
            boolean bl6 = this.rotationSlabTopButton.visible = this.isConfiguringRotation && showSlabButtons;
        }
        if (this.rotationSlabBottomButton != null) {
            boolean bl7 = this.rotationSlabBottomButton.visible = this.isConfiguringRotation && showSlabButtons;
        }
        if (this.rotationOpenAutoButton != null) {
            boolean bl8 = this.rotationOpenAutoButton.visible = this.isConfiguringRotation && showOpenButtons;
        }
        if (this.rotationOpenOpenButton != null) {
            boolean bl9 = this.rotationOpenOpenButton.visible = this.isConfiguringRotation && showOpenButtons;
        }
        if (this.rotationOpenClosedButton != null) {
            boolean bl10 = this.rotationOpenClosedButton.visible = this.isConfiguringRotation && showOpenButtons;
        }
        if (this.rotationStairLinkButton != null) {
            boolean bl11 = this.rotationStairLinkButton.visible = this.isConfiguringRotation && showStairButtons;
        }
        if (this.workingRotationConfig != null) {
            this.updateRotationPropertyButtonStates();
        }
    }

    private void finishRotationConfig() {
        if (this.workingRotationConfig == null || this.rotationConfigSlots.isEmpty()) {
            this.isConfiguringRotation = false;
            this.rotationConfigSlots.clear();
            this.workingRotationConfig = null;
            this.rotationBlockHasProperties = false;
            this.hideRotationPropertyButtons();
            this.updateUI();
            return;
        }
        for (int slot : this.rotationConfigSlots) {
            this.onRotationConfigChanged(slot, this.workingRotationConfig);
        }
        this.isConfiguringRotation = false;
        this.rotationConfigSlots.clear();
        this.workingRotationConfig = null;
        this.rotationBlockHasProperties = false;
        this.hideRotationPropertyButtons();
        this.updateUI();
    }

    private void hideRotationPropertyButtons() {
        if (this.rotationNorthButton != null) {
            this.rotationNorthButton.visible = false;
        }
        if (this.rotationSouthButton != null) {
            this.rotationSouthButton.visible = false;
        }
        if (this.rotationEastButton != null) {
            this.rotationEastButton.visible = false;
        }
        if (this.rotationWestButton != null) {
            this.rotationWestButton.visible = false;
        }
        if (this.rotationUpButton != null) {
            this.rotationUpButton.visible = false;
        }
        if (this.rotationDownButton != null) {
            this.rotationDownButton.visible = false;
        }
        if (this.rotationConfirmButton != null) {
            this.rotationConfirmButton.visible = false;
        }
        if (this.rotationResetButton != null) {
            this.rotationResetButton.visible = false;
        }
        if (this.rotationStairAutoButton != null) {
            this.rotationStairAutoButton.visible = false;
        }
        if (this.rotationStairTopButton != null) {
            this.rotationStairTopButton.visible = false;
        }
        if (this.rotationStairBottomButton != null) {
            this.rotationStairBottomButton.visible = false;
        }
        if (this.rotationSlabAutoButton != null) {
            this.rotationSlabAutoButton.visible = false;
        }
        if (this.rotationSlabTopButton != null) {
            this.rotationSlabTopButton.visible = false;
        }
        if (this.rotationSlabBottomButton != null) {
            this.rotationSlabBottomButton.visible = false;
        }
        if (this.rotationOpenAutoButton != null) {
            this.rotationOpenAutoButton.visible = false;
        }
        if (this.rotationOpenOpenButton != null) {
            this.rotationOpenOpenButton.visible = false;
        }
        if (this.rotationOpenClosedButton != null) {
            this.rotationOpenClosedButton.visible = false;
        }
        if (this.rotationStairLinkButton != null) {
            this.rotationStairLinkButton.visible = false;
        }
    }

    private void onRotationConfigChanged(int slot, BlockRotationConfig config) {
        if (this.currentPalette == null) {
            return;
        }
        PaletteData.WeightedBlock paletteBlock = null;
        for (PaletteData.WeightedBlock block : this.currentPalette.getBlocks()) {
            if (block.getSlotPosition() != slot) continue;
            paletteBlock = block;
            break;
        }
        if (paletteBlock != null) {
            paletteBlock.setRotationConfig(config);
            this.savePalette();
            CompoundTag updateTag = new CompoundTag();
            updateTag.putInt("slot", slot);
            CompoundTag configTag = new CompoundTag();
            config.save(configTag);
            updateTag.put("config", (Tag)configTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.UPDATE_BLOCK_ROTATION_CONFIG, this.currentPaletteIndex, updateTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isConfiguringRotation() {
        return this.isConfiguringRotation;
    }
}

