/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.gui.PaletteLayoutConstants;
import com.asger.mechtrowel.gui.widget.GhostSlot;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.registry.ModRegistry;
import com.asger.mechtrowel.util.PaletteBalancer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class PaletteMenu
extends AbstractContainerMenu {
    public static final int PALETTE_COLUMNS = 7;
    public final int paletteSlots;
    public final int paletteRows;
    private int visibleRows = 4;
    private final int trowelSlot;
    private final Inventory playerInventory;
    private TrowelData trowelData;
    private CompoundTag lastKnownNBT;
    public final SimpleContainer paletteContainer;
    protected Player player;
    private boolean isInitializing = false;

    public PaletteMenu(int windowId, Inventory playerInventory, ItemStack trowelStack) {
        super((MenuType)ModRegistry.PALETTE_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.trowelSlot = playerInventory.findSlotMatchingItem(trowelStack);
        this.trowelData = TrowelData.getOrCreate(this.getTrowelStack());
        this.lastKnownNBT = ((CustomData)this.getTrowelStack().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().copy();
        int maxPalettes = MechTrowel.Config.getMaxPalettes();
        this.paletteRows = (maxPalettes + 7 - 1) / 7;
        this.paletteSlots = this.paletteRows * 7;
        this.paletteContainer = new SimpleContainer(this.paletteSlots){

            public void setChanged() {
                super.setChanged();
                if (!PaletteMenu.this.isInitializing) {
                    PaletteMenu.this.slotsChanged((Container)this);
                }
            }
        };
        this.player = playerInventory.player;
        this.isInitializing = true;
        this.initializePaletteContainer();
        this.addScrolledPaletteSlots(0);
        this.addPlayerInventory(playerInventory);
        this.isInitializing = false;
    }

    public PaletteMenu(int windowId, Inventory playerInventory, int trowelSlot) {
        super((MenuType)ModRegistry.PALETTE_MENU.get(), windowId);
        this.playerInventory = playerInventory;
        this.trowelSlot = trowelSlot;
        this.trowelData = TrowelData.getOrCreate(this.getTrowelStack());
        this.lastKnownNBT = ((CustomData)this.getTrowelStack().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().copy();
        int maxPalettes = MechTrowel.Config.getMaxPalettes();
        this.paletteRows = (maxPalettes + 7 - 1) / 7;
        this.paletteSlots = this.paletteRows * 7;
        this.paletteContainer = new SimpleContainer(this.paletteSlots){

            public void setChanged() {
                super.setChanged();
                if (!PaletteMenu.this.isInitializing) {
                    PaletteMenu.this.slotsChanged((Container)this);
                }
            }
        };
        this.player = playerInventory.player;
        this.isInitializing = true;
        this.initializePaletteContainer();
        this.addScrolledPaletteSlots(0);
        this.addPlayerInventory(playerInventory);
        this.isInitializing = false;
    }

    private void initializePaletteContainer() {
        PaletteData palette = this.trowelData.getActivePalette();
        if (palette != null) {
            ItemStack blockItem;
            List<PaletteData.WeightedBlock> blocks = palette.getBlocks();
            HashSet<PaletteData.WeightedBlock> placedBlocks = new HashSet<PaletteData.WeightedBlock>();
            for (PaletteData.WeightedBlock block : blocks) {
                int slotPos = block.getSlotPosition();
                if (slotPos < 0 || slotPos >= this.paletteSlots || !this.paletteContainer.getItem(slotPos).isEmpty()) continue;
                blockItem = new ItemStack((ItemLike)block.getState().getBlock());
                this.paletteContainer.setItem(slotPos, blockItem);
                placedBlocks.add(block);
            }
            int nextSlot = 0;
            for (PaletteData.WeightedBlock block : blocks) {
                if (placedBlocks.contains(block)) continue;
                while (nextSlot < this.paletteSlots && !this.paletteContainer.getItem(nextSlot).isEmpty()) {
                    ++nextSlot;
                }
                if (nextSlot >= this.paletteSlots) continue;
                blockItem = new ItemStack((ItemLike)block.getState().getBlock());
                this.paletteContainer.setItem(nextSlot, blockItem);
                block.setSlotPosition(nextSlot);
                ++nextSlot;
            }
            if (!this.player.level().isClientSide()) {
                this.trowelData.save(this.getTrowelStack());
            }
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int inventoryY = PaletteLayoutConstants.calculateInventoryY(0, this.visibleRows);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 35 + col * 18, inventoryY + 18 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 35 + col * 18, inventoryY + 76));
        }
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        if (container == this.paletteContainer && this.player != null && !this.player.level().isClientSide() && !this.isInitializing) {
            this.trowelData = TrowelData.getOrCreate(this.getTrowelStack());
            PaletteData palette = this.trowelData.getActivePalette();
            if (palette != null) {
                ItemStack stack;
                HashMap<BlockState, List> existingBlocksByState = new HashMap<BlockState, List>();
                for (PaletteData.WeightedBlock block : palette.getBlocks()) {
                    existingBlocksByState.computeIfAbsent(block.getState(), k -> new ArrayList()).add(block);
                }
                HashSet<PaletteData.WeightedBlock> usedBlocks = new HashSet<PaletteData.WeightedBlock>();
                ArrayList<PaletteData.WeightedBlock> newBlocks = new ArrayList<PaletteData.WeightedBlock>();
                for (int i = 0; i < this.paletteSlots; ++i) {
                    Item item;
                    stack = this.paletteContainer.getItem(i);
                    if (stack.isEmpty() || !((item = stack.getItem()) instanceof BlockItem)) continue;
                    BlockItem blockItem = (BlockItem)item;
                    BlockState state = blockItem.getBlock().defaultBlockState();
                    PaletteData.WeightedBlock matchingBlock = null;
                    List candidateBlocks = (List)existingBlocksByState.get(state);
                    if (candidateBlocks != null) {
                        for (PaletteData.WeightedBlock block : candidateBlocks) {
                            if (block.getSlotPosition() != i || usedBlocks.contains(block)) continue;
                            matchingBlock = block;
                            break;
                        }
                        if (matchingBlock == null) {
                            for (PaletteData.WeightedBlock block : candidateBlocks) {
                                if (usedBlocks.contains(block)) continue;
                                matchingBlock = block;
                                break;
                            }
                        }
                    }
                    if (matchingBlock != null) {
                        matchingBlock.setSlotPosition(i);
                        newBlocks.add(matchingBlock);
                        usedBlocks.add(matchingBlock);
                        continue;
                    }
                    PaletteData.WeightedBlock newBlock = new PaletteData.WeightedBlock(state, 1.0f, false, i);
                    newBlocks.add(newBlock);
                }
                palette.getBlocks().clear();
                palette.getBlocks().addAll(newBlocks);
                if (!palette.isEmpty()) {
                    PaletteBalancer.redistributeAfterBlockChange(palette);
                }
                this.trowelData.save(this.getTrowelStack());
                stack = this.player;
                if (stack instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)stack;
                    serverPlayer.getInventory().setChanged();
                    int slot = serverPlayer.getInventory().findSlotMatchingItem(this.getTrowelStack());
                    if (slot >= 0) {
                        int containerSlot;
                        int n = containerSlot = slot < 9 ? slot + 36 : slot;
                        if (containerSlot < serverPlayer.inventoryMenu.slots.size()) {
                            serverPlayer.inventoryMenu.getSlot(containerSlot).setChanged();
                        }
                    }
                    serverPlayer.inventoryMenu.broadcastFullState();
                    this.broadcastChanges();
                    serverPlayer.containerMenu.sendAllDataToRemote();
                }
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack slotStack = slot.getItem();
        ItemStack originalStack = slotStack.copy();
        if (index >= this.paletteSlots) {
            Item item = slotStack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                for (int i = 0; i < this.paletteSlots; ++i) {
                    if (!this.paletteContainer.getItem(i).isEmpty()) continue;
                    ItemStack ghostStack = slotStack.copy();
                    ghostStack.setCount(1);
                    this.paletteContainer.setItem(i, ghostStack);
                    this.slotsChanged((Container)this.paletteContainer);
                    this.broadcastChanges();
                    return ItemStack.EMPTY;
                }
            }
        } else if (index < this.paletteSlots) {
            slot.set(ItemStack.EMPTY);
            this.slotsChanged((Container)this.paletteContainer);
            this.broadcastChanges();
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        Slot slot;
        if (slotId >= 0 && slotId < this.paletteSlots && (slot = (Slot)this.slots.get(slotId)) instanceof GhostSlot) {
            ItemStack carried = this.getCarried();
            if (clickType == ClickType.PICKUP_ALL) {
                return;
            }
            if (clickType == ClickType.PICKUP) {
                if (button == 0) {
                    if (!carried.isEmpty() && slot.mayPlace(carried)) {
                        ItemStack ghostStack = carried.copy();
                        ghostStack.setCount(1);
                        slot.set(ghostStack);
                        return;
                    }
                    if (carried.isEmpty() && slot.hasItem()) {
                        return;
                    }
                    if (carried.isEmpty() && !slot.hasItem()) {
                        return;
                    }
                } else if (button == 1) {
                    slot.set(ItemStack.EMPTY);
                    return;
                }
            } else if (clickType == ClickType.QUICK_CRAFT) {
                if (!carried.isEmpty() && slot.mayPlace(carried)) {
                    ItemStack ghostStack = carried.copy();
                    ghostStack.setCount(1);
                    slot.set(ghostStack);
                }
                return;
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    public boolean stillValid(Player player) {
        return this.getTrowelStack().getItem() instanceof MechTrowelItem;
    }

    public TrowelData getTrowelData() {
        ItemStack currentStack = this.getTrowelStack();
        CompoundTag currentNBT = ((CustomData)currentStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (this.trowelData == null || !currentNBT.equals((Object)this.lastKnownNBT)) {
            this.trowelData = TrowelData.getOrCreate(currentStack);
            this.lastKnownNBT = currentNBT.copy();
        }
        return this.trowelData;
    }

    public ItemStack getTrowelStack() {
        return this.playerInventory.getItem(this.trowelSlot);
    }

    public void setVisibleRows(int rows) {
        this.visibleRows = rows;
        this.recreateSlots(0);
    }

    public void updateScrollOffset(int scrollOffset) {
        this.recreateSlots(scrollOffset);
    }

    private void recreateSlots(int scrollOffset) {
        int i;
        ArrayList<ItemStack> tempItems = new ArrayList<ItemStack>();
        for (i = 0; i < this.paletteSlots; ++i) {
            tempItems.add(this.paletteContainer.getItem(i).copy());
        }
        this.slots.clear();
        this.addScrolledPaletteSlots(scrollOffset);
        this.addPlayerInventory(this.playerInventory);
        for (i = 0; i < tempItems.size() && i < this.paletteSlots; ++i) {
            this.paletteContainer.setItem(i, (ItemStack)tempItems.get(i));
        }
    }

    private void addScrolledPaletteSlots(int scrollOffset) {
        int unitWidth = 23;
        int totalWidth = unitWidth * 7 + 36;
        int startX = (230 - totalWidth) / 2;
        int gridY = PaletteLayoutConstants.calculateGridY(0);
        for (int row = 0; row < this.paletteRows; ++row) {
            for (int col = 0; col < 7; ++col) {
                int y;
                int index = row * 7 + col;
                if (index >= this.paletteSlots) continue;
                int x = startX + col * (unitWidth + 6) + 1;
                if (row >= scrollOffset && row < scrollOffset + this.visibleRows) {
                    int visualRow = row - scrollOffset;
                    y = gridY + visualRow * 34 + 3 + 1;
                } else {
                    y = -1000;
                }
                this.addSlot(new GhostSlot((Container)this.paletteContainer, index, x, y));
            }
        }
    }

    public void syncContainerWithPalette() {
        this.isInitializing = true;
        this.trowelData = this.getTrowelData();
        this.paletteContainer.clearContent();
        PaletteData palette = this.trowelData.getActivePalette();
        if (palette != null) {
            ItemStack blockItem;
            List<PaletteData.WeightedBlock> blocks = palette.getBlocks();
            HashSet<PaletteData.WeightedBlock> placedBlocks = new HashSet<PaletteData.WeightedBlock>();
            for (PaletteData.WeightedBlock block : blocks) {
                int slotPos = block.getSlotPosition();
                if (slotPos < 0 || slotPos >= this.paletteSlots) continue;
                blockItem = new ItemStack((ItemLike)block.getState().getBlock());
                this.paletteContainer.setItem(slotPos, blockItem);
                placedBlocks.add(block);
            }
            int nextSlot = 0;
            for (PaletteData.WeightedBlock block : blocks) {
                if (placedBlocks.contains(block)) continue;
                while (nextSlot < this.paletteSlots && !this.paletteContainer.getItem(nextSlot).isEmpty()) {
                    ++nextSlot;
                }
                if (nextSlot >= this.paletteSlots) continue;
                blockItem = new ItemStack((ItemLike)block.getState().getBlock());
                this.paletteContainer.setItem(nextSlot, blockItem);
                block.setSlotPosition(nextSlot);
                ++nextSlot;
            }
            if (!this.player.level().isClientSide()) {
                this.trowelData.save(this.getTrowelStack());
            }
        }
        this.isInitializing = false;
        this.broadcastChanges();
    }

    public void updateGhostSlot(int slotIndex, ItemStack itemStack) {
        Item item;
        if (slotIndex < 0 || slotIndex >= this.slots.size()) {
            return;
        }
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!(slot instanceof GhostSlot)) {
            return;
        }
        slot.set(itemStack);
        TrowelData trowelData = this.getTrowelData();
        PaletteData palette = trowelData.getActivePalette();
        if (palette != null && slotIndex < this.paletteSlots && !itemStack.isEmpty() && (item = itemStack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState blockState = blockItem.getBlock().defaultBlockState();
            boolean blockExists = false;
            for (PaletteData.WeightedBlock weightedBlock : palette.getBlocks()) {
                if (!weightedBlock.getState().equals(blockState)) continue;
                blockExists = true;
                break;
            }
            if (!blockExists) {
                PaletteData.WeightedBlock newBlock = new PaletteData.WeightedBlock(blockState, 10.0f, false, slotIndex);
                palette.getBlocks().add(newBlock);
                PaletteBalancer.redistributeAfterBlockChange(palette);
                trowelData.save(this.getTrowelStack());
                this.player.getInventory().setChanged();
            }
        }
        this.broadcastChanges();
    }
}

