/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.events;

import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="mechtrowel")
public class ReachAttributeHandler {
    private static final ResourceLocation REACH_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"mechtrowel", (String)"reach_bonus");
    private static final Map<UUID, ItemStack> lastHeldItem = new HashMap<UUID, ItemStack>();

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        TrowelData data;
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        UUID playerUUID = player.getUUID();
        ItemStack previousItem = lastHeldItem.get(playerUUID);
        if (previousItem != null && ItemStack.matches((ItemStack)previousItem, (ItemStack)mainHand)) {
            return;
        }
        lastHeldItem.put(playerUUID, mainHand.copy());
        AttributeInstance reachAttribute = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE);
        if (reachAttribute == null) {
            return;
        }
        boolean holdingUpgradedTrowel = false;
        double reachBonus = 0.0;
        if (mainHand.getItem() instanceof MechTrowelItem && (data = TrowelData.getOrCreate(mainHand)).isReachUpgraded() && data.isReachActive()) {
            holdingUpgradedTrowel = true;
            reachBonus = data.getReachBonus();
        }
        AttributeModifier existingModifier = reachAttribute.getModifier(REACH_MODIFIER_ID);
        if (holdingUpgradedTrowel) {
            if (existingModifier == null || existingModifier.amount() != reachBonus) {
                if (existingModifier != null) {
                    reachAttribute.removeModifier(REACH_MODIFIER_ID);
                }
                AttributeModifier newModifier = new AttributeModifier(REACH_MODIFIER_ID, reachBonus, AttributeModifier.Operation.ADD_VALUE);
                reachAttribute.addTransientModifier(newModifier);
            }
        } else if (existingModifier != null) {
            reachAttribute.removeModifier(REACH_MODIFIER_ID);
        }
    }
}

