/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.create;

import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class CopycatBlockConfig {
    private static final String TAG_MATERIAL = "Material";
    private static final String TAG_LIT = "Lit";
    private static final String TAG_AXIS = "Axis";
    private BlockState material;
    private boolean lit;
    private AxisMode axisMode;

    public CopycatBlockConfig() {
        this.material = null;
        this.lit = false;
        this.axisMode = AxisMode.OFF;
    }

    public CopycatBlockConfig(BlockState material) {
        this.material = material;
        this.lit = false;
        this.axisMode = AxisMode.OFF;
    }

    public void load(CompoundTag tag) {
        if (tag.contains(TAG_MATERIAL)) {
            this.material = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound(TAG_MATERIAL));
        }
        this.lit = tag.getBoolean(TAG_LIT);
        if (tag.contains(TAG_AXIS)) {
            String axisName = tag.getString(TAG_AXIS);
            try {
                this.axisMode = AxisMode.valueOf(axisName);
            }
            catch (IllegalArgumentException e) {
                this.axisMode = AxisMode.OFF;
            }
        } else {
            this.axisMode = AxisMode.OFF;
        }
    }

    public void save(CompoundTag tag) {
        if (this.material != null) {
            tag.put(TAG_MATERIAL, (Tag)NbtUtils.writeBlockState((BlockState)this.material));
        }
        tag.putBoolean(TAG_LIT, this.lit);
        tag.putString(TAG_AXIS, this.axisMode.name());
    }

    public boolean isConfigured() {
        return this.material != null;
    }

    public BlockState getMaterial() {
        return this.material;
    }

    public void setMaterial(BlockState material) {
        this.material = material;
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
    }

    public AxisMode getAxisMode() {
        return this.axisMode;
    }

    public void setAxisMode(AxisMode axisMode) {
        this.axisMode = axisMode;
    }

    public boolean isUseAxis() {
        return this.axisMode != AxisMode.OFF;
    }

    public static enum AxisMode {
        OFF("Off"),
        X("X Axis"),
        Y("Y Axis"),
        Z("Z Axis");

        private final String displayName;

        private AxisMode(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Direction.Axis toAxis() {
            switch (this.ordinal()) {
                case 1: {
                    return Direction.Axis.X;
                }
                case 2: {
                    return Direction.Axis.Y;
                }
                case 3: {
                    return Direction.Axis.Z;
                }
            }
            return null;
        }

        public AxisMode next() {
            AxisMode[] values = AxisMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

