/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.network.TrowelPacket;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

public class RadialMenuScreen
extends Screen {
    private static final int PALETTES_PER_PAGE = 8;
    private static final float BASE_INNER_RADIUS = 60.0f;
    private static final float BASE_OUTER_RADIUS = 160.0f;
    private static final float BASE_CENTER_RADIUS = 45.0f;
    private static final int SEGMENTS = 64;
    private float innerRadius;
    private float outerRadius;
    private float centerRadius;
    private float scaleFactor = 1.0f;
    private boolean isCompactMode = false;
    private final TrowelData trowelData;
    private final List<PaletteData> sortedPalettes;
    private int currentPage = 0;
    private int totalPages;
    private int hoveredIndex = -1;
    private long openTime;
    private float animationProgress = 0.0f;
    private boolean isClosing = false;
    private final float[] segmentHoverProgress;
    private long lastFrameTime;
    private final List<SegmentInfo> segments = new ArrayList<SegmentInfo>();
    private static final int BACKGROUND_COLOR = -1442840576;
    private static final int SEGMENT_COLOR = 0x33FFFFFF;
    private static final int SEGMENT_HOVER_COLOR = 0x66FFFFFF;
    private static final int SEGMENT_ACTIVE_COLOR = -1711276033;
    private static final int CENTER_COLOR = 0x44FFFFFF;
    private static final int TEXT_COLOR = -1;
    private static final int DIVIDER_COLOR = 0x77FFFFFF;
    private static final int GLASS_BORDER_COLOR = -1426063361;
    private static final int BASE_PANEL_WIDTH = 100;
    private static final int BASE_PANEL_SPACING = 30;
    private static final int BASE_TOGGLE_HEIGHT = 30;
    private static final int BASE_TOGGLE_SPACING = 8;
    private float panelWidth;
    private float panelSpacing;
    private float toggleHeight;
    private float toggleSpacing;
    private final List<UpgradeToggleInfo> upgradeToggles = new ArrayList<UpgradeToggleInfo>();
    private final List<DirectionToggleInfo> directionToggles = new ArrayList<DirectionToggleInfo>();
    private final List<DirectionToggleInfo> verticalToggles = new ArrayList<DirectionToggleInfo>();
    private float directionRotationOffset = 0.0f;

    public RadialMenuScreen(TrowelData trowelData) {
        super((Component)Component.literal((String)"Radial Menu"));
        this.trowelData = trowelData;
        this.sortedPalettes = new ArrayList<PaletteData>(trowelData.getPalettes());
        this.sortedPalettes.sort(Comparator.comparingLong(PaletteData::getLastUsedTime).reversed());
        this.totalPages = (int)Math.ceil((double)this.sortedPalettes.size() / 8.0);
        if (this.totalPages == 0) {
            this.totalPages = 1;
        }
        this.segmentHoverProgress = new float[8];
        this.currentPage = 0;
        this.openTime = System.currentTimeMillis();
        this.lastFrameTime = System.nanoTime();
        if (Minecraft.getInstance().player != null) {
            float playerYaw = Minecraft.getInstance().player.getYRot() % 360.0f;
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
            }
            this.directionRotationOffset = 180.0f - playerYaw;
        }
    }

    protected void init() {
        super.init();
        int screenHeight = this.minecraft.getWindow().getGuiScaledHeight();
        int screenWidth = this.minecraft.getWindow().getGuiScaledWidth();
        int smallestDim = Math.min(screenHeight, screenWidth);
        if (smallestDim <= 320) {
            this.isCompactMode = true;
            this.scaleFactor = 0.6f;
        } else if (smallestDim <= 425) {
            this.isCompactMode = true;
            this.scaleFactor = 0.8f;
        } else {
            this.isCompactMode = false;
            this.scaleFactor = 1.0f;
        }
        this.innerRadius = 60.0f * this.scaleFactor;
        this.outerRadius = 160.0f * this.scaleFactor;
        this.centerRadius = 45.0f * this.scaleFactor;
        float panelScale = Math.max(this.scaleFactor, 0.8f);
        this.panelWidth = 100.0f * panelScale;
        this.panelSpacing = 30.0f * panelScale;
        this.toggleHeight = 30.0f * panelScale;
        this.toggleSpacing = 8.0f * panelScale;
        this.directionToggles.clear();
        this.directionToggles.add(new DirectionToggleInfo(Direction.NORTH, 225.0f, 315.0f));
        this.directionToggles.add(new DirectionToggleInfo(Direction.EAST, 315.0f, 45.0f));
        this.directionToggles.add(new DirectionToggleInfo(Direction.SOUTH, 45.0f, 135.0f));
        this.directionToggles.add(new DirectionToggleInfo(Direction.WEST, 135.0f, 225.0f));
        this.verticalToggles.clear();
        this.verticalToggles.add(new DirectionToggleInfo(Direction.UP, 180.0f, 360.0f));
        this.verticalToggles.add(new DirectionToggleInfo(Direction.DOWN, 0.0f, 180.0f));
        this.upgradeToggles.clear();
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        float panelX = centerX + this.outerRadius + this.panelSpacing;
        float currentY = centerY - this.calculatePanelHeight() / 2.0f;
        if (MechTrowel.Config.isReplaceModeEnabled()) {
            this.upgradeToggles.add(new UpgradeToggleInfo(UpgradeType.REPLACE_MODE, panelX, currentY, this.panelWidth, this.toggleHeight));
            currentY += this.toggleHeight + this.toggleSpacing * 2.0f;
        }
        if (this.trowelData.isChippedConversionEnabled()) {
            this.upgradeToggles.add(new UpgradeToggleInfo(UpgradeType.VARIANT_CONVERSION, panelX, currentY, this.panelWidth, this.toggleHeight));
            currentY += this.toggleHeight + this.toggleSpacing;
        }
        if (this.trowelData.isCapacityUpgraded()) {
            this.upgradeToggles.add(new UpgradeToggleInfo(UpgradeType.WAND_CAPACITY, panelX, currentY, this.panelWidth, this.toggleHeight));
            currentY += this.toggleHeight + this.toggleSpacing;
        }
        if (this.trowelData.isReachUpgraded()) {
            this.upgradeToggles.add(new UpgradeToggleInfo(UpgradeType.EXTENDED_REACH, panelX, currentY, this.panelWidth, this.toggleHeight));
        }
        this.currentPage = Math.max(0, Math.min(this.currentPage, this.totalPages - 1));
        this.segments.clear();
        int startIdx = this.currentPage * 8;
        int endIdx = Math.min(startIdx + 8, this.sortedPalettes.size());
        int segmentCount = Math.max(0, endIdx - startIdx);
        if (segmentCount > 0) {
            float angleStep = 45.0f;
            float startAngle = -90.0f - angleStep / 2.0f;
            for (int i = 0; i < 8; ++i) {
                float segStart;
                float segEnd = segStart + angleStep;
                for (segStart = startAngle + (float)i * angleStep; segStart < 0.0f; segStart += 360.0f) {
                }
                while (segEnd < 0.0f) {
                    segEnd += 360.0f;
                }
                while (segStart >= 360.0f) {
                    segStart -= 360.0f;
                }
                while (segEnd >= 360.0f) {
                    segEnd -= 360.0f;
                }
                this.segments.add(new SegmentInfo(segStart, segEnd, i));
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.isClosing) {
            return;
        }
        long currentTime = System.nanoTime();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = currentTime;
        this.animationProgress = Math.min(1.0f, (float)(System.currentTimeMillis() - this.openTime) / 200.0f);
        float easedProgress = this.easeOutQuart(this.animationProgress);
        this.drawVignetteBackground(graphics);
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        this.hoveredIndex = -1;
        for (SegmentInfo segment : this.segments) {
            if (!segment.contains(mouseX, mouseY, centerX, centerY, this.innerRadius, this.outerRadius)) continue;
            this.hoveredIndex = segment.index;
            break;
        }
        for (int i = 0; i < this.segmentHoverProgress.length; ++i) {
            float target = i == this.hoveredIndex ? 1.0f : 0.0f;
            this.segmentHoverProgress[i] = Mth.lerp((float)(deltaTime * 10.0f), (float)this.segmentHoverProgress[i], (float)target);
        }
        int startIdx = this.currentPage * 8;
        for (int i = 0; i < this.segments.size(); ++i) {
            SegmentInfo segment = this.segments.get(i);
            int paletteIdx = startIdx + i;
            if (paletteIdx < this.sortedPalettes.size()) {
                float normalizedStart;
                PaletteData palette = this.sortedPalettes.get(paletteIdx);
                boolean isActive = this.trowelData.getActivePalette() == palette;
                float innerR = this.innerRadius * easedProgress;
                float outerR = this.outerRadius * easedProgress;
                float hoverOffset = this.segmentHoverProgress[i] * 15.0f;
                this.drawSegment(graphics, centerX, centerY, innerR, outerR + hoverOffset, segment.startAngle, segment.endAngle, this.getSegmentColor(isActive, i == this.hoveredIndex, this.segmentHoverProgress[i]), easedProgress);
                if (!(this.animationProgress > 0.3f)) continue;
                float contentAlpha = (this.animationProgress - 0.3f) / 0.7f;
                float normalizedEnd = segment.endAngle;
                for (normalizedStart = segment.startAngle; normalizedStart < 0.0f; normalizedStart += 360.0f) {
                }
                while (normalizedEnd < 0.0f) {
                    normalizedEnd += 360.0f;
                }
                while (normalizedStart >= 360.0f) {
                    normalizedStart -= 360.0f;
                }
                while (normalizedEnd >= 360.0f) {
                    normalizedEnd -= 360.0f;
                }
                this.drawSegmentContent(graphics, palette, centerX, centerY, normalizedStart, normalizedEnd, contentAlpha);
                continue;
            }
            float innerR = this.innerRadius * easedProgress;
            float outerR = this.outerRadius * easedProgress;
            this.drawSegment(graphics, centerX, centerY, innerR, outerR, segment.startAngle, segment.endAngle, 0x1AFFFFFF, easedProgress);
        }
        float vertInnerRadius = this.centerRadius * 0.7f;
        float vertOuterRadius = this.centerRadius * 0.93f;
        for (DirectionToggleInfo toggle : this.verticalToggles) {
            boolean isHovered = this.containsInWedge(mouseX, mouseY, centerX, centerY, vertInnerRadius, vertOuterRadius, toggle.startAngle, toggle.endAngle);
            float target = isHovered ? 1.0f : 0.0f;
            toggle.hoverProgress = Mth.lerp((float)(deltaTime * 10.0f), (float)toggle.hoverProgress, (float)target);
        }
        this.drawCenterCircle(graphics, centerX, centerY, easedProgress);
        if (this.animationProgress > 0.4f) {
            this.drawDirectionToggles(graphics, mouseX, mouseY, easedProgress, deltaTime);
        }
        if (this.totalPages > 1 && this.animationProgress > 0.5f) {
            this.drawPageIndicator(graphics, centerX, centerY);
        }
        if (!this.upgradeToggles.isEmpty() && this.animationProgress > 0.3f) {
            this.drawUpgradePanel(graphics, mouseX, mouseY, easedProgress);
        }
    }

    private void drawVignetteBackground(GuiGraphics graphics) {
        graphics.fill(0, 0, this.width, this.height, -1442840576);
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        float maxDist = (float)Math.sqrt(centerX * centerX + centerY * centerY);
        for (int i = 10; i > 0; --i) {
            float radius = maxDist * ((float)i / 10.0f);
            int alpha = (int)(30.0f * (1.0f - (float)i / 10.0f));
            this.drawFilledCircle(graphics, centerX, centerY, radius, alpha << 24);
        }
    }

    private void drawSegment(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float startAngle, float endAngle, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(8, (int)(angleRange / 5.0f));
        float angleStep = angleRange / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            float angle = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = centerX + cos * innerRadius;
            float y1 = centerY + sin * innerRadius;
            float x2 = centerX + cos * outerRadius;
            float y2 = centerY + sin * outerRadius;
            if (i <= 0) continue;
            float prevAngle = (float)Math.toRadians(startAngle + (float)(i - 1) * angleStep);
            float prevCos = (float)Math.cos(prevAngle);
            float prevSin = (float)Math.sin(prevAngle);
            float px1 = centerX + prevCos * innerRadius;
            float py1 = centerY + prevSin * innerRadius;
            float px2 = centerX + prevCos * outerRadius;
            float py2 = centerY + prevSin * outerRadius;
            buffer.addVertex(matrix, px1, py1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        this.drawSegmentBorder(graphics, centerX, centerY, innerRadius, outerRadius, startAngle, endAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerRadius, outerRadius, startAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerRadius, outerRadius, endAngle, alpha);
        RenderSystem.disableBlend();
    }

    private void drawSegmentDivider(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float angle, float alpha) {
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float x1 = centerX + cos * innerRadius;
        float y1 = centerY + sin * innerRadius;
        float x2 = centerX + cos * outerRadius;
        float y2 = centerY + sin * outerRadius;
        int dividerAlpha = (int)(119.0f * alpha);
        int color = dividerAlpha << 24 | 0xFFFFFF;
        this.drawLine(graphics, x1, y1, x2, y2, color);
    }

    private void drawSegmentBorder(GuiGraphics graphics, float centerX, float centerY, float innerRadius, float outerRadius, float startAngle, float endAngle, float alpha) {
        float y2;
        float x2;
        float y1;
        float x1;
        float angle2;
        float angle1;
        int i;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        int borderAlpha = (int)(170.0f * alpha * 0.5f);
        int r = 255;
        int g = 255;
        int b = 255;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(4, (int)(angleRange / 10.0f));
        float angleStep = angleRange / (float)steps;
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            x1 = centerX + (float)Math.cos(angle1) * innerRadius;
            y1 = centerY + (float)Math.sin(angle1) * innerRadius;
            x2 = centerX + (float)Math.cos(angle2) * innerRadius;
            y2 = centerY + (float)Math.sin(angle2) * innerRadius;
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, borderAlpha);
        }
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            x1 = centerX + (float)Math.cos(angle1) * outerRadius;
            y1 = centerY + (float)Math.sin(angle1) * outerRadius;
            x2 = centerX + (float)Math.cos(angle2) * outerRadius;
            y2 = centerY + (float)Math.sin(angle2) * outerRadius;
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, borderAlpha);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawLine(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length > 0.0f) {
            float thickness = 1.5f;
            float perpX = -dy / length * thickness / 2.0f;
            float perpY = dx / length * thickness / 2.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f matrix = graphics.pose().last().pose();
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.addVertex(matrix, x1 - perpX, y1 - perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1 + perpX, y1 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 + perpX, y2 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 - perpX, y2 - perpY, 0.0f).setColor(r, g, b, a);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }

    private void drawSegmentContent(GuiGraphics graphics, PaletteData palette, float centerX, float centerY, float startAngle, float endAngle, float alpha) {
        boolean isHorizontal;
        float midAngle;
        if (startAngle > endAngle) {
            midAngle = (startAngle + endAngle + 360.0f) / 2.0f;
            if (midAngle >= 360.0f) {
                midAngle -= 360.0f;
            }
        } else {
            midAngle = (startAngle + endAngle) / 2.0f;
        }
        float midRadius = (this.innerRadius + this.outerRadius) / 2.0f;
        float angle = (float)Math.toRadians(midAngle);
        float contentX = centerX + (float)Math.cos(angle) * midRadius;
        float contentY = centerY + (float)Math.sin(angle) * midRadius;
        float angularSpan = endAngle >= startAngle ? endAngle - startAngle : endAngle + 360.0f - startAngle;
        float halfAngleRad = (float)Math.toRadians(angularSpan / 2.0f);
        float arcWidth = 2.0f * midRadius * (float)Math.sin(halfAngleRad);
        float maxTextWidth = arcWidth * 0.85f;
        int textAlpha = (int)(255.0f * alpha);
        int color = textAlpha << 24 | 0xFFFFFF;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        boolean bl = isHorizontal = (double)midAngle >= 67.5 && (double)midAngle <= 112.5 || (double)midAngle >= 247.5 && (double)midAngle <= 292.5;
        if (palette.getIconBlock() != null) {
            ItemStack iconStack = new ItemStack((ItemLike)palette.getIconBlock().getBlock());
            graphics.pose().pushPose();
            graphics.pose().translate(contentX - 12.0f, contentY - 16.0f, 0.0f);
            float iconScale = this.isCompactMode ? 1.2f : 1.5f;
            graphics.pose().scale(iconScale, iconScale, iconScale);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            graphics.renderItem(iconStack, 0, 0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.pose().popPose();
            String paletteName = palette.getName();
            float textScale = this.isCompactMode ? 0.7f : 0.85f;
            String truncatedName = this.truncateName(paletteName, maxTextWidth / textScale);
            MutableComponent name = Component.literal((String)truncatedName);
            graphics.pose().pushPose();
            graphics.pose().translate(contentX, contentY + 10.0f, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
            graphics.pose().popPose();
        } else {
            String paletteName = palette.getName();
            float centerTextScale = this.isCompactMode ? 0.9f : 1.1f;
            String truncatedName = this.truncateName(paletteName, maxTextWidth / centerTextScale);
            MutableComponent name = Component.literal((String)truncatedName);
            graphics.pose().pushPose();
            graphics.pose().translate(contentX, contentY - 4.0f, 0.0f);
            graphics.pose().scale(centerTextScale, centerTextScale, centerTextScale);
            graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
            graphics.pose().popPose();
        }
        RenderSystem.disableBlend();
    }

    private void drawCenterCircle(GuiGraphics graphics, float centerX, float centerY, float progress) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float radius = this.centerRadius * progress;
        this.drawFilledCircle(graphics, centerX, centerY, radius, 0x44FFFFFF);
        if (progress > 0.5f) {
            float vertAlpha = (progress - 0.5f) / 0.5f;
            this.drawVerticalToggles(graphics, centerX, centerY, radius, vertAlpha);
        }
        if (progress > 0.7f && this.trowelData.getActivePalette() != null) {
            float contentAlpha = (progress - 0.7f) / 0.3f;
            int color = (int)(255.0f * contentAlpha) << 24 | 0xFFFFFF;
            PaletteData active = this.trowelData.getActivePalette();
            float availableWidth = radius * 0.7f * 2.0f * 0.85f;
            if (active.getIconBlock() != null) {
                ItemStack iconStack = new ItemStack((ItemLike)active.getIconBlock().getBlock());
                graphics.pose().pushPose();
                float iconScale = this.isCompactMode ? 1.5f : 1.8f;
                float iconOffset = 8.0f * iconScale;
                graphics.pose().translate(centerX - iconOffset, centerY - iconOffset, 0.0f);
                graphics.pose().scale(iconScale, iconScale, iconScale);
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)contentAlpha);
                graphics.renderItem(iconStack, 0, 0);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.pose().popPose();
            } else {
                float textScale = this.isCompactMode ? 0.8f : 0.9f;
                String truncatedName = this.truncateName(active.getName(), availableWidth / textScale);
                MutableComponent name = Component.literal((String)truncatedName);
                graphics.pose().pushPose();
                graphics.pose().translate(centerX, centerY - 4.0f, 0.0f);
                graphics.pose().scale(textScale, textScale, textScale);
                graphics.drawCenteredString(this.font, (Component)name, 0, 0, color);
                graphics.pose().popPose();
            }
        }
        if (this.totalPages > 1 && progress > 0.5f) {
            float navAlpha = (progress - 0.5f) * 2.0f;
            this.drawNavigationButtons(graphics, centerX, centerY, navAlpha);
        }
        RenderSystem.disableBlend();
    }

    private void drawDirectionToggles(GuiGraphics graphics, int mouseX, int mouseY, float progress, float deltaTime) {
        float contentAlpha = (this.animationProgress - 0.4f) / 0.6f;
        if (contentAlpha <= 0.0f) {
            return;
        }
        float screenCenterX = (float)this.width / 2.0f;
        float screenCenterY = (float)this.height / 2.0f;
        float dirInnerRadius = (this.centerRadius - 3.0f * this.scaleFactor) * progress;
        float dirOuterRadius = this.innerRadius * progress;
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        for (DirectionToggleInfo toggle : this.directionToggles) {
            float rotatedStart = this.normalizeAngle(toggle.startAngle + this.directionRotationOffset);
            float rotatedEnd = this.normalizeAngle(toggle.endAngle + this.directionRotationOffset);
            toggle.isHovered = this.containsInWedge(mouseX, mouseY, screenCenterX, screenCenterY, dirInnerRadius, dirOuterRadius, rotatedStart, rotatedEnd);
            float target = toggle.isHovered ? 1.0f : 0.0f;
            toggle.hoverProgress = Mth.lerp((float)(deltaTime * 10.0f), (float)toggle.hoverProgress, (float)target);
        }
        for (DirectionToggleInfo toggle : this.directionToggles) {
            float midAngle;
            int segmentColor;
            boolean isLocked = rotationData.isDirectionLocked(toggle.direction);
            float rotatedStart = this.normalizeAngle(toggle.startAngle + this.directionRotationOffset);
            float rotatedEnd = this.normalizeAngle(toggle.endAngle + this.directionRotationOffset);
            if (isLocked) {
                alpha = (int)(120.0f * contentAlpha);
                segmentColor = alpha << 24 | 0x4CAF50;
            } else {
                alpha = (int)(40.0f * contentAlpha);
                segmentColor = alpha << 24 | 0xFFFFFF;
            }
            if (toggle.hoverProgress > 0.0f) {
                segmentColor = this.lerpColor(segmentColor, (int)(80.0f * contentAlpha) << 24 | 0xFFFFFF, toggle.hoverProgress * 0.5f);
            }
            this.drawSegment(graphics, screenCenterX, screenCenterY, dirInnerRadius, dirOuterRadius, rotatedStart, rotatedEnd, segmentColor, contentAlpha);
            if (rotatedStart > rotatedEnd) {
                midAngle = (rotatedStart + rotatedEnd + 360.0f) / 2.0f;
                if (midAngle >= 360.0f) {
                    midAngle -= 360.0f;
                }
            } else {
                midAngle = (rotatedStart + rotatedEnd) / 2.0f;
            }
            float midRadius = (dirInnerRadius + dirOuterRadius) / 2.0f;
            float angle = (float)Math.toRadians(midAngle);
            float textX = screenCenterX + (float)Math.cos(angle) * midRadius;
            float textY = screenCenterY + (float)Math.sin(angle) * midRadius;
            String letter = this.getDirectionLetter(toggle.direction);
            int textAlpha = (int)(255.0f * contentAlpha);
            int textColor = isLocked ? textAlpha << 24 | 0xFFFFFF : textAlpha << 24 | 0xBBBBBB;
            graphics.pose().pushPose();
            float textScale = this.isCompactMode ? 0.85f : 1.1f;
            graphics.pose().translate(textX, textY - 4.0f * textScale, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, letter, 0, 0, textColor);
            graphics.pose().popPose();
        }
    }

    private void drawVerticalToggles(GuiGraphics graphics, float centerX, float centerY, float radius, float alpha) {
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        float innerR = radius * 0.7f;
        float outerR = radius * 0.93f;
        for (DirectionToggleInfo toggle : this.verticalToggles) {
            int segmentColor;
            boolean isLocked = rotationData.isDirectionLocked(toggle.direction);
            if (isLocked) {
                a = (int)(100.0f * alpha);
                segmentColor = a << 24 | 0x4CAF50;
            } else {
                a = (int)(30.0f * alpha);
                segmentColor = a << 24 | 0xFFFFFF;
            }
            if (toggle.hoverProgress > 0.0f) {
                segmentColor = this.lerpColor(segmentColor, (int)(60.0f * alpha) << 24 | 0xFFFFFF, toggle.hoverProgress * 0.5f);
            }
            this.drawSegment(graphics, centerX, centerY, innerR, outerR, toggle.startAngle, toggle.endAngle, segmentColor, alpha);
            float midAngle = toggle.direction == Direction.UP ? 270.0f : 90.0f;
            float textRadius = (innerR + outerR) / 2.0f;
            float angle = (float)Math.toRadians(midAngle);
            float textX = centerX + (float)Math.cos(angle) * textRadius;
            float textY = centerY + (float)Math.sin(angle) * textRadius;
            String letter = this.getDirectionLetter(toggle.direction);
            int textAlpha = (int)(255.0f * alpha);
            int textColor = isLocked ? textAlpha << 24 | 0xFFFFFF : textAlpha << 24 | 0xBBBBBB;
            graphics.pose().pushPose();
            float textScale = this.isCompactMode ? 0.7f : 0.9f;
            graphics.pose().translate(textX, textY - 4.0f * textScale, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, letter, 0, 0, textColor);
            graphics.pose().popPose();
        }
    }

    private float normalizeAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private boolean containsInWedge(double mouseX, double mouseY, float screenCenterX, float screenCenterY, float innerR, float outerR, float startAngle, float endAngle) {
        float dx = (float)(mouseX - (double)screenCenterX);
        float dy = (float)(mouseY - (double)screenCenterY);
        float distance = (float)Math.sqrt(dx * dx + dy * dy);
        if (distance < innerR || distance > outerR) {
            return false;
        }
        float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        if (startAngle > endAngle) {
            return angle >= startAngle || angle <= endAngle;
        }
        return angle >= startAngle && angle <= endAngle;
    }

    private String getDirectionLetter(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> "N";
            case Direction.SOUTH -> "S";
            case Direction.EAST -> "E";
            case Direction.WEST -> "W";
            case Direction.UP -> "U";
            case Direction.DOWN -> "D";
        };
    }

    private void drawNavigationButtons(GuiGraphics graphics, float centerX, float centerY, float alpha) {
    }

    private void drawCircleBorder(GuiGraphics graphics, float centerX, float centerY, float radius, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.lineWidth((float)2.0f);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha * 0.7f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / 64.0);
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            buffer.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFilledCircle(GuiGraphics graphics, float centerX, float centerY, float radius, int color) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.addVertex(matrix, centerX, centerY, 0.0f).setColor(r, g, b, a);
        for (int i = 0; i <= 64; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / 64.0);
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            buffer.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawPageIndicator(GuiGraphics graphics, float centerX, float centerY) {
        String pageText = String.format("Page %d/%d", this.currentPage + 1, this.totalPages);
        float fadeAlpha = (this.animationProgress - 0.5f) * 2.0f;
        int textAlpha = (int)(255.0f * fadeAlpha);
        if (this.isCompactMode) {
            float navY;
            float navX;
            float textScale = 0.8f;
            float arrowScale = 1.0f;
            int baseTextWidth = this.font.width(pageText);
            float scaledTextWidth = (float)baseTextWidth * textScale;
            float spacing = 3.0f * this.scaleFactor;
            int arrowWidth = (int)((float)this.font.width("<") * arrowScale);
            float totalWidth = (float)arrowWidth + spacing + scaledTextWidth + spacing + (float)arrowWidth;
            if (this.scaleFactor <= 0.6f) {
                gap = 10.0f;
                navX = centerX;
                navY = centerY + this.outerRadius + gap;
            } else {
                gap = 18.0f;
                navX = centerX;
                navY = centerY + this.outerRadius + gap;
            }
            float startX = navX - totalWidth / 2.0f;
            if (this.currentPage > 0) {
                graphics.pose().pushPose();
                graphics.pose().translate(startX + (float)arrowWidth / 2.0f - 2.0f, navY - 1.0f, 0.0f);
                graphics.pose().scale(arrowScale, arrowScale, arrowScale);
                graphics.drawCenteredString(this.font, "<", 0, 0, textAlpha << 24 | 0xFFFFFF);
                graphics.pose().popPose();
            }
            graphics.pose().pushPose();
            graphics.pose().translate(navX, navY, 0.0f);
            graphics.pose().scale(textScale, textScale, textScale);
            graphics.drawCenteredString(this.font, pageText, 0, 0, textAlpha << 24 | 0xFFFFFF);
            graphics.pose().popPose();
            if (this.currentPage < this.totalPages - 1) {
                graphics.pose().pushPose();
                graphics.pose().translate(startX + (float)arrowWidth + spacing + scaledTextWidth + spacing + (float)arrowWidth / 2.0f + 2.0f, navY - 1.0f, 0.0f);
                graphics.pose().scale(arrowScale, arrowScale, arrowScale);
                graphics.drawCenteredString(this.font, ">", 0, 0, textAlpha << 24 | 0xFFFFFF);
                graphics.pose().popPose();
            }
        } else {
            float textY = centerY + this.outerRadius + 35.0f * this.scaleFactor;
            float arrowScale = 1.2f;
            int baseTextWidth = this.font.width(pageText);
            float spacing = 4.0f;
            int arrowWidth = (int)((float)this.font.width("<") * arrowScale);
            float totalWidth = (float)arrowWidth + spacing + (float)baseTextWidth + spacing + (float)arrowWidth;
            float startX = centerX - totalWidth / 2.0f;
            if (this.currentPage > 0) {
                graphics.pose().pushPose();
                graphics.pose().translate(startX + (float)arrowWidth / 2.0f - 3.0f, textY - 1.0f, 0.0f);
                graphics.pose().scale(arrowScale, arrowScale, arrowScale);
                graphics.drawCenteredString(this.font, "<", 0, 0, textAlpha << 24 | 0xFFFFFF);
                graphics.pose().popPose();
            }
            graphics.drawCenteredString(this.font, pageText, (int)centerX, (int)textY, textAlpha << 24 | 0xFFFFFF);
            if (this.currentPage < this.totalPages - 1) {
                graphics.pose().pushPose();
                graphics.pose().translate(startX + (float)arrowWidth + spacing + (float)baseTextWidth + spacing + (float)arrowWidth / 2.0f + 3.0f, textY - 1.0f, 0.0f);
                graphics.pose().scale(arrowScale, arrowScale, arrowScale);
                graphics.drawCenteredString(this.font, ">", 0, 0, textAlpha << 24 | 0xFFFFFF);
                graphics.pose().popPose();
            }
        }
    }

    private void drawPillBorder(GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.fill(x + 2, y, x + width - 2, y + 1, color);
        graphics.fill(x + 2, y + height - 1, x + width - 2, y + height, color);
        graphics.fill(x, y + 2, x + 1, y + height - 2, color);
        graphics.fill(x + width - 1, y + 2, x + width, y + height - 2, color);
        graphics.fill(x + 1, y + 1, x + 2, y + 2, color);
        graphics.fill(x + width - 2, y + 1, x + width - 1, y + 2, color);
        graphics.fill(x + 1, y + height - 2, x + 2, y + height - 1, color);
        graphics.fill(x + width - 2, y + height - 2, x + width - 1, y + height - 1, color);
    }

    private String truncateName(String name, float maxWidth) {
        if ((float)this.font.width(name) <= maxWidth) {
            return name;
        }
        String ellipsis = "...";
        int ellipsisWidth = this.font.width(ellipsis);
        int left = 0;
        int right = name.length();
        int bestFit = 0;
        while (left <= right) {
            int mid = (left + right) / 2;
            String truncated = name.substring(0, mid);
            if ((float)(this.font.width(truncated) + ellipsisWidth) <= maxWidth) {
                bestFit = mid;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return bestFit > 0 ? name.substring(0, bestFit) + ellipsis : ellipsis;
    }

    private int getSegmentColor(boolean isActive, boolean isHovered, float hoverProgress) {
        if (isActive) {
            int baseAlpha = 153;
            int targetAlpha = Math.min(255, baseAlpha + (int)(30.0f * hoverProgress));
            return targetAlpha << 24 | 0xFFFFFF;
        }
        if (isHovered) {
            return this.lerpColor(0x33FFFFFF, 0x66FFFFFF, hoverProgress);
        }
        return 0x33FFFFFF;
    }

    private int lerpColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)Mth.lerp((float)t, (float)a1, (float)a2);
        int r = (int)Mth.lerp((float)t, (float)r1, (float)r2);
        int g = (int)Mth.lerp((float)t, (float)g1, (float)g2);
        int b = (int)Mth.lerp((float)t, (float)b1, (float)b2);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int lightenColor(int color, float amount) {
        int a = color >> 24 & 0xFF;
        int r = Math.min(255, (int)((float)(color >> 16 & 0xFF) * (1.0f + amount)));
        int g = Math.min(255, (int)((float)(color >> 8 & 0xFF) * (1.0f + amount)));
        int b = Math.min(255, (int)((float)(color & 0xFF) * (1.0f + amount)));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private float easeOutQuart(float t) {
        return 1.0f - (float)Math.pow(1.0f - t, 4.0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isClosing) {
            return false;
        }
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        if (this.totalPages > 1) {
            String pageText = String.format("Page %d/%d", this.currentPage + 1, this.totalPages);
            int baseTextWidth = this.font.width(pageText);
            if (this.isCompactMode) {
                float rightButtonX;
                float dy;
                float leftButtonX;
                float dx;
                float distance;
                float navY;
                float navX;
                float textScale = 0.8f;
                float arrowScale = 1.0f;
                float scaledTextWidth = (float)baseTextWidth * textScale;
                spacing = 3.0f * this.scaleFactor;
                arrowWidth = (int)((float)this.font.width("<") * arrowScale);
                hitRadius = (float)arrowWidth * 0.8f;
                totalWidth = (float)arrowWidth + spacing + scaledTextWidth + spacing + (float)arrowWidth;
                if (this.scaleFactor <= 0.6f) {
                    gap = 10.0f;
                    navX = centerX;
                    navY = centerY + this.outerRadius + gap;
                } else {
                    gap = 18.0f;
                    navX = centerX;
                    navY = centerY + this.outerRadius + gap;
                }
                float startX = navX - totalWidth / 2.0f;
                Objects.requireNonNull(this.font);
                float buttonY = navY + 9.0f / 2.0f;
                if (this.currentPage > 0 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(leftButtonX = startX + (float)arrowWidth / 2.0f - 2.0f))) * dx + (dy = (float)(mouseY - (double)buttonY)) * dy)) <= hitRadius) {
                    --this.currentPage;
                    this.init();
                    return true;
                }
                if (this.currentPage < this.totalPages - 1 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(rightButtonX = startX + (float)arrowWidth + spacing + scaledTextWidth + spacing + (float)arrowWidth / 2.0f + 2.0f))) * dx + (dy = (float)(mouseY - (double)buttonY)) * dy)) <= hitRadius) {
                    ++this.currentPage;
                    this.init();
                    return true;
                }
            } else {
                float rightButtonX;
                float dy;
                float leftButtonX;
                float dx;
                float distance;
                float textY = centerY + this.outerRadius + 35.0f * this.scaleFactor;
                Objects.requireNonNull(this.font);
                float buttonY = textY + 9.0f / 2.0f;
                float arrowScale = 1.2f;
                spacing = 4.0f;
                arrowWidth = (int)((float)this.font.width("<") * arrowScale);
                hitRadius = (float)arrowWidth * 0.8f;
                totalWidth = (float)arrowWidth + spacing + (float)baseTextWidth + spacing + (float)arrowWidth;
                float startX = centerX - totalWidth / 2.0f;
                if (this.currentPage > 0 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(leftButtonX = startX + (float)arrowWidth / 2.0f - 3.0f))) * dx + (dy = (float)(mouseY - (double)buttonY)) * dy)) <= hitRadius) {
                    --this.currentPage;
                    this.init();
                    return true;
                }
                if (this.currentPage < this.totalPages - 1 && (distance = (float)Math.sqrt((dx = (float)(mouseX - (double)(rightButtonX = startX + (float)arrowWidth + spacing + (float)baseTextWidth + spacing + (float)arrowWidth / 2.0f + 3.0f))) * dx + (dy = (float)(mouseY - (double)buttonY)) * dy)) <= hitRadius) {
                    ++this.currentPage;
                    this.init();
                    return true;
                }
            }
        }
        float dx = (float)(mouseX - (double)centerX);
        float dy = (float)(mouseY - (double)centerY);
        float distFromCenter = (float)Math.sqrt(dx * dx + dy * dy);
        float vertInnerRadius = this.centerRadius * 0.7f;
        float vertOuterRadius = this.centerRadius * 0.93f;
        if (distFromCenter >= vertInnerRadius && distFromCenter < vertOuterRadius) {
            for (DirectionToggleInfo toggle : this.verticalToggles) {
                if (!this.containsInWedge(mouseX, mouseY, centerX, centerY, vertInnerRadius, vertOuterRadius, toggle.startAngle, toggle.endAngle)) continue;
                this.toggleVerticalDirection(toggle.direction);
                return true;
            }
        }
        if (distFromCenter < vertInnerRadius) {
            this.resetGlobalRotationLocks();
            return true;
        }
        float dirInnerRadius = this.centerRadius - 3.0f * this.scaleFactor;
        float dirOuterRadius = this.innerRadius;
        for (DirectionToggleInfo toggle : this.directionToggles) {
            float rotatedEnd;
            float rotatedStart = this.normalizeAngle(toggle.startAngle + this.directionRotationOffset);
            if (!this.containsInWedge(mouseX, mouseY, centerX, centerY, dirInnerRadius, dirOuterRadius, rotatedStart, rotatedEnd = this.normalizeAngle(toggle.endAngle + this.directionRotationOffset))) continue;
            this.toggleDirection(toggle.direction);
            return true;
        }
        for (UpgradeToggleInfo toggle : this.upgradeToggles) {
            if (!toggle.contains(mouseX, mouseY)) continue;
            this.toggleUpgrade(toggle.type);
            return true;
        }
        for (SegmentInfo segment : this.segments) {
            if (!segment.contains(mouseX, mouseY, centerX, centerY, this.innerRadius, this.outerRadius)) continue;
            this.selectPalette(segment.index);
            return true;
        }
        return false;
    }

    private void selectPalette(int segmentIndex) {
        if (this.isClosing) {
            return;
        }
        int paletteIndex = this.currentPage * 8 + segmentIndex;
        if (paletteIndex >= 0 && paletteIndex < this.sortedPalettes.size()) {
            PaletteData selectedPalette = this.sortedPalettes.get(paletteIndex);
            int actualIndex = this.trowelData.getPalettes().indexOf(selectedPalette);
            if (actualIndex >= 0) {
                this.isClosing = true;
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)selectedPalette.getName()), false);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, actualIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.onClose();
            }
        }
    }

    public void onClose() {
        int paletteIndex;
        if (this.isClosing) {
            Minecraft.getInstance().setScreen(null);
            return;
        }
        this.isClosing = true;
        if (this.hoveredIndex >= 0 && this.hoveredIndex < this.segments.size() && (paletteIndex = this.currentPage * 8 + this.hoveredIndex) >= 0 && paletteIndex < this.sortedPalettes.size()) {
            PaletteData selectedPalette = this.sortedPalettes.get(paletteIndex);
            int actualIndex = this.trowelData.getPalettes().indexOf(selectedPalette);
            if (actualIndex >= 0) {
                Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)selectedPalette.getName()), false);
                PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SWITCH_PALETTE, actualIndex, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        Minecraft.getInstance().setScreen(null);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.isClosing = true;
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        if (keyCode == 263 && this.currentPage > 0) {
            --this.currentPage;
            this.init();
            return true;
        }
        if (keyCode == 262 && this.currentPage < this.totalPages - 1) {
            ++this.currentPage;
            this.init();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private float calculatePanelHeight() {
        int toggleCount = 0;
        if (this.trowelData.isChippedConversionEnabled()) {
            ++toggleCount;
        }
        if (this.trowelData.isCapacityUpgraded()) {
            ++toggleCount;
        }
        if (this.trowelData.isReachUpgraded()) {
            ++toggleCount;
        }
        if (MechTrowel.Config.isReplaceModeEnabled()) {
            ++toggleCount;
        }
        if (toggleCount == 0) {
            return 0.0f;
        }
        return (float)toggleCount * this.toggleHeight + (float)(toggleCount - 1) * this.toggleSpacing;
    }

    private boolean getUpgradeState(UpgradeType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.trowelData.isChippedConversionActive();
            case 1 -> this.trowelData.isCapacityActive();
            case 2 -> this.trowelData.isReachActive();
            case 3 -> this.trowelData.isReplaceMode();
        };
    }

    private Component getUpgradeLabel(UpgradeType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Component.translatable((String)"gui.mechtrowel.upgrade.variant");
            case 1 -> Component.translatable((String)"gui.mechtrowel.upgrade.capacity");
            case 2 -> Component.translatable((String)"gui.mechtrowel.upgrade.reach");
            case 3 -> Component.translatable((String)"gui.mechtrowel.upgrade.replace");
        };
    }

    private void drawUpgradePanel(GuiGraphics graphics, int mouseX, int mouseY, float alpha) {
        if (this.upgradeToggles.isEmpty()) {
            return;
        }
        float contentAlpha = (this.animationProgress - 0.3f) / 0.7f;
        if (contentAlpha <= 0.0f) {
            return;
        }
        UpgradeToggleInfo firstUpgrade = null;
        UpgradeToggleInfo lastUpgrade = null;
        for (UpgradeToggleInfo toggle : this.upgradeToggles) {
            if (toggle.type == UpgradeType.REPLACE_MODE) continue;
            if (firstUpgrade == null) {
                firstUpgrade = toggle;
            }
            lastUpgrade = toggle;
        }
        if (firstUpgrade != null && lastUpgrade != null) {
            int padding = 4;
            int bgX = (int)firstUpgrade.x - padding;
            int bgY = (int)firstUpgrade.y - padding;
            int bgWidth = (int)firstUpgrade.width + padding * 2;
            int bgHeight = (int)(lastUpgrade.y + lastUpgrade.height - firstUpgrade.y) + padding * 2;
            int bgAlpha = (int)(30.0f * contentAlpha);
            int bgColor = bgAlpha << 24 | 0xFFFFFF;
            graphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, bgColor);
            int borderAlpha = (int)(120.0f * contentAlpha);
            int borderColor = borderAlpha << 24 | 0xFFFFFF;
            graphics.hLine(bgX, bgX + bgWidth - 1, bgY, borderColor);
            graphics.hLine(bgX, bgX + bgWidth - 1, bgY + bgHeight - 1, borderColor);
            graphics.vLine(bgX, bgY, bgY + bgHeight - 1, borderColor);
            graphics.vLine(bgX + bgWidth - 1, bgY, bgY + bgHeight - 1, borderColor);
        }
        long currentTime = System.nanoTime();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1.0E9f;
        for (UpgradeToggleInfo toggle : this.upgradeToggles) {
            toggle.isHovered = toggle.contains(mouseX, mouseY);
            float target = toggle.isHovered ? 1.0f : 0.0f;
            toggle.hoverProgress = Mth.lerp((float)(deltaTime * 10.0f), (float)toggle.hoverProgress, (float)target);
        }
        for (UpgradeToggleInfo toggle : this.upgradeToggles) {
            this.drawUpgradeToggle(graphics, toggle, contentAlpha);
        }
    }

    private void drawUpgradeToggle(GuiGraphics graphics, UpgradeToggleInfo toggle, float alpha) {
        boolean isActive = this.getUpgradeState(toggle.type);
        int bgAlpha = (int)(51.0f * alpha);
        int borderAlpha = (int)(170.0f * alpha);
        int textAlpha = (int)(255.0f * alpha);
        int bgColor = bgAlpha << 24 | 0xFFFFFF;
        graphics.fill((int)toggle.x, (int)toggle.y, (int)(toggle.x + toggle.width), (int)(toggle.y + toggle.height), bgColor);
        if (toggle.hoverProgress > 0.0f) {
            int hoverAlpha = (int)(102.0f * alpha * toggle.hoverProgress);
            int hoverColor = hoverAlpha << 24 | 0xFFFFFF;
            graphics.fill((int)(toggle.x + 1.0f), (int)(toggle.y + 1.0f), (int)(toggle.x + toggle.width - 1.0f), (int)(toggle.y + toggle.height - 1.0f), hoverColor);
        }
        if (toggle.type == UpgradeType.REPLACE_MODE) {
            int coloredBorderColor = isActive ? borderAlpha << 24 | 0x4CAF50 : borderAlpha << 24 | 0xF44336;
            graphics.hLine((int)toggle.x, (int)(toggle.x + toggle.width - 1.0f), (int)toggle.y, coloredBorderColor);
            graphics.hLine((int)toggle.x, (int)(toggle.x + toggle.width - 1.0f), (int)(toggle.y + toggle.height - 1.0f), coloredBorderColor);
            graphics.vLine((int)toggle.x, (int)toggle.y, (int)(toggle.y + toggle.height - 1.0f), coloredBorderColor);
            graphics.vLine((int)(toggle.x + toggle.width - 1.0f), (int)toggle.y, (int)(toggle.y + toggle.height - 1.0f), coloredBorderColor);
        } else {
            this.drawPanelBorder(graphics, (int)toggle.x, (int)toggle.y, (int)toggle.width, (int)toggle.height, borderAlpha);
        }
        Component text = this.getUpgradeLabel(toggle.type);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        graphics.pose().pushPose();
        float textScale = 0.8f;
        graphics.pose().scale(textScale, textScale, textScale);
        graphics.drawString(this.font, text, (int)((toggle.x + 5.0f) / textScale), (int)((toggle.y + (toggle.height - 8.0f * textScale) / 2.0f) / textScale), textColor, false);
        graphics.pose().popPose();
        float indicatorX = toggle.x + toggle.width - 28.0f;
        float indicatorY = toggle.y + toggle.height / 2.0f - 6.0f;
        this.drawToggleIndicator(graphics, indicatorX, indicatorY, isActive, alpha);
    }

    private void drawToggleIndicator(GuiGraphics graphics, float x, float y, boolean isActive, float alpha) {
        int trackWidth = 24;
        int trackHeight = 12;
        int knobSize = 10;
        int knobPadding = 1;
        int trackX = (int)x;
        int trackY = (int)y;
        int trackAlpha = isActive ? (int)(100.0f * alpha) : (int)(40.0f * alpha);
        int trackColor = isActive ? trackAlpha << 24 | 0x4CAF50 : trackAlpha << 24 | 0x888888;
        graphics.fill(trackX, trackY, trackX + trackWidth, trackY + trackHeight, trackColor);
        int borderAlpha = (int)(180.0f * alpha);
        int borderColor = borderAlpha << 24 | 0xFFFFFF;
        graphics.hLine(trackX, trackX + trackWidth - 1, trackY, borderColor);
        graphics.hLine(trackX, trackX + trackWidth - 1, trackY + trackHeight - 1, borderColor);
        graphics.vLine(trackX, trackY, trackY + trackHeight - 1, borderColor);
        graphics.vLine(trackX + trackWidth - 1, trackY, trackY + trackHeight - 1, borderColor);
        int knobX = isActive ? trackX + trackWidth - knobSize - knobPadding : trackX + knobPadding;
        int knobY = trackY + knobPadding;
        int knobAlpha = (int)(200.0f * alpha);
        int knobColor = knobAlpha << 24 | 0xFFFFFF;
        graphics.fill(knobX, knobY, knobX + knobSize, knobY + knobSize, knobColor);
        int knobBorderAlpha = (int)(255.0f * alpha);
        int knobBorderColor = knobBorderAlpha << 24 | 0xFFFFFF;
        graphics.hLine(knobX, knobX + knobSize - 1, knobY, knobBorderColor);
        graphics.hLine(knobX, knobX + knobSize - 1, knobY + knobSize - 1, knobBorderColor);
        graphics.vLine(knobX, knobY, knobY + knobSize - 1, knobBorderColor);
        graphics.vLine(knobX + knobSize - 1, knobY, knobY + knobSize - 1, knobBorderColor);
        int highlightAlpha = (int)(100.0f * alpha);
        int highlightColor = highlightAlpha << 24 | 0xFFFFFF;
        graphics.hLine(knobX + 1, knobX + knobSize - 2, knobY + 1, highlightColor);
        graphics.vLine(knobX + 1, knobY + 1, knobY + knobSize - 2, highlightColor);
    }

    private void drawPanelBorder(GuiGraphics graphics, int x, int y, int width, int height, int alpha) {
        int borderColor = alpha << 24 | 0xFFFFFF;
        graphics.hLine(x, x + width - 1, y, borderColor);
        graphics.hLine(x, x + width - 1, y + height - 1, borderColor);
        graphics.vLine(x, y, y + height - 1, borderColor);
        graphics.vLine(x + width - 1, y, y + height - 1, borderColor);
    }

    private void toggleUpgrade(UpgradeType type) {
        switch (type.ordinal()) {
            case 0: {
                this.trowelData.setChippedConversionActive(!this.trowelData.isChippedConversionActive());
                break;
            }
            case 1: {
                this.trowelData.setCapacityActive(!this.trowelData.isCapacityActive());
                break;
            }
            case 2: {
                this.trowelData.setReachActive(!this.trowelData.isReachActive());
                break;
            }
            case 3: {
                this.trowelData.setReplaceMode(!this.trowelData.isReplaceMode());
            }
        }
        TrowelPacket.Action action = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> TrowelPacket.Action.TOGGLE_CHIPPED;
            case 1 -> TrowelPacket.Action.TOGGLE_CAPACITY;
            case 2 -> TrowelPacket.Action.TOGGLE_REACH;
            case 3 -> TrowelPacket.Action.TOGGLE_REPLACE;
        };
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(action, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void toggleDirection(Direction direction) {
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        boolean wasLocked = rotationData.isDirectionLocked(direction);
        for (Direction dir : Direction.values()) {
            if (dir == direction || dir.getAxis() == Direction.Axis.Y || !rotationData.isDirectionLocked(dir)) continue;
            rotationData.toggleDirectionLock(dir);
        }
        rotationData.toggleDirectionLock(direction);
        CompoundTag rotationTag = new CompoundTag();
        rotationData.save(rotationTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_ROTATION, 0, rotationTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void toggleVerticalDirection(Direction direction) {
        Direction otherVertical;
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        boolean wasLocked = rotationData.isDirectionLocked(direction);
        Direction direction2 = otherVertical = direction == Direction.UP ? Direction.DOWN : Direction.UP;
        if (rotationData.isDirectionLocked(otherVertical)) {
            rotationData.toggleDirectionLock(otherVertical);
        }
        rotationData.toggleDirectionLock(direction);
        CompoundTag rotationTag = new CompoundTag();
        rotationData.save(rotationTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_ROTATION, 0, rotationTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void resetGlobalRotationLocks() {
        RotationLockData rotationData = this.trowelData.getRotationLockData();
        rotationData.clearLocks();
        rotationData.setStairMode(RotationLockData.StairMode.AUTO);
        rotationData.setSlabMode(RotationLockData.SlabMode.AUTO);
        rotationData.setStairLink(true);
        CompoundTag rotationTag = new CompoundTag();
        rotationData.save(rotationTag);
        PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.SAVE_ROTATION, 0, rotationTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().gui.setOverlayMessage((Component)Component.literal((String)"Global rotation reset"), false);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static class DirectionToggleInfo {
        final Direction direction;
        final float startAngle;
        final float endAngle;
        boolean isHovered;
        float hoverProgress = 0.0f;

        DirectionToggleInfo(Direction direction, float startAngle, float endAngle) {
            this.direction = direction;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
        }

        boolean contains(double mouseX, double mouseY, float screenCenterX, float screenCenterY, float innerR, float outerR) {
            float end;
            float start;
            float dx = (float)(mouseX - (double)screenCenterX);
            float dy = (float)(mouseY - (double)screenCenterY);
            float distance = (float)Math.sqrt(dx * dx + dy * dy);
            if (distance < innerR || distance > outerR) {
                return false;
            }
            float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            if ((start = this.startAngle) > (end = this.endAngle)) {
                return angle >= start || angle <= end;
            }
            return angle >= start && angle <= end;
        }
    }

    private static class UpgradeToggleInfo {
        final UpgradeType type;
        final float x;
        final float y;
        final float width;
        final float height;
        boolean isHovered;
        float hoverProgress = 0.0f;

        UpgradeToggleInfo(UpgradeType type, float x, float y, float width, float height) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        }
    }

    private static enum UpgradeType {
        VARIANT_CONVERSION,
        WAND_CAPACITY,
        EXTENDED_REACH,
        REPLACE_MODE;

    }

    private static class SegmentInfo {
        final float startAngle;
        final float endAngle;
        final int index;

        SegmentInfo(float startAngle, float endAngle, int index) {
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.index = index;
        }

        boolean contains(double mouseX, double mouseY, float centerX, float centerY, float innerR, float outerR) {
            float end;
            float start;
            float dx = (float)(mouseX - (double)centerX);
            float dy = (float)(mouseY - (double)centerY);
            float distance = (float)Math.sqrt(dx * dx + dy * dy);
            if (distance < innerR || distance > outerR) {
                return false;
            }
            float angle = (float)Math.toDegrees(Math.atan2(dy, dx));
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            if ((start = this.startAngle) > (end = this.endAngle)) {
                return angle >= start || angle <= end;
            }
            return angle >= start && angle <= end;
        }
    }
}

