/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="mechtrowel", value={Dist.CLIENT})
public class GradientMilestoneRenderer {
    private static final List<MilestoneEffect> activeEffects = new ArrayList<MilestoneEffect>();
    private static final float EFFECT_DURATION = 0.5f;
    private static final float MAX_SCALE = 1.2f;

    public static void queueMilestoneEffect(BlockPos pos) {
        activeEffects.add(new MilestoneEffect(pos));
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (activeEffects.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        Iterator<MilestoneEffect> iterator = activeEffects.iterator();
        while (iterator.hasNext()) {
            MilestoneEffect effect = iterator.next();
            if (effect.tick(partialTick * 0.05f)) continue;
            iterator.remove();
        }
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        for (MilestoneEffect effect : activeEffects) {
            GradientMilestoneRenderer.renderMilestoneEffect(poseStack, effect, camPos);
        }
    }

    private static void renderMilestoneEffect(PoseStack poseStack, MilestoneEffect effect, Vec3 camPos) {
        poseStack.pushPose();
        BlockPos pos = effect.pos;
        poseStack.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        float progress = effect.getProgress();
        float scale = 1.0f + 0.20000005f * (1.0f - progress);
        float alpha = (1.0f - progress) * 0.8f;
        float pulse = (float)Math.sin((double)progress * Math.PI);
        scale += pulse * 0.1f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.lineWidth((float)3.0f);
        GradientMilestoneRenderer.renderGlitterBox(poseStack, scale, alpha, progress);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        poseStack.popPose();
    }

    private static void renderGlitterBox(PoseStack poseStack, float scale, float alpha, float progress) {
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        float shimmer = (float)(Math.sin((double)progress * Math.PI * 8.0) * 0.5 + 0.5);
        float r = shimmer * 0.3f;
        float g = shimmer * 0.3f;
        float b = shimmer * 0.3f;
        float min = -0.001f * scale;
        float max = 1.001f * scale;
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrix, min, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, min).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, max, max, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, min, max).setColor(r, g, b, alpha);
        buffer.addVertex(matrix, min, max, max).setColor(r, g, b, alpha);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    private static class MilestoneEffect {
        final BlockPos pos;
        float age;

        MilestoneEffect(BlockPos pos) {
            this.pos = pos;
            this.age = 0.0f;
        }

        boolean tick(float deltaTime) {
            this.age += deltaTime;
            return this.age < 0.5f;
        }

        float getProgress() {
            return this.age / 0.5f;
        }
    }
}

