/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.PaletteData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class WeightedBlockSelector {
    public static BlockState selectBlock(PaletteData palette, RandomSource random) {
        PaletteData.WeightedBlock selected = WeightedBlockSelector.selectWeightedBlock(palette, random);
        return selected != null ? selected.getState() : null;
    }

    public static PaletteData.WeightedBlock selectWeightedBlock(PaletteData palette, RandomSource random) {
        if (palette == null || palette.isEmpty()) {
            return null;
        }
        float totalWeight = 0.0f;
        for (PaletteData.WeightedBlock block : palette.getBlocks()) {
            totalWeight += block.getWeight();
        }
        if (totalWeight <= 0.0f) {
            return palette.getBlocks().get(0);
        }
        float randomValue = random.nextFloat() * totalWeight;
        float currentWeight = 0.0f;
        for (PaletteData.WeightedBlock block : palette.getBlocks()) {
            if (!(randomValue <= (currentWeight += block.getWeight()))) continue;
            return block;
        }
        return palette.getBlocks().get(palette.getBlocks().size() - 1);
    }
}

