/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;

public class StairPlacementHelper {
    public static BlockState applyStairShape(BlockState state, Level level, BlockPos pos, boolean linkEnabled) {
        if (!linkEnabled || !(state.getBlock() instanceof StairBlock)) {
            if (state.hasProperty((Property)BlockStateProperties.STAIRS_SHAPE)) {
                return (BlockState)state.setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT);
            }
            return state;
        }
        return state;
    }

    public static void postProcessStairPlacement(Level level, BlockPos pos, BlockState state, boolean linkEnabled) {
        if (state.getBlock() instanceof StairBlock) {
            if (!linkEnabled) {
                if (state.hasProperty((Property)BlockStateProperties.STAIRS_SHAPE)) {
                    BlockState straightState = (BlockState)state.setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)StairsShape.STRAIGHT);
                    level.setBlock(pos, straightState, 18);
                }
            } else {
                BlockState updatedState = state;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = pos.relative(dir);
                    BlockState neighborState = level.getBlockState(neighborPos);
                    updatedState = updatedState.updateShape(dir, neighborState, (LevelAccessor)level, pos, neighborPos);
                }
                if (updatedState != state) {
                    level.setBlock(pos, updatedState, 3);
                }
            }
        }
    }

    public static boolean shouldConnect(BlockState state, BlockState adjacentState, boolean linkEnabled) {
        if (!linkEnabled) {
            return false;
        }
        if (!(state.getBlock() instanceof StairBlock) || !(adjacentState.getBlock() instanceof StairBlock)) {
            return false;
        }
        return state.getValue((Property)BlockStateProperties.HALF) == adjacentState.getValue((Property)BlockStateProperties.HALF);
    }
}

