/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.PaletteData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class PaletteCodec {
    private static final String PREFIX = "MT:";

    public static String encode(PaletteData palette) {
        try {
            CompoundTag tag = new CompoundTag();
            palette.save(tag);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);
                 DataOutputStream dos = new DataOutputStream(gzos);){
                NbtIo.write((CompoundTag)tag, (DataOutput)dos);
            }
            String base64 = Base64.getEncoder().encodeToString(baos.toByteArray());
            return PREFIX + base64;
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Failed to encode palette: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static PaletteData decode(String code) {
        try {
            CompoundTag tag;
            if (code == null || !code.startsWith(PREFIX)) {
                MechTrowel.LOGGER.warn("Invalid palette code: missing prefix");
                return null;
            }
            String base64 = code.substring(PREFIX.length()).trim();
            byte[] compressed = Base64.getDecoder().decode(base64);
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            try (GZIPInputStream gzis = new GZIPInputStream(bais);
                 DataInputStream dis = new DataInputStream(gzis);){
                tag = NbtIo.read((DataInput)dis);
            }
            PaletteData palette = new PaletteData();
            palette.load(tag);
            return palette;
        }
        catch (IllegalArgumentException e) {
            MechTrowel.LOGGER.warn("Invalid Base64 in palette code: {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Failed to decode palette: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isValidCode(String code) {
        if (code == null || !code.startsWith(PREFIX)) {
            return false;
        }
        try {
            String base64 = code.substring(PREFIX.length()).trim();
            Base64.getDecoder().decode(base64);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

