/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.util;

import com.asger.mechtrowel.data.RotationLockData;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class CopycatSlabHelper {
    public static BlockState applyCopycatSlabRotation(BlockState state, RotationLockData rotationData, Player player, Direction clickedFace, BlockPlaceContext context) {
        String blockId = state.getBlock().getDescriptionId();
        if (!blockId.contains("copycat_slab")) {
            return state;
        }
        BlockState originalState = state;
        RotationLockData.SlabMode slabMode = rotationData.getSlabMode();
        if (slabMode != RotationLockData.SlabMode.AUTO) {
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)(switch (slabMode) {
                    case RotationLockData.SlabMode.TOP -> Direction.DOWN;
                    case RotationLockData.SlabMode.BOTTOM -> Direction.UP;
                    default -> clickedFace.getOpposite();
                }));
            }
            if (state.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(switch (slabMode) {
                    case RotationLockData.SlabMode.TOP -> SlabType.TOP;
                    case RotationLockData.SlabMode.BOTTOM -> SlabType.BOTTOM;
                    default -> (SlabType)state.getValue((Property)BlockStateProperties.SLAB_TYPE);
                }));
            }
            for (Property property : state.getProperties()) {
                String propName = property.getName();
                if (!propName.equals("type") && !propName.equals("half") && !propName.equals("position") && !propName.equals("placement")) continue;
                if (slabMode == RotationLockData.SlabMode.TOP) {
                    state = CopycatSlabHelper.trySetPropertyValue(state, property, "top", "upper", "ceiling");
                    continue;
                }
                if (slabMode != RotationLockData.SlabMode.BOTTOM) continue;
                state = CopycatSlabHelper.trySetPropertyValue(state, property, "bottom", "lower", "floor");
            }
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState trySetPropertyValue(BlockState state, Property<T> property, String ... values) {
        for (String value : values) {
            for (Comparable possibleValue : property.getPossibleValues()) {
                if (!possibleValue.toString().equalsIgnoreCase(value)) continue;
                return (BlockState)state.setValue(property, possibleValue);
            }
        }
        return state;
    }

    public static boolean isCopycatSlab(BlockState state) {
        String blockId = state.getBlock().getDescriptionId();
        return blockId.contains("copycat_slab");
    }
}

