/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class StyledRadioButton
extends Button {
    private static final int SLOT_BG = -12829636;
    private static final int BORDER_DARK = -14803426;
    private static final int BORDER_LIGHT = -10855846;
    private static final int TEXT_COLOR = -1;
    private static final int TEXT_COLOR_INACTIVE = -8355712;
    private static final int ACTIVE_INDICATOR = -11751600;
    private static final int HOVER_OVERLAY = 0x20FFFFFF;
    private boolean selected;
    private final Consumer<StyledRadioButton> onSelect;
    private RadioButtonGroup group;

    public StyledRadioButton(int x, int y, int width, int height, Component text, boolean initiallySelected, Consumer<StyledRadioButton> onSelect) {
        super(x, y, width, height, text, button -> {
            StyledRadioButton radioButton = (StyledRadioButton)button;
            if (!radioButton.selected && radioButton.group != null) {
                radioButton.group.select(radioButton);
            }
        }, DEFAULT_NARRATION);
        this.selected = initiallySelected;
        this.onSelect = onSelect;
    }

    public void setGroup(RadioButtonGroup group) {
        this.group = group;
    }

    public void setSelected(boolean selected) {
        boolean wasSelected = this.selected;
        this.selected = selected;
        if (selected && !wasSelected && this.onSelect != null) {
            this.onSelect.accept(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12829636);
        this.renderBorder(guiGraphics, this.getX(), this.getY(), this.width, this.height);
        if (this.selected) {
            this.renderSelectionBorder(guiGraphics, this.getX(), this.getY(), this.width, this.height);
            guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + this.width - 2, this.getY() + this.height - 2, 441233232);
        }
        if (this.isHovered && !this.selected) {
            guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, 0x20FFFFFF);
        }
        Component displayText = this.getMessage();
        int textWidth = Minecraft.getInstance().font.width((FormattedText)displayText);
        int textX = this.getX() + (this.width - textWidth) / 2;
        int textY = this.getY() + (this.height - 8) / 2;
        int textColor = this.selected ? -1 : -8355712;
        guiGraphics.drawString(Minecraft.getInstance().font, displayText, textX, textY, textColor, false);
        if (!this.active) {
            guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, Integer.MIN_VALUE);
        }
    }

    private void renderBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        guiGraphics.hLine(x, x + width - 1, y, -14803426);
        guiGraphics.vLine(x, y, y + height - 1, -14803426);
        guiGraphics.hLine(x, x + width - 1, y + height - 1, -10855846);
        guiGraphics.vLine(x + width - 1, y, y + height - 1, -10855846);
    }

    private void renderSelectionBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        int green = -11751600;
        guiGraphics.hLine(x + 1, x + width - 2, y + 1, green);
        guiGraphics.hLine(x + 1, x + width - 2, y + height - 2, green);
        guiGraphics.vLine(x + 1, y + 1, y + height - 2, green);
        guiGraphics.vLine(x + width - 2, y + 1, y + height - 2, green);
    }

    public static class RadioButtonGroup {
        final List<StyledRadioButton> buttons = new ArrayList<StyledRadioButton>();
        private StyledRadioButton selected;

        public void add(StyledRadioButton button) {
            this.buttons.add(button);
            button.setGroup(this);
            if (button.isSelected()) {
                if (this.selected != null) {
                    this.selected.setSelected(false);
                }
                this.selected = button;
            }
        }

        public void select(StyledRadioButton button) {
            if (!this.buttons.contains((Object)button)) {
                return;
            }
            if (this.selected != null && this.selected != button) {
                this.selected.setSelected(false);
            }
            this.selected = button;
            button.setSelected(true);
        }

        public StyledRadioButton getSelected() {
            return this.selected;
        }

        public void clear() {
            this.buttons.clear();
            this.selected = null;
        }

        public StyledRadioButton getFirst() {
            return this.buttons.isEmpty() ? null : this.buttons.get(0);
        }
    }
}

