/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import com.asger.mechtrowel.data.BlockRotationConfig;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class RotationRingWidget
extends AbstractWidget {
    private final float outerRadius;
    private final float innerRadius;
    private final float centerRadius;
    private static final int LOCKED_COLOR = 5025616;
    private static final int UNLOCKED_COLOR = 0xFFFFFF;
    private static final int HOVER_COLOR = 0xFFFFFF;
    private static final int BORDER_COLOR = -1426063361;
    private static final int DIVIDER_COLOR = 0x77FFFFFF;
    private static final int PALETTE_BG_COLOR = 0x3C3C3C;
    private static final int PALETTE_BORDER_DARK = 0x1E1E1E;
    private static final int PALETTE_BORDER_LIGHT = 0x5A5A5A;
    private BlockRotationConfig config;
    private Consumer<Direction> onDirectionClick;
    private boolean showVertical = true;
    private boolean paletteStyle = false;
    private Direction hoveredDirection = null;
    private float[] hoverProgress = new float[6];
    private static final float[][] DIRECTION_ANGLES = new float[][]{{225.0f, 315.0f}, {315.0f, 45.0f}, {45.0f, 135.0f}, {135.0f, 225.0f}};
    private static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public RotationRingWidget(int x, int y, int size, BlockRotationConfig config) {
        super(x, y, size, size, (Component)Component.empty());
        this.config = config;
        this.outerRadius = (float)size / 2.0f;
        this.innerRadius = this.outerRadius * 0.5f;
        this.centerRadius = this.innerRadius * 0.6f;
    }

    public void setConfig(BlockRotationConfig config) {
        this.config = config;
    }

    public void setOnDirectionClick(Consumer<Direction> callback) {
        this.onDirectionClick = callback;
    }

    public void setShowVertical(boolean show) {
        this.showVertical = show;
    }

    public void setPaletteStyle(boolean paletteStyle) {
        this.paletteStyle = paletteStyle;
    }

    public boolean isPaletteStyle() {
        return this.paletteStyle;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.config == null) {
            return;
        }
        float centerX = (float)this.getX() + (float)this.width / 2.0f;
        float centerY = (float)this.getY() + (float)this.height / 2.0f;
        this.updateHoverStates(mouseX, mouseY, centerX, centerY, partialTick);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < HORIZONTAL_DIRECTIONS.length; ++i) {
            int segmentColor;
            boolean isHovered;
            Direction dir = HORIZONTAL_DIRECTIONS[i];
            boolean isLocked = this.config.isDirectionLocked(dir);
            boolean bl = isHovered = this.hoveredDirection == dir;
            if (this.paletteStyle) {
                segmentColor = isLocked ? -598954160 : -12829636;
                if (this.hoverProgress[dir.ordinal()] > 0.0f) {
                    segmentColor = this.lerpColor(segmentColor, -10855846, this.hoverProgress[dir.ordinal()] * 0.3f);
                }
            } else {
                if (isLocked) {
                    alpha = 120;
                    segmentColor = alpha << 24 | 0x4CAF50;
                } else {
                    alpha = 40;
                    segmentColor = alpha << 24 | 0xFFFFFF;
                }
                if (this.hoverProgress[dir.ordinal()] > 0.0f) {
                    segmentColor = this.lerpColor(segmentColor, 0x50FFFFFF, this.hoverProgress[dir.ordinal()] * 0.5f);
                }
            }
            float startAngle = DIRECTION_ANGLES[i][0];
            float endAngle = DIRECTION_ANGLES[i][1];
            this.drawSegment(graphics, centerX, centerY, this.innerRadius, this.outerRadius, startAngle, endAngle, segmentColor, 1.0f);
            this.drawDirectionLabel(graphics, centerX, centerY, dir, startAngle, endAngle, isLocked);
        }
        if (this.showVertical) {
            this.drawVerticalButtons(graphics, centerX, centerY, mouseX, mouseY);
        } else {
            this.drawFilledCircle(graphics, centerX, centerY, this.centerRadius, 0x28FFFFFF);
        }
        RenderSystem.disableBlend();
    }

    private void updateHoverStates(int mouseX, int mouseY, float centerX, float centerY, float deltaTime) {
        this.hoveredDirection = null;
        for (int i = 0; i < HORIZONTAL_DIRECTIONS.length; ++i) {
            Direction dir = HORIZONTAL_DIRECTIONS[i];
            float startAngle = DIRECTION_ANGLES[i][0];
            float endAngle = DIRECTION_ANGLES[i][1];
            boolean isHovered = this.containsInWedge(mouseX, mouseY, centerX, centerY, this.innerRadius, this.outerRadius, startAngle, endAngle);
            if (isHovered) {
                this.hoveredDirection = dir;
            }
            float target = isHovered ? 1.0f : 0.0f;
            this.hoverProgress[dir.ordinal()] = Mth.lerp((float)(deltaTime * 0.5f), (float)this.hoverProgress[dir.ordinal()], (float)target);
        }
        if (this.showVertical) {
            float dx = (float)mouseX - centerX;
            float dy = (float)mouseY - centerY;
            float distSq = dx * dx + dy * dy;
            float radius = this.innerRadius * 0.85f;
            if (distSq <= radius * radius) {
                this.hoveredDirection = (float)mouseY < centerY ? Direction.UP : Direction.DOWN;
            }
            this.hoverProgress[Direction.UP.ordinal()] = Mth.lerp((float)(deltaTime * 0.5f), (float)this.hoverProgress[Direction.UP.ordinal()], (float)(this.hoveredDirection == Direction.UP ? 1.0f : 0.0f));
            this.hoverProgress[Direction.DOWN.ordinal()] = Mth.lerp((float)(deltaTime * 0.5f), (float)this.hoverProgress[Direction.DOWN.ordinal()], (float)(this.hoveredDirection == Direction.DOWN ? 1.0f : 0.0f));
        }
    }

    private void drawVerticalButtons(GuiGraphics graphics, float centerX, float centerY, int mouseX, int mouseY) {
        int downColor;
        int upColor;
        float radius = this.innerRadius * 0.85f;
        boolean upLocked = this.config.isDirectionLocked(Direction.UP);
        boolean downLocked = this.config.isDirectionLocked(Direction.DOWN);
        if (this.paletteStyle) {
            upColor = upLocked ? -598954160 : -12829636;
            int n = downColor = downLocked ? -598954160 : -12829636;
            if (this.hoverProgress[Direction.UP.ordinal()] > 0.0f) {
                upColor = this.lerpColor(upColor, -10855846, this.hoverProgress[Direction.UP.ordinal()] * 0.3f);
            }
            if (this.hoverProgress[Direction.DOWN.ordinal()] > 0.0f) {
                downColor = this.lerpColor(downColor, -10855846, this.hoverProgress[Direction.DOWN.ordinal()] * 0.3f);
            }
        } else {
            upColor = upLocked ? 2018291536 : 0x28FFFFFF;
            int n = downColor = downLocked ? 2018291536 : 0x28FFFFFF;
            if (this.hoverProgress[Direction.UP.ordinal()] > 0.0f) {
                upColor = this.lerpColor(upColor, 0x50FFFFFF, this.hoverProgress[Direction.UP.ordinal()] * 0.5f);
            }
            if (this.hoverProgress[Direction.DOWN.ordinal()] > 0.0f) {
                downColor = this.lerpColor(downColor, 0x50FFFFFF, this.hoverProgress[Direction.DOWN.ordinal()] * 0.5f);
            }
        }
        this.drawSemiCircle(graphics, centerX, centerY, radius, 180.0f, 360.0f, upColor);
        this.drawSemiCircle(graphics, centerX, centerY, radius, 0.0f, 180.0f, downColor);
        int borderColor = this.paletteStyle ? -14803426 : -1426063361;
        this.drawCircleBorder(graphics, centerX, centerY, radius, borderColor, this.paletteStyle ? 1.0f : 0.5f);
        int dividerColor = this.paletteStyle ? -14803426 : 0x77FFFFFF;
        this.drawLine(graphics, centerX - radius, centerY, centerX + radius, centerY, dividerColor);
        Font font = Minecraft.getInstance().font;
        int upTextColor = upLocked ? -1 : -4473925;
        int downTextColor = downLocked ? -1 : -4473925;
        graphics.pose().pushPose();
        graphics.pose().translate(centerX, centerY - radius * 0.5f - 3.0f, 0.0f);
        graphics.pose().scale(0.7f, 0.7f, 0.7f);
        graphics.drawCenteredString(font, "U", 0, 0, upTextColor);
        graphics.pose().popPose();
        graphics.pose().pushPose();
        graphics.pose().translate(centerX, centerY + radius * 0.5f - 3.0f, 0.0f);
        graphics.pose().scale(0.7f, 0.7f, 0.7f);
        graphics.drawCenteredString(font, "D", 0, 0, downTextColor);
        graphics.pose().popPose();
    }

    private void drawSemiCircle(GuiGraphics graphics, float centerX, float centerY, float radius, float startAngle, float endAngle, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = graphics.pose().last().pose();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.addVertex(matrix, centerX, centerY, 0.0f).setColor(r, g, b, a);
        int segments = 32;
        float angleRange = endAngle - startAngle;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)Math.toRadians(startAngle + angleRange * (float)i / (float)segments);
            float x = centerX + (float)Math.cos(angle) * radius;
            float y = centerY + (float)Math.sin(angle) * radius;
            buffer.addVertex(matrix, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    private void drawDirectionLabel(GuiGraphics graphics, float centerX, float centerY, Direction dir, float startAngle, float endAngle, boolean isLocked) {
        float midAngle;
        if (startAngle > endAngle) {
            midAngle = (startAngle + endAngle + 360.0f) / 2.0f;
            if (midAngle >= 360.0f) {
                midAngle -= 360.0f;
            }
        } else {
            midAngle = (startAngle + endAngle) / 2.0f;
        }
        float midRadius = (this.innerRadius + this.outerRadius) / 2.0f;
        float angle = (float)Math.toRadians(midAngle);
        float textX = centerX + (float)Math.cos(angle) * midRadius;
        float textY = centerY + (float)Math.sin(angle) * midRadius;
        String letter = this.getDirectionLetter(dir);
        int textColor = isLocked ? -1 : -4473925;
        Font font = Minecraft.getInstance().font;
        graphics.pose().pushPose();
        graphics.pose().translate(textX, textY - 3.0f, 0.0f);
        graphics.pose().scale(0.8f, 0.8f, 0.8f);
        graphics.drawCenteredString(font, letter, 0, 0, textColor);
        graphics.pose().popPose();
    }

    private String getDirectionLetter(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> "N";
            case Direction.SOUTH -> "S";
            case Direction.EAST -> "E";
            case Direction.WEST -> "W";
            case Direction.UP -> "U";
            case Direction.DOWN -> "D";
        };
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isActive() || !this.isHovered() || button != 0) {
            return false;
        }
        if (this.hoveredDirection != null && this.onDirectionClick != null) {
            this.onDirectionClick.accept(this.hoveredDirection);
            return true;
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        float centerY;
        float dy;
        float centerX = (float)this.getX() + (float)this.width / 2.0f;
        float dx = (float)(mouseX - (double)centerX);
        float distance = (float)Math.sqrt(dx * dx + (dy = (float)(mouseY - (double)(centerY = (float)this.getY() + (float)this.height / 2.0f))) * dy);
        return distance <= this.outerRadius;
    }

    private void drawSegment(GuiGraphics graphics, float centerX, float centerY, float innerR, float outerR, float startAngle, float endAngle, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(8, (int)(angleRange / 5.0f));
        float angleStep = angleRange / (float)steps;
        for (int i = 0; i <= steps; ++i) {
            float angle = (float)Math.toRadians(startAngle + (float)i * angleStep);
            float cos = (float)Math.cos(angle);
            float sin = (float)Math.sin(angle);
            float x1 = centerX + cos * innerR;
            float y1 = centerY + sin * innerR;
            float x2 = centerX + cos * outerR;
            float y2 = centerY + sin * outerR;
            if (i <= 0) continue;
            float prevAngle = (float)Math.toRadians(startAngle + (float)(i - 1) * angleStep);
            float prevCos = (float)Math.cos(prevAngle);
            float prevSin = (float)Math.sin(prevAngle);
            float px1 = centerX + prevCos * innerR;
            float py1 = centerY + prevSin * innerR;
            float px2 = centerX + prevCos * outerR;
            float py2 = centerY + prevSin * outerR;
            buffer.addVertex(matrix, px1, py1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, px2, py2, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        this.drawSegmentBorder(graphics, centerX, centerY, innerR, outerR, startAngle, endAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerR, outerR, startAngle, alpha);
        this.drawSegmentDivider(graphics, centerX, centerY, innerR, outerR, endAngle, alpha);
        RenderSystem.disableBlend();
    }

    private void drawSegmentBorder(GuiGraphics graphics, float centerX, float centerY, float innerR, float outerR, float startAngle, float endAngle, float alpha) {
        float angle2;
        float angle1;
        int i;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        int borderAlpha = (int)(170.0f * alpha * 0.5f);
        int r = 255;
        int g = 255;
        int b = 255;
        float angleRange = endAngle - startAngle;
        if (angleRange < 0.0f) {
            angleRange += 360.0f;
        }
        int steps = Math.max(4, (int)(angleRange / 10.0f));
        float angleStep = angleRange / (float)steps;
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle1) * innerR, centerY + (float)Math.sin(angle1) * innerR, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle2) * innerR, centerY + (float)Math.sin(angle2) * innerR, 0.0f).setColor(r, g, b, borderAlpha);
        }
        for (i = 0; i < steps; ++i) {
            angle1 = (float)Math.toRadians(startAngle + (float)i * angleStep);
            angle2 = (float)Math.toRadians(startAngle + (float)(i + 1) * angleStep);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle1) * outerR, centerY + (float)Math.sin(angle1) * outerR, 0.0f).setColor(r, g, b, borderAlpha);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle2) * outerR, centerY + (float)Math.sin(angle2) * outerR, 0.0f).setColor(r, g, b, borderAlpha);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawSegmentDivider(GuiGraphics graphics, float centerX, float centerY, float innerR, float outerR, float angle, float alpha) {
        float cos = (float)Math.cos(Math.toRadians(angle));
        float sin = (float)Math.sin(Math.toRadians(angle));
        float x1 = centerX + cos * innerR;
        float y1 = centerY + sin * innerR;
        float x2 = centerX + cos * outerR;
        float y2 = centerY + sin * outerR;
        int dividerAlpha = (int)(119.0f * alpha);
        int color = dividerAlpha << 24 | 0xFFFFFF;
        this.drawLine(graphics, x1, y1, x2, y2, color);
    }

    private void drawLine(GuiGraphics graphics, float x1, float y1, float x2, float y2, int color) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length > 0.0f) {
            float thickness = 1.5f;
            float perpX = -dy / length * thickness / 2.0f;
            float perpY = dx / length * thickness / 2.0f;
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f matrix = graphics.pose().last().pose();
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.addVertex(matrix, x1 + perpX, y1 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1 - perpX, y1 - perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 + perpX, y2 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 + perpX, y2 + perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x1 - perpX, y1 - perpY, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(matrix, x2 - perpX, y2 - perpY, 0.0f).setColor(r, g, b, a);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }

    private void drawFilledCircle(GuiGraphics graphics, float centerX, float centerY, float radius, int color) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.addVertex(matrix, centerX, centerY, 0.0f).setColor(r, g, b, a);
        int segments = 32;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle) * radius, centerY + (float)Math.sin(angle) * radius, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void drawCircleBorder(GuiGraphics graphics, float centerX, float centerY, float radius, int color, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        int a = (int)((float)(color >> 24 & 0xFF) * alpha);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int segments = 32;
        for (int i = 0; i <= segments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)segments);
            buffer.addVertex(matrix, centerX + (float)Math.cos(angle) * radius, centerY + (float)Math.sin(angle) * radius, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private boolean containsInWedge(double mouseX, double mouseY, float centerX, float centerY, float innerR, float outerR, float startAngle, float endAngle) {
        float dx = (float)(mouseX - (double)centerX);
        float dy = (float)(mouseY - (double)centerY);
        float distance = (float)Math.sqrt(dx * dx + dy * dy);
        if (distance < innerR || distance > outerR) {
            return false;
        }
        float mouseAngle = (float)Math.toDegrees(Math.atan2(dy, dx));
        if (mouseAngle < 0.0f) {
            mouseAngle += 360.0f;
        }
        if (startAngle > endAngle) {
            return mouseAngle >= startAngle || mouseAngle <= endAngle;
        }
        return mouseAngle >= startAngle && mouseAngle <= endAngle;
    }

    private int lerpColor(int c1, int c2, float t) {
        int a1 = c1 >> 24 & 0xFF;
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >> 24 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)Mth.lerp((float)t, (float)a1, (float)a2);
        int r = (int)Mth.lerp((float)t, (float)r1, (float)r2);
        int g = (int)Mth.lerp((float)t, (float)g1, (float)g2);
        int b = (int)Mth.lerp((float)t, (float)b1, (float)b2);
        return a << 24 | r << 16 | g << 8 | b;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)Component.translatable((String)"gui.mechtrowel.rotation_ring"));
    }
}

