/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class PaletteDropdown
extends AbstractWidget {
    private static final int ITEM_HEIGHT = 20;
    private static final int MAX_VISIBLE_ITEMS = 5;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SLOT_BG = -12829636;
    private static final int BORDER_DARK = -14803426;
    private static final int BORDER_LIGHT = -10855846;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static final int DROPDOWN_BG = -13882324;
    private static final int HOVER_COLOR = -11776948;
    private static final int SELECTED_HIGHLIGHT = 0x40FFFFFF;
    private final List<Integer> options;
    private final Function<Integer, Component> displayFunction;
    private final Consumer<Integer> onSelectionChange;
    private Function<Integer, BlockState> iconProvider;
    private int selectedIndex;
    private boolean isOpen = false;
    private int scrollOffset = 0;
    private int hoveredIndex = -1;
    private boolean isDraggingScrollbar = false;
    private int scrollbarDragOffset = 0;
    private boolean needsFullRefresh = false;

    public PaletteDropdown(int x, int y, int width, int height, List<Integer> options, int initialSelection, Function<Integer, Component> displayFunction, Consumer<Integer> onSelectionChange) {
        super(x, y, width, height, (Component)Component.empty());
        this.options = options;
        this.displayFunction = displayFunction;
        this.onSelectionChange = onSelectionChange;
        this.selectedIndex = initialSelection;
        this.updateMessage();
    }

    private void updateMessage() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.options.size()) {
            this.setMessage(this.displayFunction.apply(this.options.get(this.selectedIndex)));
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        BlockState iconBlock;
        if (!this.visible) {
            return;
        }
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -12829636);
        this.renderInsetBorder(graphics, this.getX(), this.getY(), this.width, this.height);
        if (mouseX >= this.getX() && mouseX < this.getX() + this.width && mouseY >= this.getY() && mouseY < this.getY() + this.height && !this.isOpen) {
            graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, 0x20FFFFFF);
        }
        Component text = this.getMessage();
        int textX = this.getX() + 6;
        int textY = this.getY() + (this.height - 8) / 2;
        int iconOffset = 0;
        if (this.iconProvider != null && this.selectedIndex >= 0 && this.selectedIndex < this.options.size() && (iconBlock = this.iconProvider.apply(this.options.get(this.selectedIndex))) != null) {
            graphics.pose().pushPose();
            graphics.pose().translate((float)textX, (float)(this.getY() + 2), 0.0f);
            graphics.pose().scale(0.95f, 0.95f, 0.95f);
            graphics.renderItem(new ItemStack((ItemLike)iconBlock.getBlock()), 0, 0);
            graphics.pose().popPose();
            iconOffset = 20;
        }
        graphics.drawString(Minecraft.getInstance().font, text, textX + iconOffset, textY, 0xFFFFFF, false);
        int arrowX = this.getX() + this.width - 14;
        int arrowY = this.getY() + this.height / 2 - 2;
        graphics.drawString(Minecraft.getInstance().font, this.isOpen ? "\u25b2" : "\u25bc", arrowX, arrowY, 0xFFFFFF, false);
    }

    private void renderInsetBorder(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.hLine(x, x + width - 1, y, -14803426);
        graphics.vLine(x, y, y + height - 1, -14803426);
        graphics.hLine(x, x + width - 1, y + height - 1, -10855846);
        graphics.vLine(x + width - 1, y, y + height - 1, -10855846);
    }

    public void renderDropdownOverlay(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.visible || !this.isOpen) {
            return;
        }
        this.renderDropdown(graphics, mouseX, mouseY);
    }

    private void renderDropdown(GuiGraphics graphics, int mouseX, int mouseY) {
        int optionIndex;
        int dropdownY = this.getY() + this.height;
        int visibleItems = Math.min(this.options.size(), 5);
        int dropdownHeight = visibleItems * 20;
        boolean needsScrollbar = this.options.size() > 5;
        int dropdownWidth = needsScrollbar ? this.width : this.width;
        graphics.fill(this.getX() - 2, dropdownY - 2, this.getX() + dropdownWidth + 2, dropdownY + dropdownHeight + 2, -872415232);
        graphics.fill(this.getX(), dropdownY, this.getX() + dropdownWidth, dropdownY + dropdownHeight, -13882324);
        graphics.vLine(this.getX(), dropdownY, dropdownY + dropdownHeight, -14803426);
        graphics.vLine(this.getX() + dropdownWidth - 1, dropdownY, dropdownY + dropdownHeight, -10855846);
        graphics.hLine(this.getX(), this.getX() + dropdownWidth, dropdownY + dropdownHeight - 1, -10855846);
        this.hoveredIndex = -1;
        for (int i = 0; i < visibleItems && (optionIndex = i + this.scrollOffset) < this.options.size(); ++i) {
            BlockState iconBlock;
            int itemWidth;
            int itemY = dropdownY + i * 20;
            int n = itemWidth = needsScrollbar ? this.width - 6 : this.width;
            if (mouseX >= this.getX() && mouseX < this.getX() + itemWidth && mouseY >= itemY && mouseY < itemY + 20) {
                this.hoveredIndex = optionIndex;
                graphics.fill(this.getX(), itemY, this.getX() + itemWidth, itemY + 20, -11776948);
            }
            if (optionIndex == this.selectedIndex) {
                graphics.fill(this.getX() + 2, itemY + 2, this.getX() + itemWidth - 2, itemY + 20 - 2, 0x40FFFFFF);
            }
            Component itemText = this.displayFunction.apply(this.options.get(optionIndex));
            int itemTextX = this.getX() + 6;
            int itemTextY = itemY + 6;
            int iconOffset = 0;
            if (this.iconProvider != null && (iconBlock = this.iconProvider.apply(this.options.get(optionIndex))) != null) {
                graphics.pose().pushPose();
                graphics.pose().translate((float)itemTextX, (float)(itemY + 2), 0.0f);
                graphics.pose().scale(0.95f, 0.95f, 0.95f);
                graphics.renderItem(new ItemStack((ItemLike)iconBlock.getBlock()), 0, 0);
                graphics.pose().popPose();
                iconOffset = 20;
            }
            graphics.drawString(Minecraft.getInstance().font, itemText, itemTextX + iconOffset, itemTextY, 0xFFFFFF, false);
            if (i >= visibleItems - 1) continue;
            graphics.hLine(this.getX() + 2, this.getX() + itemWidth - 2, itemY + 20 - 1, -14803426);
        }
        if (needsScrollbar) {
            this.renderScrollbar(graphics, mouseX, mouseY, dropdownY, dropdownHeight);
        }
    }

    private void renderScrollbar(GuiGraphics graphics, int mouseX, int mouseY, int dropdownY, int dropdownHeight) {
        int scrollbarX = this.getX() + this.width - 6;
        graphics.fill(scrollbarX, dropdownY, this.getX() + this.width, dropdownY + dropdownHeight, -14803426);
        graphics.vLine(scrollbarX - 1, dropdownY, dropdownY + dropdownHeight, -14803426);
        int maxScroll = Math.max(0, this.options.size() - 5);
        float scrollPercentage = maxScroll > 0 ? (float)this.scrollOffset / (float)maxScroll : 0.0f;
        int handleHeight = Math.max(20, dropdownHeight * 5 / this.options.size());
        int handleY = dropdownY + (int)((float)(dropdownHeight - handleHeight) * scrollPercentage);
        boolean isHoveringScrollbar = mouseX >= scrollbarX && mouseX < this.getX() + this.width && mouseY >= handleY && mouseY < handleY + handleHeight;
        int handleColor = this.isDraggingScrollbar || isHoveringScrollbar ? -9803158 : -11908534;
        graphics.fill(scrollbarX + 1, handleY, this.getX() + this.width - 1, handleY + handleHeight, handleColor);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (button == 0) {
            if (this.isOpen) {
                int clickedIndex;
                int itemWidth;
                int dropdownY = this.getY() + this.height;
                int visibleItems = Math.min(this.options.size(), 5);
                boolean needsScrollbar = this.options.size() > 5;
                int n = itemWidth = needsScrollbar ? this.width - 6 : this.width;
                if (needsScrollbar && mouseX >= (double)(this.getX() + this.width - 6) && mouseX < (double)(this.getX() + this.width)) {
                    int dropdownHeight = visibleItems * 20;
                    int maxScroll = Math.max(0, this.options.size() - 5);
                    float scrollPercentage = maxScroll > 0 ? (float)this.scrollOffset / (float)maxScroll : 0.0f;
                    int handleHeight = Math.max(20, dropdownHeight * 5 / this.options.size());
                    int handleY = dropdownY + (int)((float)(dropdownHeight - handleHeight) * scrollPercentage);
                    if (mouseY >= (double)handleY && mouseY < (double)(handleY + handleHeight)) {
                        this.isDraggingScrollbar = true;
                        this.scrollbarDragOffset = (int)mouseY - handleY;
                        return true;
                    }
                    if (mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight)) {
                        float clickPosition = (float)(mouseY - (double)dropdownY) / (float)dropdownHeight;
                        this.scrollOffset = Mth.clamp((int)((int)(clickPosition * (float)(maxScroll + 1))), (int)0, (int)maxScroll);
                        return true;
                    }
                }
                if (mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + itemWidth) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + visibleItems * 20) && (clickedIndex = (int)((mouseY - (double)dropdownY) / 20.0) + this.scrollOffset) >= 0 && clickedIndex < this.options.size()) {
                    this.selectedIndex = clickedIndex;
                    this.updateMessage();
                    this.onSelectionChange.accept(this.options.get(this.selectedIndex));
                    this.isOpen = false;
                    return true;
                }
                this.isOpen = false;
                return true;
            }
            if (mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height)) {
                this.isOpen = true;
                return true;
            }
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.visible) {
            return false;
        }
        if (this.isDraggingScrollbar && button == 0) {
            int dropdownY = this.getY() + this.height;
            int visibleItems = Math.min(this.options.size(), 5);
            int dropdownHeight = visibleItems * 20;
            int maxScroll = Math.max(0, this.options.size() - 5);
            int handleHeight = Math.max(20, dropdownHeight * 5 / this.options.size());
            int newHandleY = (int)mouseY - this.scrollbarDragOffset;
            float scrollPercentage = (float)(newHandleY - dropdownY) / (float)Math.max(1, dropdownHeight - handleHeight);
            this.scrollOffset = Mth.clamp((int)((int)(scrollPercentage * (float)maxScroll)), (int)0, (int)maxScroll);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        if (button == 0) {
            this.isDraggingScrollbar = false;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (!this.visible || !this.isOpen) {
            return false;
        }
        if (this.options.size() > 5) {
            int dropdownY = this.getY() + this.height;
            int visibleItems = Math.min(this.options.size(), 5);
            int dropdownHeight = visibleItems * 20;
            if (mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY >= (double)dropdownY && mouseY < (double)(dropdownY + dropdownHeight)) {
                int maxScroll = Math.max(0, this.options.size() - 5);
                int scrollAmount = deltaY > 0.0 ? -1 : 1;
                this.scrollOffset = Mth.clamp((int)(this.scrollOffset + scrollAmount), (int)0, (int)maxScroll);
                return true;
            }
        }
        return false;
    }

    public void updateOptions(List<Integer> newOptions, int newSelectedIndex) {
        boolean selectionChanged;
        boolean optionsChanged = !this.options.equals(newOptions);
        boolean bl = selectionChanged = this.selectedIndex != newSelectedIndex;
        if (!optionsChanged && !selectionChanged) {
            return;
        }
        int oldScrollOffset = this.scrollOffset;
        this.options.clear();
        this.options.addAll(newOptions);
        this.selectedIndex = newSelectedIndex;
        int maxScroll = Math.max(0, this.options.size() - 5);
        this.scrollOffset = Math.min(oldScrollOffset, maxScroll);
        this.updateMessage();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void close() {
        this.isOpen = false;
    }

    public void setIconProvider(Function<Integer, BlockState> iconProvider) {
        this.iconProvider = iconProvider;
    }

    public void refreshDisplay() {
        this.updateMessage();
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

