/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.gui.widget;

import com.asger.mechtrowel.compat.framedblocks.FramedBlockConfig;
import com.asger.mechtrowel.compat.framedblocks.FramedBlocksCompat;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.RotationLockData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.util.BlockRotationHelper;
import com.asger.mechtrowel.util.CopycatRenderHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;

public class Block3DPreview
extends AbstractWidget {
    private final Minecraft minecraft;
    private BlockState blockState;
    private RotationLockData rotationData;
    private Player player;
    private PaletteData.WeightedBlock weightedBlock;
    private BlockState copycatMaterial;
    private BlockState framedCamo;
    private TrowelData trowelData;
    private final Quaternionf viewRotation = new Quaternionf();
    private final Quaternionf baseRotation = new Quaternionf();
    private final Vector2f lastMousePos = new Vector2f();
    private boolean isDragging = false;
    private float rotationSensitivity = 0.5f;
    private float time = 0.0f;
    private float transitionTime = 0.0f;
    private boolean inTransition = false;
    private boolean cyclingPaused = false;
    private float scale = 1.0f;
    private float targetScale = 1.0f;
    private float playerYaw = 0.0f;
    private BlockState lastCalculatedState = null;

    public Block3DPreview(int x, int y, int width, int height, BlockState blockState) {
        super(x, y, width, height, (Component)Component.literal((String)"Block Preview"));
        this.minecraft = Minecraft.getInstance();
        this.blockState = blockState;
        this.active = true;
        this.visible = true;
    }

    public void setBlockState(BlockState blockState) {
        if (this.blockState != blockState) {
            this.blockState = blockState;
            this.lastCalculatedState = null;
            this.copycatMaterial = null;
            this.framedCamo = null;
            this.weightedBlock = null;
            this.inTransition = true;
            this.transitionTime = 0.0f;
        }
    }

    public void setWeightedBlock(PaletteData.WeightedBlock weightedBlock) {
        FramedBlockConfig framedConfig;
        this.weightedBlock = weightedBlock;
        this.copycatMaterial = weightedBlock != null && CopycatRenderHelper.isCopycatBlock(weightedBlock.getState().getBlock()) ? CopycatRenderHelper.getMaterialFromConfig(weightedBlock) : null;
        this.framedCamo = weightedBlock != null && FramedBlocksCompat.isFramedBlock(weightedBlock.getState().getBlock()) ? ((framedConfig = weightedBlock.getFramedConfig()) != null && framedConfig.isConfigured() ? framedConfig.getCamo() : null) : null;
    }

    public void setRotationData(RotationLockData rotationData) {
        this.rotationData = rotationData;
        this.lastCalculatedState = null;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setTrowelData(TrowelData trowelData) {
        this.trowelData = trowelData;
    }

    public void setSyncWithPlayer(boolean sync) {
    }

    public void setPlayerYaw(float yaw) {
        this.playerYaw = yaw;
        this.lastCalculatedState = null;
        this.updateBaseRotation();
    }

    private void updateBaseRotation() {
        this.baseRotation.identity();
        float normalizedYaw = this.playerYaw % 360.0f;
        if (normalizedYaw < 0.0f) {
            normalizedYaw += 360.0f;
        }
        float snappedYaw = normalizedYaw < 45.0f || normalizedYaw >= 315.0f ? 0.0f : (normalizedYaw < 135.0f ? 90.0f : (normalizedYaw < 225.0f ? 180.0f : 270.0f));
        this.baseRotation.rotateY((float)Math.toRadians(-snappedYaw));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.blockState == null) {
            return;
        }
        this.time += partialTick * 0.05f;
        if (this.inTransition) {
            this.transitionTime += partialTick * 0.1f;
            if (this.transitionTime >= 1.0f) {
                this.transitionTime = 1.0f;
                this.inTransition = false;
            }
        }
        this.scale = Mth.lerp((float)0.1f, (float)this.scale, (float)this.targetScale);
        this.renderBackground(graphics);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)this.getX() + (double)this.width / 2.0, (double)this.getY() + (double)this.height / 2.0, 150.0);
        float baseScale = (float)Math.min(this.width, this.height) * 0.55f * this.scale;
        if (this.inTransition) {
            float transitionScale = 1.0f + (float)Math.sin((double)this.transitionTime * Math.PI) * 0.1f;
            baseScale *= transitionScale;
        }
        poseStack.scale(baseScale, -baseScale, baseScale);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableScissor((int)((int)((double)this.getX() * this.minecraft.getWindow().getGuiScale())), (int)((int)((double)this.minecraft.getWindow().getHeight() - (double)(this.getY() + this.height) * this.minecraft.getWindow().getGuiScale())), (int)((int)((double)this.width * this.minecraft.getWindow().getGuiScale())), (int)((int)((double)this.height * this.minecraft.getWindow().getGuiScale())));
        if (this.blockState.getBlock() instanceof StairBlock) {
            normalizedYaw = this.playerYaw % 360.0f;
            if (normalizedYaw < 0.0f) {
                normalizedYaw += 360.0f;
            }
            boolean facingNorthSouth = normalizedYaw < 45.0f || normalizedYaw >= 315.0f || normalizedYaw >= 135.0f && normalizedYaw < 225.0f;
            poseStack.mulPose(this.viewRotation);
            if (facingNorthSouth) {
                Quaternionf invertedBase = new Quaternionf((Quaternionfc)this.baseRotation);
                invertedBase.rotateY((float)Math.PI);
                poseStack.mulPose(invertedBase);
            } else {
                poseStack.mulPose(this.baseRotation);
            }
        } else {
            float snappedYaw;
            poseStack.mulPose(this.viewRotation);
            normalizedYaw = this.playerYaw % 360.0f;
            if (normalizedYaw < 0.0f) {
                normalizedYaw += 360.0f;
            }
            if ((snappedYaw = normalizedYaw < 45.0f || normalizedYaw >= 315.0f ? 0.0f : (normalizedYaw < 135.0f ? 90.0f : (normalizedYaw < 225.0f ? 180.0f : 270.0f))) == 90.0f || snappedYaw == 270.0f) {
                Quaternionf adjustedBase = new Quaternionf();
                adjustedBase.rotateY((float)Math.toRadians(-snappedYaw - 180.0f));
                poseStack.mulPose(adjustedBase);
            } else {
                poseStack.mulPose(this.baseRotation);
            }
        }
        BlockState rotatedState = this.getRotatedBlockState();
        poseStack.pushPose();
        if (this.blockState.getBlock() instanceof StairBlock) {
            poseStack.mulPose(Axis.XP.rotationDegrees(30.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(45.0f));
        }
        this.applyBlockRotation(poseStack, rotatedState);
        poseStack.translate(-0.5, -0.5, -0.5);
        Lighting.setupFor3DItems();
        this.renderBlock(poseStack, rotatedState);
        poseStack.popPose();
        poseStack.popPose();
        RenderSystem.disableScissor();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        if (this.isDragging) {
            this.renderDragIndicators(graphics);
        } else if (this.isHovered) {
            int hoverColor = 0x20FFFFFF;
            graphics.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, hoverColor);
        }
        if (this.isHovered && !this.isDragging) {
            this.renderControlHints(graphics, mouseX, mouseY);
        }
        if (this.cyclingPaused) {
            this.renderPauseIndicator(graphics);
        }
    }

    private void renderBackground(GuiGraphics graphics) {
        int bgColor = -6579301;
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bgColor);
        graphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, -13158601);
        graphics.fill(this.getX(), this.getY(), this.getX() + 1, this.getY() + this.height, -13158601);
        graphics.fill(this.getX() + 1, this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, -1);
        graphics.fill(this.getX() + this.width - 1, this.getY() + 1, this.getX() + this.width, this.getY() + this.height, -1);
        int innerMargin = 3;
        int innerX = this.getX() + innerMargin;
        int innerY = this.getY() + innerMargin;
        int innerWidth = this.width - innerMargin * 2;
        int innerHeight = this.height - innerMargin * 2;
        graphics.fill(innerX, innerY, innerX + innerWidth, innerY + innerHeight, -5921371);
        this.renderGridPattern(graphics, innerX, innerY, innerWidth, innerHeight);
        graphics.fill(innerX, innerY, innerX + innerWidth, innerY + 1, -11184811);
        graphics.fill(innerX, innerY, innerX + 1, innerY + innerHeight, -11184811);
        graphics.fill(innerX + 1, innerY + innerHeight - 1, innerX + innerWidth, innerY + innerHeight, -3355444);
        graphics.fill(innerX + innerWidth - 1, innerY + 1, innerX + innerWidth, innerY + innerHeight, -3355444);
    }

    private void renderGridPattern(GuiGraphics graphics, int x, int y, int width, int height) {
        int i;
        int gridSize = 8;
        int gridColor = 0x20000000;
        for (i = gridSize; i < width; i += gridSize) {
            graphics.fill(x + i, y, x + i + 1, y + height, gridColor);
        }
        for (i = gridSize; i < height; i += gridSize) {
            graphics.fill(x, y + i, x + width, y + i + 1, gridColor);
        }
        int dotColor = 0x40000000;
        for (int ix = 0; ix <= width; ix += gridSize) {
            for (int iy = 0; iy <= height; iy += gridSize) {
                if (ix <= 0 || ix >= width || iy <= 0 || iy >= height) continue;
                graphics.fill(x + ix - 1, y + iy - 1, x + ix + 1, y + iy + 1, dotColor);
            }
        }
    }

    private boolean isAxisBlock(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.AXIS);
    }

    private void applyBlockRotation(PoseStack poseStack, BlockState state) {
        if (this.isAxisBlock(state)) {
            return;
        }
        if (state.hasProperty((Property)BlockStateProperties.FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            this.applyDirectionRotation(poseStack, facing);
        } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            this.applyHorizontalDirectionRotation(poseStack, facing);
        }
    }

    private void applyDirectionRotation(PoseStack poseStack, Direction dir) {
        switch (dir) {
            case DOWN: {
                poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
    }

    private void applyHorizontalDirectionRotation(PoseStack poseStack, Direction dir) {
        if (this.blockState.getBlock() instanceof StairBlock || this.blockState.getBlock() instanceof FenceGateBlock) {
            return;
        }
        switch (dir) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            }
        }
    }

    private void renderBlock(PoseStack poseStack, BlockState state) {
        BlockRenderDispatcher dispatcher = this.minecraft.getBlockRenderer();
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        float bounce = (float)Math.sin((double)this.time * 1.2) * 0.02f;
        poseStack.translate(0.0f, bounce, 0.0f);
        BlockState stateToRender = state;
        if (this.copycatMaterial != null && CopycatRenderHelper.isCopycatBlock(state.getBlock()) && !CopycatRenderHelper.isCopycatBlock(this.copycatMaterial.getBlock())) {
            stateToRender = this.copycatMaterial;
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                if (stateToRender.hasProperty((Property)BlockStateProperties.FACING)) {
                    stateToRender = (BlockState)stateToRender.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
                }
            } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (stateToRender.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    stateToRender = (BlockState)stateToRender.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
            }
        } else if (this.copycatMaterial != null && CopycatRenderHelper.isCopycatBlock(this.copycatMaterial.getBlock())) {
            stateToRender = state;
        } else if (this.framedCamo != null && FramedBlocksCompat.isFramedBlock(state.getBlock()) && !FramedBlocksCompat.isFramedBlock(this.framedCamo.getBlock())) {
            stateToRender = this.framedCamo;
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                if (stateToRender.hasProperty((Property)BlockStateProperties.FACING)) {
                    stateToRender = (BlockState)stateToRender.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
                }
            } else if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                if (stateToRender.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    stateToRender = (BlockState)stateToRender.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
                }
            }
        } else if (this.framedCamo != null && FramedBlocksCompat.isFramedBlock(this.framedCamo.getBlock())) {
            stateToRender = state;
        }
        dispatcher.renderSingleBlock(stateToRender, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.cutout());
        bufferSource.endBatch();
    }

    private void renderDebugInfo(GuiGraphics graphics) {
        String facingDir;
        float snappedYaw;
        int x = 5;
        int y = 5;
        int color = 0xFFFFFF;
        int lines = 10;
        int debugHeight = lines * 10 + 5;
        int debugWidth = 220;
        graphics.fill(x, y, x + debugWidth, y + debugHeight, -872415232);
        graphics.drawString(this.minecraft.font, "Yaw: " + String.format("%.1f", Float.valueOf(this.playerYaw)), x + 2, y += 2, color, false);
        y += 10;
        float normalizedYaw = this.playerYaw % 360.0f;
        if (normalizedYaw < 0.0f) {
            normalizedYaw += 360.0f;
        }
        if (normalizedYaw < 45.0f || normalizedYaw >= 315.0f) {
            snappedYaw = 0.0f;
            facingDir = "SOUTH";
        } else if (normalizedYaw < 135.0f) {
            snappedYaw = 90.0f;
            facingDir = "WEST";
        } else if (normalizedYaw < 225.0f) {
            snappedYaw = 180.0f;
            facingDir = "NORTH";
        } else {
            snappedYaw = 270.0f;
            facingDir = "EAST";
        }
        graphics.drawString(this.minecraft.font, "Snapped: " + snappedYaw + " (" + facingDir + ")", x + 2, y, color, false);
        y += 10;
        if (this.rotationData != null && !this.rotationData.getLockedFaces().isEmpty()) {
            Object locked = "Locked: ";
            for (Direction dir : this.rotationData.getLockedFaces()) {
                locked = (String)locked + dir.name() + " ";
            }
            graphics.drawString(this.minecraft.font, (String)locked, x + 2, y, 0xFF00FF, false);
            y += 10;
        }
        if (this.lastCalculatedState != null && this.lastCalculatedState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction facing = (Direction)this.lastCalculatedState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            graphics.drawString(this.minecraft.font, "H-Facing: " + String.valueOf(facing), x + 2, y, 65535, false);
            y += 10;
            if (this.blockState.getBlock() instanceof StairBlock) {
                graphics.drawString(this.minecraft.font, "Visual: " + String.valueOf(facing.getOpposite()), x + 2, y, 0xFFFF00, false);
                boolean facingNorthSouth = facingDir.equals("NORTH") || facingDir.equals("SOUTH");
                graphics.drawString(this.minecraft.font, "Cam Inverted: " + (facingNorthSouth ? "YES" : "NO"), x + 2, y += 10, 0xFF8800, false);
                y += 10;
            }
        }
        if (this.lastCalculatedState != null && this.isAxisBlock(this.lastCalculatedState)) {
            Direction.Axis axis = (Direction.Axis)this.lastCalculatedState.getValue((Property)BlockStateProperties.AXIS);
            graphics.drawString(this.minecraft.font, "AXIS BLOCK: " + String.valueOf(axis), x + 2, y, 0xFF00FF, false);
            graphics.drawString(this.minecraft.font, "Rotation Bypassed", x + 2, y += 10, 0x8800FF, false);
            y += 10;
        }
        if (this.player != null) {
            graphics.drawString(this.minecraft.font, "Player Dir: " + String.valueOf(this.player.getDirection()), x + 2, y, 65280, false);
            y += 10;
            if (this.blockState != null && !(this.blockState.getBlock() instanceof StairBlock)) {
                boolean eastWest = facingDir.equals("EAST") || facingDir.equals("WEST");
                graphics.drawString(this.minecraft.font, "Normal Block E/W Fix: " + (eastWest ? "YES" : "NO"), x + 2, y, 0xFF8800, false);
            }
        }
    }

    private BlockState getRotatedBlockState() {
        BlockState rotated;
        if (this.player == null || this.rotationData == null) {
            return this.blockState;
        }
        Direction clickedFace = Direction.UP;
        this.lastCalculatedState = rotated = BlockRotationHelper.applyRotation(this.blockState, this.rotationData, this.player, clickedFace);
        return rotated;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.minecraft.screen != null) {
                this.minecraft.screen.setFocused((GuiEventListener)this);
            }
            if (button == 0) {
                this.isDragging = true;
                this.lastMousePos.set((float)mouseX, (float)mouseY);
                return true;
            }
            if (button == 1) {
                this.viewRotation.identity();
                this.targetScale = 1.0f;
                return true;
            }
            if (button == 2) {
                this.cyclingPaused = !this.cyclingPaused;
                return true;
            }
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            return true;
        }
        return false;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.isDragging = false;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && button == 0) {
            float deltaX = (float)(mouseX - (double)this.lastMousePos.x);
            float deltaY = (float)(mouseY - (double)this.lastMousePos.y);
            float currentSensitivity = this.rotationSensitivity;
            if (Screen.hasShiftDown()) {
                currentSensitivity *= 0.2f;
            }
            float angleX = deltaY * currentSensitivity * 0.01f;
            float angleY = deltaX * currentSensitivity * 0.01f;
            Quaternionf deltaRotation = new Quaternionf();
            deltaRotation.rotateY(angleY);
            deltaRotation.rotateLocalX(angleX);
            deltaRotation.mul((Quaternionfc)this.viewRotation, this.viewRotation);
            this.viewRotation.normalize();
            this.lastMousePos.set((float)mouseX, (float)mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.targetScale += (float)deltaY * 0.1f;
            this.targetScale = Mth.clamp((float)this.targetScale, (float)0.5f, (float)5.0f);
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
        output.add(NarratedElementType.TITLE, (Component)Component.literal((String)"3D Block Preview"));
        if (this.blockState != null) {
            output.add(NarratedElementType.HINT, (Component)Component.translatable((String)"narration.mechtrowel.block_preview", (Object[])new Object[]{this.blockState.getBlock().getName()}));
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getX() + this.width) && mouseY < (double)(this.getY() + this.height);
    }

    public boolean isFocused() {
        return this.isDragging || super.isFocused();
    }

    public boolean isShowingCopycat() {
        return this.copycatMaterial != null && CopycatRenderHelper.isCopycatBlock(this.blockState.getBlock());
    }

    public BlockState getCopycatMaterial() {
        return this.copycatMaterial;
    }

    public boolean isShowingFramed() {
        return this.framedCamo != null && FramedBlocksCompat.isFramedBlock(this.blockState.getBlock());
    }

    public BlockState getFramedCamo() {
        return this.framedCamo;
    }

    public PaletteData.WeightedBlock getWeightedBlock() {
        return this.weightedBlock;
    }

    public boolean isCyclingPaused() {
        return this.cyclingPaused;
    }

    public void resetViewRotation() {
        this.viewRotation.identity();
    }

    public void resetZoom() {
        this.targetScale = 1.0f;
        this.scale = 1.0f;
    }

    public void resumeCycling() {
        this.cyclingPaused = false;
    }

    private void renderDragIndicators(GuiGraphics graphics) {
        int cornerSize = 12;
        int lineWidth = 2;
        int color = -16724992;
        float pulse = (float)(Math.sin((double)this.time * 1.5) * 0.3 + 0.7);
        int animatedSize = (int)((float)cornerSize * pulse);
        graphics.fill(this.getX(), this.getY(), this.getX() + animatedSize, this.getY() + lineWidth, color);
        graphics.fill(this.getX(), this.getY(), this.getX() + lineWidth, this.getY() + animatedSize, color);
        graphics.fill(this.getX() + this.width - animatedSize, this.getY(), this.getX() + this.width, this.getY() + lineWidth, color);
        graphics.fill(this.getX() + this.width - lineWidth, this.getY(), this.getX() + this.width, this.getY() + animatedSize, color);
        graphics.fill(this.getX(), this.getY() + this.height - lineWidth, this.getX() + animatedSize, this.getY() + this.height, color);
        graphics.fill(this.getX(), this.getY() + this.height - animatedSize, this.getX() + lineWidth, this.getY() + this.height, color);
        graphics.fill(this.getX() + this.width - animatedSize, this.getY() + this.height - lineWidth, this.getX() + this.width, this.getY() + this.height, color);
        graphics.fill(this.getX() + this.width - lineWidth, this.getY() + this.height - animatedSize, this.getX() + this.width, this.getY() + this.height, color);
    }

    private void renderControlHints(GuiGraphics graphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> hints = new ArrayList<MutableComponent>();
        boolean hasPaletteInfo = false;
        if (this.trowelData != null) {
            if (this.trowelData.getBuildingMode() == TrowelData.BuildingMode.BUILDER) {
                PaletteData palette = this.trowelData.getActivePalette();
                if (palette != null && !palette.getName().isEmpty()) {
                    hasPaletteInfo = true;
                    ItemStack iconStack = ItemStack.EMPTY;
                    if (palette.getIconBlock() != null) {
                        iconStack = new ItemStack((ItemLike)palette.getIconBlock().getBlock());
                    }
                    if (!iconStack.isEmpty()) {
                        hints.add(Component.literal((String)"Active Palette:     ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)palette.getName()).withStyle(ChatFormatting.WHITE)));
                    } else {
                        hints.add(Component.literal((String)"Active Palette: ").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)palette.getName()).withStyle(ChatFormatting.WHITE)));
                    }
                    hints.add(Component.empty());
                    hints.add(Component.literal((String)"Blocks: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(palette.getBlocks().size())).withStyle(ChatFormatting.AQUA)));
                    if (this.copycatMaterial != null && this.weightedBlock != null && this.blockState != null) {
                        hints.add(Component.empty());
                        String copycatType = this.blockState.getBlock().getName().getString();
                        if (copycatType.toLowerCase().contains("copycat")) {
                            copycatType = copycatType.replaceFirst("(?i)copycat\\s*", "").trim();
                        }
                        hints.add(Component.literal((String)"Copycat Block: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)copycatType).withStyle(ChatFormatting.GREEN)));
                        hints.add(Component.literal((String)"Copycat Material: ").withStyle(ChatFormatting.GRAY).append((Component)this.copycatMaterial.getBlock().getName().copy().withStyle(ChatFormatting.YELLOW)));
                    }
                    if (!iconStack.isEmpty()) {
                        int tooltipX = mouseX + 12;
                        int tooltipY = mouseY - 12;
                        if (tooltipX + 150 > this.minecraft.getWindow().getGuiScaledWidth()) {
                            tooltipX = mouseX - 162;
                        }
                        graphics.renderTooltip(this.minecraft.font, hints, Optional.empty(), tooltipX, tooltipY);
                        String prefixText = "Active Palette: ";
                        int prefixWidth = this.minecraft.font.width(prefixText);
                        graphics.pose().pushPose();
                        graphics.pose().translate(0.0f, 0.0f, 400.0f);
                        graphics.renderItem(iconStack, tooltipX + 8 + prefixWidth, tooltipY - 16);
                        graphics.pose().popPose();
                        return;
                    }
                }
            } else if (this.trowelData.getBuildingMode() == TrowelData.BuildingMode.QUICK) {
                hasPaletteInfo = true;
                hints.add(Component.literal((String)"Quick Build Mode").withStyle(ChatFormatting.GOLD));
                hints.add(Component.literal((String)"Using blocks from hotbar").withStyle(ChatFormatting.GRAY));
                int blockCount = 0;
                if (this.player != null) {
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = this.player.getInventory().getItem(i);
                        if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
                        ++blockCount;
                    }
                }
                hints.add(Component.literal((String)"Available blocks: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(blockCount)).withStyle(ChatFormatting.AQUA)));
            }
        }
        if (!hasPaletteInfo) {
            return;
        }
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY - 12;
        if (tooltipX + 150 > this.minecraft.getWindow().getGuiScaledWidth()) {
            tooltipX = mouseX - 162;
        }
        graphics.renderTooltip(this.minecraft.font, hints, Optional.empty(), tooltipX, tooltipY);
    }

    private void renderPauseIndicator(GuiGraphics graphics) {
        int indicatorX = this.getX() + 5;
        int indicatorY = this.getY() + 5;
        int size = 14;
        graphics.fill(indicatorX - 1, indicatorY - 1, indicatorX + size + 1, indicatorY + size + 1, Integer.MIN_VALUE);
        int barWidth = 3;
        int barHeight = 8;
        int barGap = 2;
        int centerX = indicatorX + size / 2;
        int centerY = indicatorY + size / 2;
        graphics.fill(centerX - barGap - barWidth, centerY - barHeight / 2, centerX - barGap, centerY + barHeight / 2, -22016);
        graphics.fill(centerX + barGap, centerY - barHeight / 2, centerX + barGap + barWidth, centerY + barHeight / 2, -22016);
    }
}

