/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.data;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class RotationLockData {
    private static final String TAG_LOCKED_FACES = "LockedFaces";
    private static final String TAG_STAIR_MODE = "StairMode";
    private static final String TAG_SLAB_MODE = "SlabMode";
    private static final String TAG_OPEN_MODE = "OpenMode";
    private static final String TAG_STAIR_LINK = "StairLink";
    private static final String TAG_DYNAMIC_ROTATION = "DynamicRotation";
    private final Set<Direction> lockedFaces = EnumSet.noneOf(Direction.class);
    private StairMode stairMode = StairMode.AUTO;
    private SlabMode slabMode = SlabMode.AUTO;
    private OpenMode openMode = OpenMode.AUTO;
    private boolean stairLink = true;
    private boolean dynamicRotation = true;

    public void load(CompoundTag tag) {
        this.lockedFaces.clear();
        if (tag.contains(TAG_LOCKED_FACES)) {
            int faces = tag.getInt(TAG_LOCKED_FACES);
            for (Direction dir : Direction.values()) {
                if ((faces & 1 << dir.ordinal()) == 0) continue;
                this.lockedFaces.add(dir);
            }
        }
        this.stairMode = StairMode.fromString(tag.getString(TAG_STAIR_MODE));
        this.slabMode = SlabMode.fromString(tag.getString(TAG_SLAB_MODE));
        this.openMode = OpenMode.fromString(tag.getString(TAG_OPEN_MODE));
        this.stairLink = tag.contains(TAG_STAIR_LINK) ? tag.getBoolean(TAG_STAIR_LINK) : true;
        this.dynamicRotation = tag.contains(TAG_DYNAMIC_ROTATION) ? tag.getBoolean(TAG_DYNAMIC_ROTATION) : true;
    }

    public void save(CompoundTag tag) {
        int faces = 0;
        for (Direction dir : this.lockedFaces) {
            faces |= 1 << dir.ordinal();
        }
        tag.putInt(TAG_LOCKED_FACES, faces);
        tag.putString(TAG_STAIR_MODE, this.stairMode.getName());
        tag.putString(TAG_SLAB_MODE, this.slabMode.getName());
        tag.putString(TAG_OPEN_MODE, this.openMode.getName());
        tag.putBoolean(TAG_STAIR_LINK, this.stairLink);
        tag.putBoolean(TAG_DYNAMIC_ROTATION, this.dynamicRotation);
    }

    public void toggleDirectionLock(Direction direction) {
        if (this.lockedFaces.contains(direction)) {
            this.lockedFaces.remove(direction);
        } else {
            this.lockedFaces.add(direction);
        }
    }

    public boolean isDirectionLocked(Direction direction) {
        return this.lockedFaces.contains(direction);
    }

    public void clearLocks() {
        this.lockedFaces.clear();
    }

    public Set<Direction> getLockedFaces() {
        return this.lockedFaces;
    }

    public StairMode getStairMode() {
        return this.stairMode;
    }

    public void setStairMode(StairMode stairMode) {
        this.stairMode = stairMode;
    }

    public SlabMode getSlabMode() {
        return this.slabMode;
    }

    public void setSlabMode(SlabMode slabMode) {
        this.slabMode = slabMode;
    }

    public void cycleStairMode() {
        StairMode[] modes = StairMode.values();
        this.stairMode = modes[(this.stairMode.ordinal() + 1) % modes.length];
    }

    public void cycleSlabMode() {
        SlabMode[] modes = SlabMode.values();
        this.slabMode = modes[(this.slabMode.ordinal() + 1) % modes.length];
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public void setOpenMode(OpenMode openMode) {
        this.openMode = openMode;
    }

    public void cycleOpenMode() {
        OpenMode[] modes = OpenMode.values();
        this.openMode = modes[(this.openMode.ordinal() + 1) % modes.length];
    }

    public boolean isStairLink() {
        return this.stairLink;
    }

    public void setStairLink(boolean stairLink) {
        this.stairLink = stairLink;
    }

    public boolean isDynamicRotation() {
        return this.dynamicRotation;
    }

    public void setDynamicRotation(boolean dynamicRotation) {
        this.dynamicRotation = dynamicRotation;
    }

    public static enum StairMode {
        AUTO("auto"),
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private StairMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static StairMode fromString(String name) {
            for (StairMode mode : StairMode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return AUTO;
        }
    }

    public static enum SlabMode {
        AUTO("auto"),
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private SlabMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SlabMode fromString(String name) {
            for (SlabMode mode : SlabMode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return AUTO;
        }
    }

    public static enum OpenMode {
        AUTO("auto"),
        OPEN("open"),
        CLOSED("closed");

        private final String name;

        private OpenMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static OpenMode fromString(String name) {
            for (OpenMode mode : OpenMode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return AUTO;
        }
    }
}

