/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.rechiseled;

import com.asger.mechtrowel.MechTrowel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;

public class RechiseledCompat {
    private static boolean rechiseledLoaded = false;
    private static boolean initialized = false;
    private static final Map<Block, Block> variantToBaseCache = new HashMap<Block, Block>();

    public static boolean isRechiseledLoaded() {
        return rechiseledLoaded;
    }

    public static boolean isRechiseledVariant(Block block) {
        if (!rechiseledLoaded) {
            return false;
        }
        try {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            return id != null && "rechiseled".equals(id.getNamespace());
        }
        catch (Exception e) {
            MechTrowel.LOGGER.debug("Error checking if block is Rechiseled variant: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static void init() {
        if (!rechiseledLoaded || initialized) {
            return;
        }
        initialized = true;
        MechTrowel.LOGGER.info("Building Rechiseled variant\u2192base cache using tag introspection...");
        int cachedMappings = 0;
        for (Block block : BuiltInRegistries.BLOCK) {
            Block baseBlock;
            if (!RechiseledCompat.isRechiseledVariant(block) || (baseBlock = RechiseledCompat.findBaseBlockViaTags(block)) == null) continue;
            variantToBaseCache.put(block, baseBlock);
            ++cachedMappings;
        }
        MechTrowel.LOGGER.info("Rechiseled compatibility initialized: {} variant\u2192base mappings cached", (Object)cachedMappings);
    }

    private static Block findBaseBlockViaTags(Block rechiseledVariant) {
        try {
            Holder.Reference blockHolder = BuiltInRegistries.BLOCK.getHolder(BuiltInRegistries.BLOCK.getId((Object)rechiseledVariant)).orElse(null);
            if (blockHolder != null) {
                for (TagKey tag : blockHolder.tags().toList()) {
                    Block baseBlock;
                    String materialName;
                    ResourceLocation baseId;
                    ResourceLocation tagLocation = tag.location();
                    if (!"rechiseled".equals(tagLocation.getNamespace()) || !BuiltInRegistries.BLOCK.containsKey(baseId = ResourceLocation.withDefaultNamespace((String)(materialName = tagLocation.getPath()))) || RechiseledCompat.isRechiseledVariant(baseBlock = (Block)BuiltInRegistries.BLOCK.get(baseId))) continue;
                    return baseBlock;
                }
            }
        }
        catch (Exception e) {
            MechTrowel.LOGGER.debug("Error finding base block via tags for {}: {}", (Object)BuiltInRegistries.BLOCK.getKey((Object)rechiseledVariant), (Object)e.getMessage());
        }
        return null;
    }

    public static Block getBaseBlock(Block rechiseledVariant) {
        if (!rechiseledLoaded) {
            return null;
        }
        if (variantToBaseCache.containsKey(rechiseledVariant)) {
            return variantToBaseCache.get(rechiseledVariant);
        }
        try {
            ResourceLocation baseId;
            String[] knownBases;
            ResourceLocation variantId = BuiltInRegistries.BLOCK.getKey((Object)rechiseledVariant);
            if (variantId == null) {
                return null;
            }
            String variantName = variantId.getPath();
            String baseName = null;
            for (String base : knownBases = new String[]{"polished_blackstone_bricks", "polished_blackstone", "mossy_stone_bricks", "end_stone_bricks", "light_gray_terracotta", "light_blue_terracotta", "mossy_cobblestone", "red_sandstone", "prismarine_bricks", "dark_prismarine", "red_nether_bricks", "smooth_basalt", "quartz_block", "purpur_block", "amethyst_block", "dark_oak_planks", "oak_planks", "spruce_planks", "birch_planks", "jungle_planks", "acacia_planks", "mangrove_planks", "cherry_planks", "bamboo_planks", "crimson_planks", "warped_planks", "white_terracotta", "orange_terracotta", "magenta_terracotta", "yellow_terracotta", "lime_terracotta", "pink_terracotta", "gray_terracotta", "cyan_terracotta", "purple_terracotta", "blue_terracotta", "brown_terracotta", "green_terracotta", "red_terracotta", "black_terracotta", "terracotta", "white_concrete", "orange_concrete", "magenta_concrete", "concrete", "stone_bricks", "mud_bricks", "nether_bricks", "bricks", "packed_mud", "cobblestone", "sandstone", "blackstone", "stone", "granite", "diorite", "andesite", "deepslate", "tuff", "prismarine", "netherrack", "basalt", "calcite"}) {
                if (!variantName.contains(base)) continue;
                baseName = base;
                break;
            }
            if (baseName == null) {
                baseName = variantName.replaceAll("_(large|small|big|tiny|mini|short|tall|wide|narrow|thick|thin)_", "_").replaceAll("^(large|small|big|tiny|mini|short|tall|wide|narrow|thick|thin)_", "").replaceAll("_(pillar|carved|smooth|polished|cut|brick|bricks|tile|tiles|tiled|panel|slab|stairs|wall|fence|button|pressure_plate|trapdoor|door).*$", "");
            }
            if (baseName != null && BuiltInRegistries.BLOCK.containsKey(baseId = ResourceLocation.withDefaultNamespace(baseName))) {
                Block baseBlock = (Block)BuiltInRegistries.BLOCK.get(baseId);
                return baseBlock;
            }
            return null;
        }
        catch (Exception e) {
            MechTrowel.LOGGER.debug("Error getting base block: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static boolean isValidConversion(Block rechiseledVariant, Block baseBlock) {
        if (!rechiseledLoaded) {
            return false;
        }
        if (baseBlock == null) {
            return false;
        }
        if (rechiseledVariant == baseBlock) {
            return false;
        }
        return !RechiseledCompat.isRechiseledVariant(baseBlock);
    }

    static {
        try {
            rechiseledLoaded = ModList.get().isLoaded("rechiseled");
            if (rechiseledLoaded) {
                MechTrowel.LOGGER.info("Rechiseled mod detected, enabling auto-conversion compatibility");
            }
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Error checking for Rechiseled mod", (Throwable)e);
            rechiseledLoaded = false;
        }
    }
}

