/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.framedblocks;

import com.asger.mechtrowel.MechTrowel;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class FramedIntegration {
    public static boolean applyCamo(BlockEntity blockEntity, BlockState camo, Player player) {
        try {
            String camoClassName = camo.getBlock().getClass().getName();
            if (camoClassName.contains("framed") || camoClassName.contains("Framed")) {
                MechTrowel.LOGGER.debug("Blocked framed block as camo: {}", (Object)camo.getBlock().getDescriptionId());
                return false;
            }
            if (camo.hasBlockEntity()) {
                MechTrowel.LOGGER.debug("Blocked BlockEntity block as camo: {}", (Object)camo.getBlock().getDescriptionId());
                return false;
            }
            ItemStack camoStack = new ItemStack((ItemLike)camo.getBlock());
            ItemStack originalItem = player.getMainHandItem();
            player.setItemInHand(InteractionHand.MAIN_HAND, camoStack);
            BlockPos pos = blockEntity.getBlockPos();
            BlockHitResult hitResult = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false);
            Method handleInteraction = blockEntity.getClass().getMethod("handleInteraction", Player.class, InteractionHand.class, BlockHitResult.class);
            handleInteraction.invoke((Object)blockEntity, player, InteractionHand.MAIN_HAND, hitResult);
            player.setItemInHand(InteractionHand.MAIN_HAND, originalItem);
            Method getCamo = blockEntity.getClass().getMethod("getCamo", new Class[0]);
            Object newCamo = getCamo.invoke((Object)blockEntity, new Object[0]);
            if (newCamo != null && !newCamo.toString().contains("Empty")) {
                MechTrowel.LOGGER.debug("Successfully applied camo {} to framed block at {}", (Object)camo.getBlock().getDescriptionId(), (Object)pos);
                return true;
            }
            MechTrowel.LOGGER.warn("Failed to apply camo {} to framed block at {}", (Object)camo.getBlock().getDescriptionId(), (Object)pos);
            return false;
        }
        catch (Exception e) {
            MechTrowel.LOGGER.error("Exception while applying camo to framed block: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

