/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.compat.create;

import com.asger.mechtrowel.compat.create.CopycatBlockConfig;
import java.lang.reflect.Method;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class CopycatIntegration {
    public static boolean applyMaterial(BlockEntity blockEntity, BlockState material, boolean lit, CopycatBlockConfig.AxisMode axisMode, Player player) {
        try {
            String className;
            String materialClassName = material.getBlock().getClass().getName();
            if (materialClassName.contains("copycat") || materialClassName.contains("Copycat")) {
                return false;
            }
            BlockState modifiedMaterial = material;
            if (lit && material.hasProperty((Property)BlockStateProperties.LIT)) {
                modifiedMaterial = (BlockState)modifiedMaterial.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true));
            }
            if (lit) {
                for (Property property : material.getProperties()) {
                    if (!property.getName().equals("powering") || !(property instanceof BooleanProperty)) continue;
                    modifiedMaterial = (BlockState)modifiedMaterial.setValue((Property)((BooleanProperty)property), (Comparable)Boolean.valueOf(true));
                    break;
                }
            }
            if (axisMode != null && axisMode != CopycatBlockConfig.AxisMode.OFF) {
                Direction.Axis axis = axisMode.toAxis();
                if (axis != null && material.hasProperty((Property)BlockStateProperties.AXIS)) {
                    modifiedMaterial = (BlockState)modifiedMaterial.setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
                } else if (axis != null && material.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS) && axis != Direction.Axis.Y) {
                    modifiedMaterial = (BlockState)modifiedMaterial.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)axis);
                }
            }
            if ((className = blockEntity.getClass().getName()).contains("create")) {
                return CopycatIntegration.applyCreateMaterial(blockEntity, modifiedMaterial, player);
            }
            if (className.contains("copycats")) {
                return CopycatIntegration.applyCopycatsPlusMaterial(blockEntity, modifiedMaterial, player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean applyCreateMaterial(BlockEntity blockEntity, BlockState material, Player player) {
        try {
            block13: {
                Method setMaterialMethod = null;
                try {
                    setMaterialMethod = blockEntity.getClass().getMethod("setMaterial", BlockState.class);
                    if (setMaterialMethod == null) break block13;
                    setMaterialMethod.invoke((Object)blockEntity, material);
                    try {
                        Method setConsumedItem = blockEntity.getClass().getMethod("setConsumedItem", ItemStack.class);
                        if (setConsumedItem != null) {
                            ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                            setConsumedItem.invoke((Object)blockEntity, materialStack);
                        }
                    }
                    catch (Exception setConsumedItem) {
                        // empty catch block
                    }
                    blockEntity.setChanged();
                    if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                        blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    }
                    return true;
                }
                catch (NoSuchMethodException setConsumedItem) {
                    // empty catch block
                }
            }
            Method consumeMethod = null;
            for (Method m : blockEntity.getClass().getMethods()) {
                Class<?>[] params;
                if (!m.getName().contains("consume") && !m.getName().contains("setMaterial") || (params = m.getParameterTypes()).length <= 0 || !ItemStack.class.isAssignableFrom(params[0])) continue;
                consumeMethod = m;
                break;
            }
            if (consumeMethod != null) {
                ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                CompoundTag blockStateTag = new CompoundTag();
                for (Property property : material.getProperties()) {
                    String propertyName = property.getName();
                    String propertyValue = CopycatIntegration.getPropertyValueString(material, property);
                    blockStateTag.putString(propertyName, propertyValue);
                }
                if (!blockStateTag.isEmpty()) {
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.put("BlockStateTag", (Tag)blockStateTag);
                    materialStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag));
                }
                consumeMethod.invoke((Object)blockEntity, materialStack, player, false);
                return true;
            }
            CompoundTag nbt = blockEntity.saveWithoutMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            nbt.put("Material", (Tag)NbtUtils.writeBlockState((BlockState)material));
            blockEntity.loadWithComponents(nbt, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            blockEntity.setChanged();
            if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean applyCopycatsPlusMaterial(BlockEntity blockEntity, BlockState material, Player player) {
        try {
            block35: {
                block34: {
                    String className = blockEntity.getClass().getSimpleName();
                    if (className.contains("MultiStateCopycatBlockEntity")) {
                        try {
                            Method setMaterialMethod = blockEntity.getClass().getMethod("setMaterial", String.class, BlockState.class);
                            Method setConsumedItemMethod = blockEntity.getClass().getMethod("setConsumedItem", String.class, ItemStack.class);
                            if (setMaterialMethod == null || setConsumedItemMethod == null) break block34;
                            ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                            BlockState blockState = blockEntity.getBlockState();
                            String slabType = "double";
                            if (blockState.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
                                SlabType type = (SlabType)blockState.getValue((Property)BlockStateProperties.SLAB_TYPE);
                                slabType = type.getSerializedName();
                            }
                            if (blockState.hasProperty((Property)BlockStateProperties.FACING)) {
                                Direction facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
                                if (facing == Direction.DOWN) {
                                    slabType = "top";
                                } else if (facing == Direction.UP) {
                                    slabType = "bottom";
                                }
                            }
                            if (slabType.equals("double")) {
                                setMaterialMethod.invoke((Object)blockEntity, "top", material);
                                setConsumedItemMethod.invoke((Object)blockEntity, "top", materialStack);
                                setMaterialMethod.invoke((Object)blockEntity, "bottom", material);
                                setConsumedItemMethod.invoke((Object)blockEntity, "bottom", materialStack);
                            } else {
                                setMaterialMethod.invoke((Object)blockEntity, slabType, material);
                                setConsumedItemMethod.invoke((Object)blockEntity, slabType, materialStack);
                            }
                            try {
                                Method setMaterialNoString = blockEntity.getClass().getMethod("setMaterial", BlockState.class);
                                Method setConsumedItemNoString = blockEntity.getClass().getMethod("setConsumedItem", ItemStack.class);
                                if (setMaterialNoString != null) {
                                    setMaterialNoString.invoke((Object)blockEntity, material);
                                }
                                if (setConsumedItemNoString != null) {
                                    setConsumedItemNoString.invoke((Object)blockEntity, materialStack);
                                }
                            }
                            catch (Exception setMaterialNoString) {
                                // empty catch block
                            }
                            blockEntity.setChanged();
                            if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                                blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                            }
                            return true;
                        }
                        catch (Exception setMaterialMethod) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Method setMethod = blockEntity.getClass().getMethod("setMaterial", BlockState.class);
                    if (setMethod == null) break block35;
                    setMethod.invoke((Object)blockEntity, material);
                    try {
                        Method setConsumedItem = blockEntity.getClass().getMethod("setConsumedItem", ItemStack.class);
                        if (setConsumedItem != null) {
                            ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                            setConsumedItem.invoke((Object)blockEntity, materialStack);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    blockEntity.setChanged();
                    if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                        blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    }
                    return true;
                }
                catch (NoSuchMethodException setMethod) {
                    // empty catch block
                }
            }
            for (Method m : blockEntity.getClass().getMethods()) {
                Class<?>[] params;
                if (!m.getName().contains("Material") && !m.getName().contains("consume") || (params = m.getParameterTypes()).length <= 0) continue;
                if (BlockState.class.isAssignableFrom(params[0])) {
                    m.invoke((Object)blockEntity, material);
                    if (m.getName().contains("setMaterial") || m.getName().contains("Material")) {
                        try {
                            Method setConsumedItem = blockEntity.getClass().getMethod("setConsumedItem", ItemStack.class);
                            if (setConsumedItem != null) {
                                ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                                setConsumedItem.invoke((Object)blockEntity, materialStack);
                            }
                        }
                        catch (Exception setConsumedItem) {
                            // empty catch block
                        }
                    }
                    blockEntity.setChanged();
                    if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                        blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                    }
                    return true;
                }
                if (!ItemStack.class.isAssignableFrom(params[0])) continue;
                ItemStack materialStack = new ItemStack((ItemLike)material.getBlock());
                CompoundTag blockStateTag = new CompoundTag();
                for (Property property : material.getProperties()) {
                    String propertyName = property.getName();
                    String propertyValue = CopycatIntegration.getPropertyValueString(material, property);
                    blockStateTag.putString(propertyName, propertyValue);
                }
                if (!blockStateTag.isEmpty()) {
                    CompoundTag itemTag = new CompoundTag();
                    itemTag.put("BlockStateTag", (Tag)blockStateTag);
                    materialStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)itemTag));
                }
                m.invoke((Object)blockEntity, materialStack);
                blockEntity.setChanged();
                if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                    blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
                }
                return true;
            }
            CompoundTag nbt = blockEntity.saveWithoutMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            nbt.put("Material", (Tag)NbtUtils.writeBlockState((BlockState)material));
            blockEntity.loadWithComponents(nbt, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            blockEntity.setChanged();
            if (blockEntity.getLevel() != null && !blockEntity.getLevel().isClientSide) {
                blockEntity.getLevel().sendBlockUpdated(blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity.getBlockState(), 3);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static <T extends Comparable<T>> String getPropertyValueString(BlockState state, Property<T> property) {
        return property.getName(state.getValue(property));
    }
}

