/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.command;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.data.PaletteData;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.network.TrowelPacket;
import com.asger.mechtrowel.util.PaletteCodec;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="mechtrowel", value={Dist.CLIENT})
public class ModCommands {
    @SubscribeEvent
    public static void registerCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mechtrowel").then(((LiteralArgumentBuilder)Commands.literal((String)"export").executes(ModCommands::exportCurrentPalette)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ModCommands.exportPaletteByName((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"import").executes(ModCommands::importFromClipboard)).then(Commands.argument((String)"code", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ModCommands.importFromCode((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"code"))))));
    }

    private static ItemStack findTrowel(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() instanceof MechTrowelItem) {
            return stack;
        }
        stack = player.getOffhandItem();
        if (stack.getItem() instanceof MechTrowelItem) {
            return stack;
        }
        for (int i = 0; i < 9; ++i) {
            stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof MechTrowelItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static int exportCurrentPalette(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return 0;
        }
        ItemStack trowel = ModCommands.findTrowel((Player)player);
        if (trowel.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"No Mech Trowel found in hotbar").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        TrowelData data = TrowelData.getOrCreate(trowel);
        PaletteData palette = data.getActivePalette();
        if (palette == null) {
            player.displayClientMessage((Component)Component.literal((String)"No active palette").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        return ModCommands.exportPalette((Player)player, palette);
    }

    private static int exportPaletteByName(CommandContext<CommandSourceStack> ctx, String name) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return 0;
        }
        ItemStack trowel = ModCommands.findTrowel((Player)player);
        if (trowel.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"No Mech Trowel found in hotbar").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        TrowelData data = TrowelData.getOrCreate(trowel);
        PaletteData palette = null;
        for (PaletteData p : data.getPalettes()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            palette = p;
            break;
        }
        if (palette == null) {
            player.displayClientMessage((Component)Component.literal((String)("Palette '" + name + "' not found")).withStyle(ChatFormatting.RED), false);
            return 0;
        }
        return ModCommands.exportPalette((Player)player, palette);
    }

    private static int exportPalette(Player player, PaletteData palette) {
        String code = PaletteCodec.encode(palette);
        if (code != null) {
            Minecraft.getInstance().keyboardHandler.setClipboard(code);
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.palette_exported", (Object[])new Object[]{palette.getName()}), false);
            return 1;
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.palette_export_failed").withStyle(ChatFormatting.RED), false);
        return 0;
    }

    private static int importFromClipboard(CommandContext<CommandSourceStack> ctx) {
        Minecraft mc = Minecraft.getInstance();
        String code = mc.keyboardHandler.getClipboard();
        return ModCommands.importPalette((Player)mc.player, code);
    }

    private static int importFromCode(CommandContext<CommandSourceStack> ctx, String code) {
        Minecraft mc = Minecraft.getInstance();
        return ModCommands.importPalette((Player)mc.player, code);
    }

    private static int importPalette(Player player, String code) {
        if (player == null) {
            return 0;
        }
        ItemStack trowel = ModCommands.findTrowel(player);
        if (trowel.isEmpty()) {
            player.displayClientMessage((Component)Component.literal((String)"No Mech Trowel found in hotbar").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        if (code == null || code.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.clipboard_empty").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        PaletteData imported = PaletteCodec.decode(code);
        if (imported != null) {
            TrowelData data = TrowelData.getOrCreate(trowel);
            if (data.getPalettes().size() >= MechTrowel.Config.getMaxPalettes()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.palette_limit_reached").withStyle(ChatFormatting.RED), false);
                return 0;
            }
            CompoundTag paletteTag = new CompoundTag();
            imported.save(paletteTag);
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.IMPORT_PALETTE, 0, paletteTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
            player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.palette_imported", (Object[])new Object[]{imported.getName()}), false);
            return 1;
        }
        player.displayClientMessage((Component)Component.translatable((String)"message.mechtrowel.palette_import_failed").withStyle(ChatFormatting.RED), false);
        return 0;
    }
}

