/*
 * Decompiled with CFR 0.152.
 */
package com.asger.mechtrowel.client;

import com.asger.mechtrowel.MechTrowel;
import com.asger.mechtrowel.client.RadialMenuScreen;
import com.asger.mechtrowel.data.TrowelData;
import com.asger.mechtrowel.item.MechTrowelItem;
import com.asger.mechtrowel.network.TrowelPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;

public class KeyBindings {
    private static boolean radialKeyPressed = false;
    private static boolean gKeyWasPressed = false;
    private static boolean rKeyWasPressed = false;
    private static boolean vKeyWasPressed = false;
    private static boolean cKeyWasPressed = false;
    public static final Lazy<KeyMapping> OPEN_PALETTE_GUI = Lazy.of(() -> new KeyMapping("key.mechtrowel.open_palette", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 71, "key.categories.mechtrowel"));
    public static final Lazy<KeyMapping> TOGGLE_BUILD_MODE = Lazy.of(() -> new KeyMapping("key.mechtrowel.toggle_build_mode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 82, "key.categories.mechtrowel"));
    public static final Lazy<KeyMapping> TOGGLE_REPLACE = Lazy.of(() -> new KeyMapping("key.mechtrowel.toggle_replace", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "key.categories.mechtrowel"));
    public static final Lazy<KeyMapping> OPEN_RADIAL_MENU = Lazy.of(() -> new KeyMapping("key.mechtrowel.open_radial_menu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, "key.categories.mechtrowel"));
    public static final Lazy<KeyMapping> TOGGLE_CHIPPED = Lazy.of(() -> new KeyMapping("key.mechtrowel.toggle_chipped", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.categories.mechtrowel"));

    public static void register(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)OPEN_PALETTE_GUI.get());
        event.register((KeyMapping)TOGGLE_BUILD_MODE.get());
        event.register((KeyMapping)TOGGLE_REPLACE.get());
        event.register((KeyMapping)OPEN_RADIAL_MENU.get());
        event.register((KeyMapping)TOGGLE_CHIPPED.get());
        NeoForge.EVENT_BUS.addListener(KeyBindings::onKeyInput);
        NeoForge.EVENT_BUS.addListener(KeyBindings::onClientTick);
    }

    private static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        LocalPlayer player = mc.player;
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        ItemStack trowelStack = null;
        if (mainHand.getItem() instanceof MechTrowelItem) {
            trowelStack = mainHand;
        } else if (offHand.getItem() instanceof MechTrowelItem) {
            trowelStack = offHand;
        }
        KeyMapping radialKey = (KeyMapping)OPEN_RADIAL_MENU.get();
        if (radialKey.getKey().getValue() == event.getKey()) {
            if (trowelStack != null) {
                TrowelData data = TrowelData.getOrCreate(trowelStack);
                if (event.getAction() == 1 && !radialKeyPressed) {
                    radialKeyPressed = true;
                    if (mc.screen == null) {
                        mc.setScreen((Screen)new RadialMenuScreen(data));
                    }
                } else if (event.getAction() == 0 && radialKeyPressed) {
                    radialKeyPressed = false;
                    Screen screen = mc.screen;
                    if (screen instanceof RadialMenuScreen) {
                        RadialMenuScreen radialScreen = (RadialMenuScreen)screen;
                        radialScreen.onClose();
                    }
                }
            }
            return;
        }
    }

    private static void onClientTick(ClientTickEvent.Post event) {
        TrowelData data;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        LocalPlayer player = mc.player;
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        ItemStack trowelStack = null;
        if (mainHand.getItem() instanceof MechTrowelItem) {
            trowelStack = mainHand;
        } else if (offHand.getItem() instanceof MechTrowelItem) {
            trowelStack = offHand;
        }
        if (trowelStack == null) {
            gKeyWasPressed = false;
            rKeyWasPressed = false;
            vKeyWasPressed = false;
            cKeyWasPressed = false;
            return;
        }
        boolean gKeyPressed = ((KeyMapping)OPEN_PALETTE_GUI.get()).isDown();
        if (gKeyPressed && !gKeyWasPressed) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.OPEN_PALETTE_GUI, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        gKeyWasPressed = gKeyPressed;
        boolean rKeyPressed = ((KeyMapping)TOGGLE_BUILD_MODE.get()).isDown();
        if (rKeyPressed && !rKeyWasPressed) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.TOGGLE_BUILD_MODE, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        rKeyWasPressed = rKeyPressed;
        boolean vKeyPressed = ((KeyMapping)TOGGLE_REPLACE.get()).isDown();
        if (vKeyPressed && !vKeyWasPressed && MechTrowel.Config.isReplaceModeEnabled()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.TOGGLE_REPLACE, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        vKeyWasPressed = vKeyPressed;
        boolean cKeyPressed = ((KeyMapping)TOGGLE_CHIPPED.get()).isDown();
        if (cKeyPressed && !cKeyWasPressed && (data = TrowelData.getOrCreate(trowelStack)).isChippedConversionEnabled()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrowelPacket(TrowelPacket.Action.TOGGLE_CHIPPED, 0, new CompoundTag()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        cKeyWasPressed = cKeyPressed;
    }
}

